/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class AutosizeTrigger
implements ModelChangeTrigger {
    public static final Adapter AUTO_SIZE_MARKER = new AdapterImpl();
    private TransactionalEditingDomain domain;
    public static final NotificationFilter IS_GMF_NODE_ATTACHMENT = new NotificationFilter.Custom(){

        public boolean matches(Notification input) {
            return input.getNewValue() instanceof Node && input.getFeature() instanceof EReference && ((EReference)input.getFeature()).isContainment();
        }
    };

    public AutosizeTrigger(TransactionalEditingDomain domain) {
        this.domain = domain;
    }

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        final LinkedHashSet toMakeAutosize = Sets.newLinkedHashSet();
        for (Notification notif : notifications) {
            UnmodifiableIterator filter;
            EObject semanticObject;
            Node nd = (Node)notif.getNewValue();
            if (!(nd.getElement() instanceof DSemanticDecorator) || !((semanticObject = ((DSemanticDecorator)nd.getElement()).getTarget()) instanceof EObject) || !(filter = Iterators.filter((Iterator)semanticObject.eAdapters().iterator(), (Predicate)new Predicate<Adapter>(){

                public boolean apply(Adapter input) {
                    return input == AUTO_SIZE_MARKER;
                }
            })).hasNext()) continue;
            semanticObject.eAdapters().remove(filter.next());
            toMakeAutosize.add(nd);
        }
        if (toMakeAutosize.size() > 0) {
            RecordingCommand result = new RecordingCommand(this.domain){

                protected void doExecute() {
                    for (Node node : toMakeAutosize) {
                        if (!(node.getLayoutConstraint() instanceof Bounds)) continue;
                        ((Bounds)node.getLayoutConstraint()).setWidth(-1);
                        ((Bounds)node.getLayoutConstraint()).setHeight(-1);
                    }
                }
            };
            return Options.newSome((Object)result);
        }
        return Options.newNone();
    }

    public int priority() {
        return 0;
    }
}

