/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.filetransfer;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileTransferJob;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileTransferManager;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.Messages;
import org.eclipse.emf.emfstore.internal.server.exceptions.FileTransferException;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FileChunk;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FilePartitionerUtil;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FileTransferInformation;
import org.eclipse.emf.emfstore.internal.server.model.FileIdentifier;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

public class FileUploadJob
extends FileTransferJob {
    public FileUploadJob(FileTransferManager transferManager, FileIdentifier fileId, boolean transferVisibleToUser) throws FileTransferException {
        super(transferManager, new FileTransferInformation(fileId, (int)transferManager.getCache().getCachedFile(fileId).length()), Messages.FileUploadJob_FileUpload);
        this.setUser(transferVisibleToUser);
        this.setFile(this.getCache().getCachedFile(fileId));
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.getConnectionAttributes();
            if (!this.executeTransfer(monitor)) {
                return Status.CANCEL_STATUS;
            }
        }
        catch (ESException e) {
            this.setException((Exception)((Object)e));
            monitor.setCanceled(true);
            monitor.done();
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private boolean executeTransfer(IProgressMonitor monitor) throws ESException {
        FileChunk fileChunk;
        this.initializeMonitor(monitor);
        long transmitted = 0L;
        do {
            fileChunk = FilePartitionerUtil.readChunk((File)this.getFile(), (FileTransferInformation)this.getFileInformation());
            this.getConnectionManager().uploadFileChunk(this.getSessionId(), this.getProjectId(), fileChunk);
            monitor.worked(1);
            monitor.subTask(MessageFormat.format(Messages.FileUploadJob_SendingFile, this.getFile().getName(), transmitted += (long)fileChunk.getData().length, this.getFileInformation().getFileSize()));
            this.incrementChunkNumber();
            if (!this.isCanceled()) continue;
            return false;
        } while (!fileChunk.isLast());
        this.getTransferManager().removeWaitingUpload(this.getFileId());
        return true;
    }
}

