/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.providers;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.models.SnappingModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.providers.ISnappingLocationProvider;

public class BoundsSnappingLocationProvider
implements ISnappingLocationProvider {
    @Override
    public List<SnappingModel.SnappingLocation> getHorizontalSnappingLocations(IContentPart<? extends Node> part) {
        return this.getSnappingLocations(part, Orientation.HORIZONTAL, 0.0, 1.0);
    }

    protected List<SnappingModel.SnappingLocation> getSnappingLocations(IContentPart<? extends Node> part, Orientation orient, double ... ratios) {
        ArrayList<SnappingModel.SnappingLocation> locs;
        block3: {
            Rectangle bounds;
            block2: {
                bounds = NodeUtils.localToScene(part.getVisual(), (IGeometry)NodeUtils.getShapeBounds(part.getVisual())).getBounds();
                locs = new ArrayList<SnappingModel.SnappingLocation>();
                if (orient != Orientation.HORIZONTAL) break block2;
                double[] dArray = ratios;
                int n = ratios.length;
                int n2 = 0;
                while (n2 < n) {
                    double r = dArray[n2];
                    locs.add(new SnappingModel.SnappingLocation(part, Orientation.HORIZONTAL, bounds.getX() + r * bounds.getWidth()));
                    ++n2;
                }
                break block3;
            }
            if (orient != Orientation.VERTICAL) break block3;
            double[] dArray = ratios;
            int n = ratios.length;
            int n3 = 0;
            while (n3 < n) {
                double r = dArray[n3];
                locs.add(new SnappingModel.SnappingLocation(part, Orientation.VERTICAL, bounds.getY() + r * bounds.getHeight()));
                ++n3;
            }
        }
        return locs;
    }

    @Override
    public List<SnappingModel.SnappingLocation> getVerticalSnappingLocations(IContentPart<? extends Node> part) {
        return this.getSnappingLocations(part, Orientation.VERTICAL, 0.0, 1.0);
    }
}

