/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.widgets.internal;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jwt.transformations.api.Transformation;
import org.eclipse.jwt.transformations.api.io.ContentChangeListener;
import org.eclipse.jwt.transformations.api.io.IODefinition;
import org.eclipse.jwt.transformations.widgets.internal.ObjectPickerCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IOGroup
implements IODefinition.IOHandle {
    private final Group delegateControl;
    private final ContentChangeListener pageListener;
    private final IStructuredSelection selection;
    private final String comboText;
    private IOHandlePickerCombo ioDefinitionCombo;
    private Composite ioStackComposite;
    private StackLayout ioStackLayout;

    public IOGroup(Composite parent, ContentChangeListener pageListener, IStructuredSelection selection, String text, String comboText) {
        this.delegateControl = new Group(parent, 0);
        this.selection = selection;
        this.pageListener = pageListener;
        this.comboText = comboText;
        this.delegateControl.setText(text);
        this.delegateControl.setLayout((Layout)new GridLayout(1, false));
        this.setTransformation(null);
    }

    public void setTransformation(Transformation transformation) {
        IOGroup.removeChildren((Composite)this.delegateControl);
        this.ioDefinitionCombo = new IOHandlePickerCombo();
        this.ioStackComposite = new Composite((Composite)this.delegateControl, 0);
        this.ioStackLayout = new StackLayout();
        this.ioStackComposite.setLayoutData((Object)new GridData(1808));
        this.ioStackComposite.setLayout((Layout)this.ioStackLayout);
        if (transformation != null) {
            this.ioDefinitionCombo.setData(this.extractIODefinitions(transformation));
            this.ioDefinitionCombo.getControl().select(0);
            this.ioDefinitionCombo.updateSelection();
            this.delegateControl.getShell().layout(true, true);
            this.delegateControl.getShell().pack();
        }
    }

    private static void removeChildren(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
    }

    protected abstract Collection<IODefinition> extractIODefinitions(Transformation var1);

    @Override
    public void afterTransformation() throws CoreException, IOException {
        ((IODefinition.IOHandle)this.ioDefinitionCombo.getSelection()).afterTransformation();
    }

    public Group getControl() {
        return this.delegateControl;
    }

    @Override
    public Object getValue() {
        return ((IODefinition.IOHandle)this.ioDefinitionCombo.getSelection()).getValue();
    }

    @Override
    public boolean hasAllRequiredInformation() {
        return this.ioDefinitionCombo.getSelection() != null && ((IODefinition.IOHandle)this.ioDefinitionCombo.getSelection()).hasAllRequiredInformation();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IOHandlePickerCombo
    extends ObjectPickerCombo<IODefinition, IODefinition.IOHandle> {
        public IOHandlePickerCombo() {
            super((Composite)IOGroup.this.delegateControl, 0);
            this.getControl().setText(IOGroup.this.comboText);
            this.getControl().setLayoutData((Object)new GridData(768));
        }

        @Override
        protected String extractLabel(IODefinition entry) {
            return entry.getLabel();
        }

        @Override
        protected IODefinition.IOHandle extractData(IODefinition entry) {
            IODefinition.IOHandle handle = entry.createIOControl(IOGroup.this.ioStackComposite, IOGroup.this.pageListener, IOGroup.this.selection);
            handle.getControl().pack();
            return handle;
        }

        @Override
        protected void onSelectionChanged() {
            ((IOGroup)IOGroup.this).ioStackLayout.topControl = this.getSelection() != null ? ((IODefinition.IOHandle)this.getSelection()).getControl() : null;
            IOGroup.this.ioStackComposite.layout();
            IOGroup.this.pageListener.contentChanged();
        }
    }
}

