/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.outline;

import java.util.ArrayList;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gef.dnd.DelegatingDragAdapter;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jwt.meta.model.core.Model;
import org.eclipse.jwt.meta.model.processes.ActivityEdge;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.dnd.IDropListenerFactory;
import org.eclipse.jwt.we.editors.dnd.internal.DropListenerExtensionPoint;
import org.eclipse.jwt.we.editors.outline.CustomViewerDragAdapter;
import org.eclipse.jwt.we.editors.outline.EditingDomainTransferDropListener;
import org.eclipse.jwt.we.editors.outline.ModelOutlinePage;
import org.eclipse.jwt.we.editors.outline.TemplateTransferDragSourceListener;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.jwt.we.model.view.Diagram;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Menu;

public class ModelOutlineAreaTreeviewer {
    private ArrayList<Class> hiddenTypes = new ArrayList();

    public ModelOutlineAreaTreeviewer(ModelOutlinePage outlinePage, WEEditor editor, TreeViewer contentOutlineViewer) {
        contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(outlinePage.getAdapterFactory()));
        contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(outlinePage.getAdapterFactory()));
        contentOutlineViewer.setInput((Object)editor.getMainModelResource());
        contentOutlineViewer.expandToLevel(2);
        TemplateTransferDragSourceListener dragListener1 = new TemplateTransferDragSourceListener(editor, (ISelectionProvider)contentOutlineViewer);
        CustomViewerDragAdapter dragListener2 = new CustomViewerDragAdapter((Viewer)contentOutlineViewer);
        DelegatingDragAdapter delegatingDragListenerAdapter = new DelegatingDragAdapter();
        delegatingDragListenerAdapter.addDragSourceListener((TransferDragSourceListener)dragListener1);
        delegatingDragListenerAdapter.addDragSourceListener((TransferDragSourceListener)dragListener2);
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), TemplateTransfer.getInstance()};
        contentOutlineViewer.addDragSupport(3, transfers, (DragSourceListener)delegatingDragListenerAdapter);
        DelegatingDropAdapter delegateDrop = new DelegatingDropAdapter();
        EditingDomainTransferDropListener dropListener = new EditingDomainTransferDropListener(editor.getEmfEditingDomain(), (Viewer)contentOutlineViewer);
        delegateDrop.addDropTargetListener((TransferDropTargetListener)dropListener);
        for (IDropListenerFactory factory : DropListenerExtensionPoint.getDropListenersFactories()) {
            TransferDropTargetListener outlineDrop = factory.createWEOutlineDropListerner(contentOutlineViewer, (Model)editor.getModel(), editor.getEditDomain());
            if (outlineDrop == null) continue;
            delegateDrop.addDropTargetListener(outlineDrop);
        }
        contentOutlineViewer.addDropSupport(2, delegateDrop.getTransfers(), (DropTargetListener)delegateDrop);
        Menu contextMenu = outlinePage.getContextMenuManager().createContextMenu(contentOutlineViewer.getControl());
        contentOutlineViewer.getControl().setMenu(contextMenu);
        editor.getSite().registerContextMenu(outlinePage.getContextMenuManager(), (ISelectionProvider)contentOutlineViewer);
        contentOutlineViewer.addDoubleClickListener((IDoubleClickListener)outlinePage);
        contentOutlineViewer.addFilter((ViewerFilter)new OutlineViewFilter());
    }

    public void refresh(TreeViewer treeViewer) {
        if (treeViewer != null) {
            if (PreferenceReader.outlineSortByElement.get() && treeViewer.getSorter() == null) {
                treeViewer.setSorter(new ViewerSorter());
            } else if (!PreferenceReader.outlineSortByElement.get() && treeViewer.getSorter() != null) {
                treeViewer.setSorter(null);
            }
            this.hiddenTypes.clear();
            if (PreferenceReader.outlineHideActEdges.get()) {
                this.hiddenTypes.add(ActivityEdge.class);
            }
            treeViewer.refresh();
        }
    }

    public void dispose() {
        if (this.hiddenTypes != null) {
            this.hiddenTypes.clear();
            this.hiddenTypes = null;
        }
    }

    private class OutlineViewFilter
    extends ViewerFilter {
        private OutlineViewFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (Diagram.class.isAssignableFrom(element.getClass())) {
                return false;
            }
            for (Class classType : ModelOutlineAreaTreeviewer.this.hiddenTypes) {
                if (!classType.isAssignableFrom(element.getClass())) continue;
                return false;
            }
            return true;
        }
    }
}

