/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.createrepo.wizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.internal.rpm.createrepo.Activator;
import org.eclipse.linuxtools.internal.rpm.createrepo.CreaterepoProjectCreator;
import org.eclipse.linuxtools.internal.rpm.createrepo.Messages;
import org.eclipse.linuxtools.internal.rpm.createrepo.wizard.CreaterepoNewWizardPageOne;
import org.eclipse.linuxtools.internal.rpm.createrepo.wizard.CreaterepoNewWizardPageTwo;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;

public class CreaterepoWizard
extends Wizard
implements INewWizard {
    private CreaterepoNewWizardPageOne pageOne;
    private CreaterepoNewWizardPageTwo pageTwo;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.pageOne = new CreaterepoNewWizardPageOne(Messages.CreaterepoNewWizardPageOne_wizardPageName);
        this.addPage((IWizardPage)this.pageOne);
        this.pageTwo = new CreaterepoNewWizardPageTwo(Messages.CreaterepoNewWizardPageTwo_wizardPageName);
        this.addPage((IWizardPage)this.pageTwo);
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.pageTwo && this.pageTwo.isPageComplete();
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) {
                CreaterepoWizard.this.createProject(monitor);
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.logError(Messages.CreaterepoWizard_errorCreatingProject, e);
        }
        return true;
    }

    private void createProject(IProgressMonitor monitor) {
        try {
            String fileName = this.pageTwo.getRepositoryID().concat(".repo");
            IProject project = CreaterepoProjectCreator.create(this.pageOne.getProjectName(), this.pageOne.getLocationPath(), fileName, monitor);
            IFolder folder = project.getFolder("content");
            if (!folder.exists()) {
                folder.create(false, true, monitor);
            }
            IFile file = project.getFile(fileName);
            String repoFileContents = CreaterepoWizard.initializeRepoContents(this.pageTwo.getRepositoryID(), this.pageTwo.getRepositoryName(), this.pageTwo.getRepositoryURL());
            ByteArrayInputStream stream = new ByteArrayInputStream(repoFileContents.getBytes());
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, monitor);
            } else {
                file.create((InputStream)stream, true, monitor);
            }
            monitor.worked(1);
            monitor.setTaskName(Messages.CreaterepoWizard_openFileOnCreation);
            this.getShell().getDisplay().asyncExec(() -> {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    Activator.logError(Messages.CreaterepoWizard_errorOpeningNewlyCreatedFile, e);
                }
            });
            monitor.worked(1);
        }
        catch (CoreException e) {
            Activator.logError(Messages.CreaterepoWizard_errorCreatingProject, e);
        }
    }

    private static String initializeRepoContents(String id, String name, String url) {
        String contents = String.format("[%s]\n", id);
        contents = contents.concat(String.format("%s=%s\n", "name", name));
        contents = contents.concat(String.format("%s=%s\n", "baseurl", url));
        return contents;
    }
}

