/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CustomArchetypeDialog
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS = CustomArchetypeDialog.class.getName();
    private static final String KEY_ARCHETYPE_GROUP_ID = "archetypeGroupId";
    private static final String KEY_ARCHETYPE_ARTIFACT_ID = "archetypeArtifactId";
    private static final String KEY_ARCHETYPE_VERSION = "archetypeVersion";
    private static final String KEY_REPOSITORY_URL = "repositoryUrl";
    private static final int MAX_HISTORY = 15;
    private String title;
    private String message;
    private Combo archetypeGroupIdCombo;
    private Combo archetypeArtifactIdCombo;
    private Combo archetypeVersionCombo;
    private Combo repositoryCombo;
    private IDialogSettings dialogSettings;
    private String archetypeArtifactId;
    private String archetypeGroupId;
    private String archetypeVersion;
    private String repositoryUrl;

    protected CustomArchetypeDialog(Shell shell, String title) {
        super(shell);
        this.title = title;
        this.message = Messages.CustomArchetypeDialog_message;
        this.setShellStyle(2144);
        IDialogSettings pluginSettings = M2EUIPluginActivator.getDefault().getDialogSettings();
        this.dialogSettings = pluginSettings.getSection(DIALOG_SETTINGS);
        if (this.dialogSettings == null) {
            this.dialogSettings = new DialogSettings(DIALOG_SETTINGS);
            pluginSettings.addSection(this.dialogSettings);
        }
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(this.title);
        this.setMessage(this.message);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite1 = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(composite1, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 7;
        gridLayout.marginWidth = 12;
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label archetypeGroupIdLabel = new Label(composite, 0);
        archetypeGroupIdLabel.setText(Messages.CustomArchetypeDialog_lblArchetypegroupId);
        this.archetypeGroupIdCombo = new Combo(composite, 0);
        GridData archetypeGroupIdComboData = new GridData(4, 0x1000000, true, false);
        archetypeGroupIdComboData.widthHint = 350;
        this.archetypeGroupIdCombo.setLayoutData((Object)archetypeGroupIdComboData);
        this.archetypeGroupIdCombo.setItems(this.getSavedValues(KEY_ARCHETYPE_GROUP_ID));
        this.archetypeGroupIdCombo.setData("name", (Object)KEY_ARCHETYPE_GROUP_ID);
        Label archetypeArtifactIdLabel = new Label(composite, 0);
        archetypeArtifactIdLabel.setText(Messages.CustomArchetypeDialog_lblArchetypeartifactid);
        this.archetypeArtifactIdCombo = new Combo(composite, 0);
        this.archetypeArtifactIdCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.archetypeArtifactIdCombo.setItems(this.getSavedValues(KEY_ARCHETYPE_ARTIFACT_ID));
        this.archetypeArtifactIdCombo.setData("name", (Object)KEY_ARCHETYPE_ARTIFACT_ID);
        Label archetypeVersionLabel = new Label(composite, 0);
        archetypeVersionLabel.setText(Messages.CustomArchetypeDialog_lblArchetypeversion);
        this.archetypeVersionCombo = new Combo(composite, 0);
        this.archetypeVersionCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.archetypeVersionCombo.setItems(this.getSavedValues(KEY_ARCHETYPE_VERSION));
        this.archetypeVersionCombo.setData("name", (Object)KEY_ARCHETYPE_VERSION);
        Label repositoryLabel = new Label(composite, 0);
        repositoryLabel.setText(Messages.CustomArchetypeDialog_lblRepo);
        this.repositoryCombo = new Combo(composite, 0);
        this.repositoryCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.repositoryCombo.setItems(this.getSavedValues(KEY_REPOSITORY_URL));
        this.repositoryCombo.setData("name", (Object)"repository");
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomArchetypeDialog.this.update();
            }
        };
        this.archetypeGroupIdCombo.addModifyListener(modifyListener);
        this.archetypeArtifactIdCombo.addModifyListener(modifyListener);
        this.archetypeVersionCombo.addModifyListener(modifyListener);
        this.repositoryCombo.addModifyListener(modifyListener);
        return composite;
    }

    private String[] getSavedValues(String key) {
        String[] array = this.dialogSettings.getArray(key);
        return array == null ? new String[]{} : array;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        this.archetypeArtifactId = this.archetypeArtifactIdCombo.getText().trim();
        this.archetypeGroupId = this.archetypeGroupIdCombo.getText().trim();
        this.archetypeVersion = this.archetypeVersionCombo.getText().trim();
        this.repositoryUrl = this.repositoryCombo.getText().trim();
        this.saveValue(KEY_ARCHETYPE_GROUP_ID, this.archetypeGroupId);
        this.saveValue(KEY_ARCHETYPE_ARTIFACT_ID, this.archetypeArtifactId);
        this.saveValue(KEY_ARCHETYPE_VERSION, this.archetypeVersion);
        this.saveValue(KEY_REPOSITORY_URL, this.repositoryUrl);
        super.okPressed();
    }

    public String getArchetypeGroupId() {
        return this.archetypeGroupId;
    }

    public String getArchetypeArtifactId() {
        return this.archetypeArtifactId;
    }

    public String getArchetypeVersion() {
        return this.archetypeVersion;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    private void saveValue(String key, String value) {
        List dirs = new ArrayList<String>();
        dirs.addAll(Arrays.asList(this.getSavedValues(key)));
        dirs.remove(value);
        dirs.add(0, value);
        if (dirs.size() > 15) {
            dirs = dirs.subList(0, 15);
        }
        this.dialogSettings.put(key, dirs.toArray(new String[dirs.size()]));
    }

    void update() {
        boolean isValid = this.isValid();
        this.getButton(0).setEnabled(isValid);
    }

    private boolean isValid() {
        this.setErrorMessage(null);
        this.setMessage(null, 2);
        if (this.archetypeGroupIdCombo.getText().trim().length() == 0) {
            this.setErrorMessage(Messages.CustomArchetypeDialog_error_grid);
            return false;
        }
        if (this.archetypeArtifactIdCombo.getText().trim().length() == 0) {
            this.setErrorMessage(Messages.CustomArchetypeDialog_error_artid);
            return false;
        }
        if (this.archetypeVersionCombo.getText().trim().length() == 0) {
            this.setErrorMessage(Messages.CustomArchetypeDialog_error_version);
            return false;
        }
        return true;
    }
}

