/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyleRange;

public class AtlParameterListValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private int fCurrentParameter;
    private IContextInformation fInformation;
    private int fPosition;
    private ITextViewer fViewer;

    private int getCharCount(IDocument document, int start, int end, char increment, char decrement, boolean considerNesting) throws BadLocationException {
        Assert.isTrue(((increment != '\u0000' || decrement != '\u0000') && increment != decrement ? 1 : 0) != 0);
        int nestingLevel = 0;
        int charCount = 0;
        block4: while (start < end) {
            char curr = document.getChar(start++);
            switch (curr) {
                case '-': {
                    char next;
                    if (start >= end || (next = document.getChar(start)) != '-') continue block4;
                    start = end;
                    break;
                }
                case '\'': {
                    start = this.getStringEnd(document, start, end, curr);
                    break;
                }
                default: {
                    if (considerNesting) {
                        if ('(' == curr) {
                            ++nestingLevel;
                        } else if (')' == curr) {
                            --nestingLevel;
                        }
                        if (nestingLevel != 0) continue block4;
                    }
                    if (increment != '\u0000' && curr == increment) {
                        ++charCount;
                    }
                    if (decrement == '\u0000' || curr != decrement) continue block4;
                    --charCount;
                }
            }
        }
        return charCount;
    }

    private int getStringEnd(IDocument d, int pos, int end, char ch) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            ++pos;
            if (curr == '\\') {
                ++pos;
                continue;
            }
            if (curr != ch) continue;
            return pos;
        }
        return end;
    }

    public void install(IContextInformation info, ITextViewer viewer, int documentPosition) {
        this.fPosition = documentPosition;
        this.fViewer = viewer;
        this.fInformation = info;
        this.fCurrentParameter = -1;
    }

    public boolean isContextInformationValid(int position) {
        IDocument document;
        block5: {
            block4: {
                try {
                    if (position >= this.fPosition) break block4;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            document = this.fViewer.getDocument();
            IRegion line = document.getLineInformationOfOffset(this.fPosition);
            if (position <= line.getOffset() + line.getLength()) break block5;
            return false;
        }
        return this.getCharCount(document, this.fPosition, position, '(', ')', false) >= 0;
    }

    public boolean updatePresentation(int position, TextPresentation presentation) {
        int end;
        int currentParameter = -1;
        try {
            currentParameter = this.getCharCount(this.fViewer.getDocument(), this.fPosition, position, ',', '\u0000', true);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        if (this.fCurrentParameter != -1 && currentParameter == this.fCurrentParameter) {
            return false;
        }
        presentation.clear();
        this.fCurrentParameter = currentParameter;
        String s = this.fInformation.getInformationDisplayString();
        int start = 0;
        int occurrences = 0;
        while (occurrences < this.fCurrentParameter) {
            int found = s.indexOf(44, start);
            if (found == -1) break;
            start = found + 1;
            ++occurrences;
        }
        if (occurrences < this.fCurrentParameter) {
            presentation.addStyleRange(new StyleRange(0, s.length(), null, null, 0));
            return true;
        }
        if (start == -1) {
            start = 0;
        }
        if ((end = s.indexOf(44, start)) == -1) {
            end = s.length();
        }
        if (start > 0) {
            presentation.addStyleRange(new StyleRange(0, start, null, null, 0));
        }
        if (end > start) {
            presentation.addStyleRange(new StyleRange(start, end - start, null, null, 1));
        }
        if (end < s.length()) {
            presentation.addStyleRange(new StyleRange(end, s.length() - end, null, null, 0));
        }
        return true;
    }
}

