/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.registry;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mat.query.annotations.descriptors.IAnnotatedObjectDescriptor;
import org.eclipse.mat.query.registry.ArgumentDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedObjectArgumentsSet {
    private IAnnotatedObjectDescriptor descriptor;
    private Map<ArgumentDescriptor, Object> values;

    public AnnotatedObjectArgumentsSet(IAnnotatedObjectDescriptor descriptor) {
        this.descriptor = descriptor;
        this.values = new HashMap<ArgumentDescriptor, Object>();
    }

    public void setArgumentValue(ArgumentDescriptor arg, Object value) {
        this.values.put(arg, value);
    }

    public boolean isExecutable() {
        for (ArgumentDescriptor parameter : this.descriptor.getArguments()) {
            if (!parameter.isMandatory() || this.values.containsKey(parameter) || parameter.getDefaultValue() != null) continue;
            return false;
        }
        return true;
    }

    public void removeArgumentValue(ArgumentDescriptor arg) {
        this.values.remove(arg);
    }

    public Object getArgumentValue(ArgumentDescriptor desc) {
        return this.values.get(desc);
    }

    public IAnnotatedObjectDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Map<ArgumentDescriptor, Object> getValues() {
        return this.values;
    }
}

