/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListView;
import org.eclipse.mylyn.internal.tasks.ui.views.Messages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListContentProvider;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.ui.PlatformUI;

public class TaskScheduleContentProvider
extends TaskListContentProvider
implements ITaskActivityListener {
    private final TaskActivityManager taskActivityManager = TasksUiPlugin.getTaskActivityManager();
    private final Unscheduled unscheduled;
    private final Calendar END_OF_TIME;
    private final Calendar INCOMING_TIME;
    private final Calendar OUTGOING_TIME;
    private final Calendar COMPLETED_TIME;
    private Job rolloverJob;
    private final Incoming incoming;
    private final Outgoing outgoing;
    private final Completed completed;

    public TaskScheduleContentProvider(AbstractTaskListView taskListView) {
        super(taskListView);
        this.taskActivityManager.addActivityListener((ITaskActivityListener)this);
        this.END_OF_TIME = TaskActivityUtil.getCalendar();
        this.END_OF_TIME.add(1, 5000);
        this.END_OF_TIME.getTime();
        this.unscheduled = new Unscheduled();
        this.INCOMING_TIME = TaskActivityUtil.getCalendar();
        this.INCOMING_TIME.setTimeInMillis(this.END_OF_TIME.getTimeInMillis() - 1L);
        this.incoming = new Incoming();
        this.OUTGOING_TIME = TaskActivityUtil.getCalendar();
        this.OUTGOING_TIME.setTimeInMillis(this.END_OF_TIME.getTimeInMillis() - 2L);
        this.outgoing = new Outgoing();
        this.COMPLETED_TIME = TaskActivityUtil.getCalendar();
        this.COMPLETED_TIME.setTimeInMillis(this.END_OF_TIME.getTimeInMillis() + 2L);
        this.completed = new Completed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getElements(Object parent) {
        if (parent != null && parent.equals(this.taskListView.getViewSite())) {
            HashSet<AbstractTaskContainer> containers = new HashSet<AbstractTaskContainer>();
            WeekDateRange week = TaskActivityUtil.getCurrentWeek();
            WeekDateRange nextWeek = TaskActivityUtil.getNextWeek();
            TaskScheduleContentProvider taskScheduleContentProvider = this;
            synchronized (taskScheduleContentProvider) {
                if (this.rolloverJob != null) {
                    this.rolloverJob.cancel();
                    this.rolloverJob = null;
                }
                long delay = week.getToday().getEndDate().getTime().getTime() - new Date().getTime();
                this.rolloverJob = new RolloverCheck();
                this.rolloverJob.setSystem(true);
                this.rolloverJob.setPriority(20);
                this.rolloverJob.schedule(delay);
            }
            for (DateRange day : week.getRemainingDays()) {
                containers.add((AbstractTaskContainer)new ScheduledTaskContainer(TasksUiPlugin.getTaskActivityManager(), day));
            }
            containers.add((AbstractTaskContainer)new ScheduledTaskContainer(TasksUiPlugin.getTaskActivityManager(), (DateRange)week));
            for (DateRange day : nextWeek.getDaysOfWeek()) {
                containers.add((AbstractTaskContainer)new ScheduledTaskContainer(TasksUiPlugin.getTaskActivityManager(), day));
            }
            ScheduledTaskContainer nextWeekContainer = new ScheduledTaskContainer(this.taskActivityManager, (DateRange)nextWeek);
            containers.add((AbstractTaskContainer)nextWeekContainer);
            ScheduledTaskContainer twoWeeksContainer = new ScheduledTaskContainer(this.taskActivityManager, (DateRange)week.next().next(), Messages.TaskScheduleContentProvider_Two_Weeks);
            containers.add((AbstractTaskContainer)twoWeeksContainer);
            Calendar startDate = TaskActivityUtil.getCalendar();
            startDate.setTimeInMillis(twoWeeksContainer.getEnd().getTimeInMillis());
            TaskActivityUtil.snapNextDay((Calendar)startDate);
            Calendar endDate = TaskActivityUtil.getCalendar();
            endDate.add(1, 4999);
            DateRange future = new DateRange(startDate, endDate);
            ScheduledTaskContainer futureContainer = new ScheduledTaskContainer(this.taskActivityManager, future, Messages.TaskScheduleContentProvider_Future, Messages.TaskScheduleContentProvider_Future);
            containers.add((AbstractTaskContainer)futureContainer);
            containers.add((AbstractTaskContainer)this.outgoing);
            containers.add((AbstractTaskContainer)this.incoming);
            containers.add((AbstractTaskContainer)this.unscheduled);
            containers.add((AbstractTaskContainer)this.completed);
            return this.applyFilter(containers).toArray();
        }
        return this.getChildren(parent);
    }

    @Override
    public Object getParent(Object child) {
        return null;
    }

    @Override
    public boolean hasChildren(Object parent) {
        return this.getChildren(parent).length > 0;
    }

    @Override
    protected List<IRepositoryElement> getFilteredChildrenFor(Object parent) {
        if (parent instanceof ITask) {
            return Collections.emptyList();
        }
        if (parent instanceof ScheduledTaskContainer) {
            Collection children = ((ScheduledTaskContainer)parent).getChildren();
            ArrayList<IRepositoryElement> result = new ArrayList<IRepositoryElement>(children.size());
            for (ITask child : children) {
                if (this.filter(parent, child)) continue;
                result.add((IRepositoryElement)child);
            }
            return result;
        }
        return super.getFilteredChildrenFor(parent);
    }

    private void refresh() {
        if (Platform.isRunning() && PlatformUI.getWorkbench() != null && !PlatformUI.getWorkbench().isClosing()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TaskScheduleContentProvider.this.taskListView.refresh();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        TaskScheduleContentProvider taskScheduleContentProvider = this;
        synchronized (taskScheduleContentProvider) {
            if (this.rolloverJob != null) {
                this.rolloverJob.cancel();
            }
        }
        this.taskActivityManager.removeActivityListener((ITaskActivityListener)this);
        super.dispose();
    }

    public void activityReset() {
        this.refresh();
    }

    public void elapsedTimeUpdated(ITask task, long newElapsedTime) {
    }

    private static boolean notScheduled(ITask task) {
        ITask.SynchronizationState state = task.getSynchronizationState();
        return state == ITask.SynchronizationState.SYNCHRONIZED || state == ITask.SynchronizationState.INCOMING && Boolean.parseBoolean(task.getAttribute("task.common.suppress.incoming"));
    }

    public class Completed
    extends StateTaskContainer {
        public Completed() {
            super(new DateRange(TaskScheduleContentProvider.this.COMPLETED_TIME), Messages.TaskScheduleContentProvider_Completed);
        }

        @Override
        public boolean select(ITask task) {
            return task.isCompleted() && TaskScheduleContentProvider.notScheduled(task);
        }
    }

    public class Incoming
    extends StateTaskContainer {
        public Incoming() {
            super(new DateRange(TaskScheduleContentProvider.this.INCOMING_TIME), Messages.TaskScheduleContentProvider_Incoming);
        }

        @Override
        protected boolean select(ITask task) {
            ITask.SynchronizationState state = task.getSynchronizationState();
            return state == ITask.SynchronizationState.INCOMING_NEW || state == ITask.SynchronizationState.INCOMING && !Boolean.parseBoolean(task.getAttribute("task.common.suppress.incoming"));
        }
    }

    public class Outgoing
    extends StateTaskContainer {
        public Outgoing() {
            super(new DateRange(TaskScheduleContentProvider.this.OUTGOING_TIME), Messages.TaskScheduleContentProvider_Outgoing);
        }

        @Override
        public boolean select(ITask task) {
            ITask.SynchronizationState state = task.getSynchronizationState();
            return state == ITask.SynchronizationState.OUTGOING || state == ITask.SynchronizationState.OUTGOING_NEW || state == ITask.SynchronizationState.CONFLICT;
        }
    }

    private class RolloverCheck
    extends Job {
        public RolloverCheck() {
            super("Calendar Rollover Job");
        }

        protected IStatus run(IProgressMonitor monitor) {
            TaskScheduleContentProvider.this.refresh();
            return Status.OK_STATUS;
        }
    }

    public abstract class StateTaskContainer
    extends ScheduledTaskContainer {
        Calendar temp;

        public StateTaskContainer(DateRange range, String summary) {
            super(TaskScheduleContentProvider.this.taskActivityManager, range, summary, summary);
            this.temp = TaskActivityUtil.getCalendar();
        }

        public Collection<ITask> getChildren() {
            HashSet<ITask> children = new HashSet<ITask>();
            for (ITask task : TasksUiPlugin.getTaskList().getAllTasks()) {
                if (!this.select(task) || !this.include(task)) continue;
                children.add(task);
            }
            return children;
        }

        private boolean include(ITask task) {
            if (task.isCompleted()) {
                return true;
            }
            DateRange scheduledForDate = ((AbstractTask)task).getScheduledForDate();
            if (TaskScheduleContentProvider.this.taskListView.isFocusedMode()) {
                if (scheduledForDate != null) {
                    return TaskActivityUtil.isAfterCurrentWeek((Calendar)scheduledForDate.getStartDate());
                }
                if (task.getDueDate() != null && TaskScheduleContentProvider.this.taskActivityManager.isOwnedByUser(task)) {
                    this.temp.setTime(task.getDueDate());
                    return TaskActivityUtil.isAfterCurrentWeek((Calendar)this.temp);
                }
            }
            if (scheduledForDate == null) {
                if (task.getDueDate() != null && !TaskScheduleContentProvider.this.taskActivityManager.isOwnedByUser(task)) {
                    return true;
                }
                if (task.getDueDate() == null) {
                    return true;
                }
            }
            return false;
        }

        protected abstract boolean select(ITask var1);
    }

    public class Unscheduled
    extends StateTaskContainer {
        public Unscheduled() {
            super(new DateRange(TaskScheduleContentProvider.this.END_OF_TIME), Messages.TaskScheduleContentProvider_Unscheduled);
        }

        @Override
        protected boolean select(ITask task) {
            return !task.isCompleted() && TaskScheduleContentProvider.notScheduled(task);
        }
    }
}

