/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.filters;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.eventmanager.filters.AbstractEventFilter;

public class StructuralFeatureFilter
extends AbstractEventFilter {
    private final EStructuralFeature feature;

    public StructuralFeatureFilter(EStructuralFeature feature, boolean negated) {
        super(negated);
        this.feature = feature;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructuralFeatureFilter other = (StructuralFeatureFilter)obj;
        if (this.feature == null ? other.feature != null : !this.feature.equals(other.feature)) {
            return false;
        }
        return this.isNegated() == other.isNegated();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.feature == null ? 0 : this.feature.hashCode());
        if (this.isNegated()) {
            result *= 31;
        }
        return result;
    }

    public boolean matchesFor(Notification event) {
        if (event.getFeature() == null) {
            return this.isNegated();
        }
        if (event.getFeature().equals(this.getFeature())) {
            return !this.isNegated();
        }
        return this.isNegated();
    }

    public StructuralFeatureFilter clone() {
        return new StructuralFeatureFilter(this.getFeature(), this.isNegated());
    }

    public String toString() {
        if (this.getFeature() != null) {
            return String.valueOf(this.isNegated() ? "negated " : "") + "feature: " + this.getFeature().toString();
        }
        return String.valueOf(this.isNegated() ? "negated " : "") + "empty FeatureFilter";
    }

    public Object getFilterCriterion() {
        return this.getFeature();
    }
}

