/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.helper;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.SemanticElementHelper;

public class NotationHelper {
    public static View findView(Object source) {
        IAdaptable adaptable;
        Object adapter;
        if (source instanceof View) {
            return (View)source;
        }
        if (source instanceof IAdaptable && (adapter = (adaptable = (IAdaptable)source).getAdapter(View.class)) instanceof View) {
            return (View)adapter;
        }
        if (source != null) {
            return (View)Platform.getAdapterManager().getAdapter(source, View.class);
        }
        EObject obj = EMFHelper.getEObject((Object)source);
        return obj instanceof View ? (View)obj : null;
    }

    public static boolean isExternalRef(View diagramElement) {
        if (diagramElement == null) {
            return false;
        }
        View primaryView = SemanticElementHelper.findTopView((EObject)diagramElement);
        if (primaryView == null) {
            return false;
        }
        EObject semanticElement = primaryView.getElement();
        if (semanticElement == null) {
            return false;
        }
        EObject parentView = primaryView.eContainer();
        if (!(parentView instanceof View)) {
            return false;
        }
        EObject parentSemanticElement = ((View)parentView).getElement();
        if (parentSemanticElement == null) {
            return false;
        }
        return parentSemanticElement != semanticElement.eContainer() && parentSemanticElement != semanticElement;
    }

    public static PrecisionRectangle getAbsoluteBounds(Node node) {
        if (node.getLayoutConstraint() instanceof Bounds) {
            PrecisionRectangle bounds = new PrecisionRectangle((double)((Bounds)node.getLayoutConstraint()).getX(), (double)((Bounds)node.getLayoutConstraint()).getY(), (double)((Bounds)node.getLayoutConstraint()).getWidth(), (double)((Bounds)node.getLayoutConstraint()).getHeight());
            EObject currentView = node.eContainer();
            while (currentView != null) {
                if (currentView instanceof Node) {
                    Point ptCurrenview = new Point(((Bounds)((Node)currentView).getLayoutConstraint()).getX(), ((Bounds)((Node)currentView).getLayoutConstraint()).getY());
                    bounds.translate(ptCurrenview);
                }
                currentView = currentView.eContainer();
            }
            return bounds;
        }
        return null;
    }
}

