/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.uml.diagram.common.Activator;

public class OrphanViewPolicy
extends AbstractEditPolicy
implements NotificationListener,
IPapyrusListener {
    private ArrayList<String> notOrphanList = new ArrayList();
    private static Pattern digit = Pattern.compile("\\d+");
    protected HashMap<EObject, List<View>> additionalParentToListen = new HashMap();
    protected EObject hostSemanticElement;
    private boolean isActive = false;

    public void activate() {
        View hostView = (View)this.getHost().getModel();
        this.hostSemanticElement = hostView.getElement();
        this.getDiagramEventBroker().addNotificationListener((EObject)hostView, (NotificationListener)this);
        this.getDiagramEventBroker().addNotificationListener(this.hostSemanticElement, (NotificationListener)this);
        ListIterator it = hostView.getChildren().listIterator();
        while (it.hasNext()) {
            View childView = (View)it.next();
            this.addListenerForView(childView);
        }
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug("Activate: " + this.prettyPrint(this.additionalParentToListen));
        }
        this.isActive = true;
        super.activate();
    }

    protected void addAdditionalParentToListen(EObject semanticParent, View childView) {
        if (this.additionalParentToListen.containsKey(semanticParent)) {
            List<View> views = this.additionalParentToListen.get(semanticParent);
            assert (views != null) : "list should not be null";
            views.add(childView);
        } else {
            ArrayList<View> views = new ArrayList<View>();
            views.add(childView);
            this.additionalParentToListen.put(semanticParent, views);
            this.getDiagramEventBroker().addNotificationListener(semanticParent, (NotificationListener)this);
        }
    }

    protected void removeAdditionalParentToListen(EObject semanticParent, View childView) {
        if (this.additionalParentToListen.containsKey(semanticParent)) {
            List<View> views = this.additionalParentToListen.get(semanticParent);
            assert (views != null) : "list should not be null";
            views.remove(childView);
            if (views.isEmpty()) {
                this.additionalParentToListen.remove(semanticParent);
                if (!semanticParent.equals(((View)this.getHost().getModel()).getElement())) {
                    this.getDiagramEventBroker().removeNotificationListener(semanticParent, (NotificationListener)this);
                }
            }
        }
    }

    public void deactivate() {
        View hostView = (View)this.getHost().getModel();
        for (EObject parent : this.additionalParentToListen.keySet()) {
            this.getDiagramEventBroker().removeNotificationListener(parent, (NotificationListener)this);
        }
        this.additionalParentToListen.clear();
        this.additionalParentToListen = null;
        this.getDiagramEventBroker().removeNotificationListener((EObject)hostView, (NotificationListener)this);
        this.getDiagramEventBroker().removeNotificationListener(this.hostSemanticElement, (NotificationListener)this);
        this.hostSemanticElement = null;
        this.isActive = false;
        super.deactivate();
    }

    protected final boolean deleteViews(Iterator<View> views) {
        boolean doDelete;
        CompoundCommand cc = new CompoundCommand(DiagramUIMessages.DeleteCommand_Label);
        while (views.hasNext()) {
            View view = views.next();
            cc.add(this.getDeleteViewCommand(view));
        }
        boolean bl = doDelete = !cc.isEmpty() && cc.canExecute();
        if (doDelete) {
            this.executeCommand((Command)cc);
        }
        return doDelete;
    }

    protected void executeCommand(final Command cmd) {
        Map<String, Boolean> options = null;
        EditPart ep = this.getHost();
        boolean isActivating = true;
        EditPartViewer viewer = ep.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            isActivating = ((DiagramGraphicalViewer)viewer).isInitializing();
        }
        if (isActivating || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)((IGraphicalEditPart)this.getHost()), (boolean)false, (boolean)false)) {
            options = Collections.singletonMap("unprotected", Boolean.TRUE);
        }
        AbstractEMFOperation operation = new AbstractEMFOperation(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                cmd.execute();
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected List<View> findOrphanView(Iterator<? extends EObject> viewChildrenIterator) {
        ArrayList<View> orphanView = new ArrayList<View>();
        while (viewChildrenIterator.hasNext()) {
            EObject view = viewChildrenIterator.next();
            if (!(view instanceof View) || !this.isOrphaned((View)view)) continue;
            orphanView.add((View)view);
        }
        return orphanView;
    }

    protected Command getDeleteViewCommand(View view) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        return new ICommandProxy((ICommand)new DeleteCommand(editingDomain, view));
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public void init(String[] notOrphanVisualID) {
        int i = 0;
        while (i < notOrphanVisualID.length) {
            this.notOrphanList.add(notOrphanVisualID[i]);
            ++i;
        }
    }

    protected boolean isOrphaned(View view) {
        String semanticHint = view.getType();
        if (this.notOrphanList.contains(semanticHint)) {
            return false;
        }
        return !view.isSetElement();
    }

    public static boolean isInteger(String s) {
        boolean result = false;
        Matcher matcher = digit.matcher(s);
        if (matcher != null) {
            result = matcher.matches();
        }
        return result;
    }

    public void notifyChanged(Notification notification) {
        if (!this.isActive()) {
            return;
        }
        Object notifier = notification.getNotifier();
        if (notifier.equals(this.hostSemanticElement)) {
            if (4 == notification.getEventType() || 1 == notification.getEventType()) {
                this.refreshViews();
            }
        } else if (notifier instanceof EObject) {
            if (!(notifier instanceof View)) {
                EObject parentNotifier;
                if (4 == notification.getEventType() && this.additionalParentToListen.containsKey(parentNotifier = (EObject)notifier)) {
                    List<View> views = this.additionalParentToListen.get(parentNotifier);
                    List<View> orphaned = this.findOrphanView(views.iterator());
                    this.deleteViews(orphaned.iterator());
                    this.removeListeners(orphaned);
                }
            } else if (4 == notification.getEventType()) {
                if (notification.getNewValue() instanceof View) {
                    View oldView = (View)notification.getOldValue();
                    this.removeListenerForView(oldView);
                }
            } else if (3 == notification.getEventType() && notification.getNewValue() instanceof View) {
                View newView = (View)notification.getNewValue();
                this.addListenerForView(newView);
            }
        }
    }

    private boolean isActive() {
        return this.isActive;
    }

    protected void addListenerForView(View newView) {
        EObject semanticParent;
        View hostView = (View)this.getHost().getModel();
        if (newView.getElement() != null && (semanticParent = newView.getElement().eContainer()) != null && !semanticParent.equals(this.hostSemanticElement)) {
            for (EObject parent : this.getElementHierarchy(semanticParent)) {
                this.addAdditionalParentToListen(parent, newView);
            }
        }
    }

    protected void removeListenerForView(View oldView) {
        HashMap<EObject, ArrayList<View>> parentsToDelete = new HashMap<EObject, ArrayList<View>>();
        for (EObject parent : this.additionalParentToListen.keySet()) {
            List<View> parentViews = this.additionalParentToListen.get(parent);
            if (!parentViews.contains(oldView)) continue;
            ArrayList<View> views = (ArrayList<View>)parentsToDelete.get(parent);
            if (views == null) {
                views = new ArrayList<View>();
            }
            views.add(oldView);
            parentsToDelete.put(parent, views);
        }
    }

    protected void removeListeners(List<View> impactedViews) {
        HashMap<EObject, ArrayList<View>> parentsToDelete = new HashMap<EObject, ArrayList<View>>();
        for (View view : impactedViews) {
            for (EObject parent : this.additionalParentToListen.keySet()) {
                List<View> parentViews = this.additionalParentToListen.get(parent);
                if (!parentViews.contains(view)) continue;
                ArrayList<View> views = (ArrayList<View>)parentsToDelete.get(parent);
                if (views == null) {
                    views = new ArrayList<View>();
                }
                views.add(view);
                parentsToDelete.put(parent, views);
            }
        }
        for (EObject object : parentsToDelete.keySet()) {
            List views = (List)parentsToDelete.get(object);
            for (View view : views) {
                this.removeAdditionalParentToListen(object, view);
            }
        }
    }

    public List<EObject> getElementHierarchy(EObject eObject) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        EObject currentObject = eObject;
        while (currentObject != null) {
            list.add(currentObject);
            currentObject = currentObject.eContainer();
        }
        return list;
    }

    protected List refreshViews() {
        Iterator viewChildrenIterator = ((EObject)this.getHost().getModel()).eContents().iterator();
        List<View> orphaned = this.findOrphanView(viewChildrenIterator);
        this.deleteViews(orphaned.iterator());
        this.removeListeners(orphaned);
        ArrayList viewDescriptors = new ArrayList();
        return viewDescriptors;
    }

    public void forceRefresh() {
        this.refreshViews();
    }

    private String prettyPrint(Map<EObject, List<View>> additionalParentToListen) {
        StringBuffer buffer = new StringBuffer();
        if (additionalParentToListen == null) {
            return "Empty listener for " + this.getHost();
        }
        buffer.append("addtionnal listeners for ");
        buffer.append(this.getHost());
        buffer.append("\n");
        for (EObject object : additionalParentToListen.keySet()) {
            buffer.append("\n");
            buffer.append(object);
            buffer.append("(");
            buffer.append(additionalParentToListen.get(object).size());
            buffer.append("):\n");
            for (View view : additionalParentToListen.get(object)) {
                buffer.append("- ");
                buffer.append(view);
                buffer.append("\n");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

