/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.model;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelUtils;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.model.UmlModel;

public class UmlUtils {
    private static final String ANNOTATION_SUBSETS = "subsets";

    public static UmlModel getUmlModel() {
        try {
            return (UmlModel)ServiceUtilsForActionHandlers.getInstance().getModelSet().getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public static UmlModel getUmlModelChecked() throws ServiceException {
        return (UmlModel)ServiceUtilsForActionHandlers.getInstance().getModelSet().getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
    }

    public static UmlModel getUmlModel(ModelSet modelSet) {
        return (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
    }

    public static UmlModel getUmlModel(ServicesRegistry servicesRegistry) {
        try {
            return UmlUtils.getUmlModelChecked(servicesRegistry);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public static UmlModel getUmlModelChecked(ServicesRegistry servicesRegistry) throws ServiceException {
        return (UmlModel)ModelUtils.getModelSetChecked((ServicesRegistry)servicesRegistry).getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
    }

    public static Resource getUmlResource(ServicesRegistry registry) {
        try {
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)registry);
            return UmlUtils.getUmlResource(modelSet);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }

    public static Resource getUmlResource(ModelSet modelSet) {
        UmlModel umlModel = UmlUtils.getUmlModel(modelSet);
        if (umlModel != null) {
            return umlModel.getResource();
        }
        return null;
    }

    public static Collection<EReference> getAllChangeableSupersets(EReference subset) {
        EAnnotation supersets;
        Collection<EReference> result = null;
        EAnnotation eAnnotation = supersets = subset == null ? null : subset.getEAnnotation(ANNOTATION_SUBSETS);
        if (supersets != null) {
            result = UmlUtils.collectChangeableSupersets((Collection<EObject>)supersets.getReferences(), new HashSet<EReference>());
        }
        return result == null ? Collections.emptyList() : result;
    }

    private static Collection<EReference> collectChangeableSupersets(Collection<EObject> supersets, Set<EReference> result) {
        for (EObject next : supersets) {
            EAnnotation recursive;
            EReference superset;
            if (!(next instanceof EReference) || !(superset = (EReference)next).isChangeable() || !result.add(superset) || (recursive = superset.getEAnnotation(ANNOTATION_SUBSETS)) == null) continue;
            UmlUtils.collectChangeableSupersets((Collection<EObject>)recursive.getReferences(), result);
        }
        return result;
    }

    public static boolean isSubset(EReference subset) {
        EAnnotation supersets;
        boolean result = false;
        EAnnotation eAnnotation = supersets = subset == null ? null : subset.getEAnnotation(ANNOTATION_SUBSETS);
        if (supersets != null) {
            result = !supersets.getReferences().isEmpty();
        }
        return result;
    }

    public static boolean isSubsetOf(EReference subset, EReference superset) {
        EAnnotation supersets;
        boolean result = false;
        EAnnotation eAnnotation = supersets = subset == null ? null : subset.getEAnnotation(ANNOTATION_SUBSETS);
        if (supersets != null && !(result = supersets.getReferences().contains((Object)superset))) {
            Iterator iter = supersets.getReferences().iterator();
            while (!result && iter.hasNext()) {
                EObject next = (EObject)iter.next();
                if (!(next instanceof EReference)) continue;
                result = UmlUtils.isSubsetOf((EReference)next, superset);
            }
        }
        return result;
    }

    public static Iterable<EReference> getSupersets(EReference subset) {
        ArrayList result;
        EAnnotation supersets;
        EAnnotation eAnnotation = supersets = subset == null ? null : subset.getEAnnotation(ANNOTATION_SUBSETS);
        if (supersets == null) {
            result = Collections.emptyList();
        } else {
            result = Lists.newArrayListWithCapacity((int)supersets.getReferences().size());
            for (EObject next : supersets.getReferences()) {
                if (!(next instanceof EReference)) continue;
                EReference superset = (EReference)next;
                result.add(superset);
                if (!UmlUtils.isSubset(superset)) continue;
                Iterables.addAll((Collection)result, UmlUtils.getSupersets(superset));
            }
        }
        return result;
    }
}

