/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class DescriptorHelper {
    private DescriptorHelper() {
        throw new UnsupportedOperationException("Instances of DescriptorHelper are not allowed");
    }

    public static void buildColsFromMappings(StringBuilder target, Collection<DatabaseMapping> mappings, String separator) {
        Iterator<DatabaseMapping> i = mappings.iterator();
        while (i.hasNext()) {
            target.append(i.next().getField().getName());
            if (!i.hasNext()) continue;
            target.append(separator);
        }
    }

    public static void buildValuesAsQMarksFromMappings(StringBuilder target, Collection<DatabaseMapping> mappings, String separator) {
        int count = mappings.size();
        if (count > 0) {
            int i = 0;
            while (i < count) {
                if (i > 0) {
                    target.append(separator);
                }
                target.append('?');
                ++i;
            }
        }
    }

    public static void buildColsAndValuesBindingsFromMappings(StringBuilder target, Collection<DatabaseMapping> mappings, Collection<DatabaseField> keys, int valueIndex, String binder, String separator) {
        int idx = valueIndex;
        Iterator<DatabaseMapping> i = mappings.iterator();
        while (i.hasNext()) {
            DatabaseMapping mapping = i.next();
            DatabaseField field = mapping.getField();
            if (keys.contains(field)) continue;
            target.append(field.getName()).append(binder).append(Integer.toString(++idx));
            if (!i.hasNext()) continue;
            target.append(separator);
        }
    }
}

