/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpPreferences;

public class XDebugPreferenceMgr {
    public static final String XDEBUG_PREF_PORT = "org.eclipse.php.debug.core.xdebug_port";
    public static final String XDEBUG_PREF_SHOWSUPERGLOBALS = "org.eclipse.php.debug.core.xdebug_showSuperGlobals";
    public static final String XDEBUG_PREF_ARRAYDEPTH = "org.eclipse.php.debug.core.xdebug_arrayDepth";
    public static final String XDEBUG_PREF_CHILDREN = "org.eclipse.php.debug.core.xdebug_children";
    public static final String XDEBUG_PREF_DATA = "org.eclipse.php.debug.core.xdebug_data";
    public static final String XDEBUG_PREF_MULTISESSION = "org.eclipse.php.debug.core.xdebug_multisession";
    public static final String XDEBUG_PREF_REMOTESESSION = "org.eclipse.php.debug.core.xdebug_remotesession";
    public static final String XDEBUG_PREF_CAPTURESTDOUT = "org.eclipse.php.debug.core.xdebug_capturestdout";
    public static final String XDEBUG_PREF_CAPTURESTDERR = "org.eclipse.php.debug.core.xdebug_capturestderr";
    public static final String XDEBUG_PREF_USEPROXY = "org.eclipse.php.debug.core.xdebug_useproxy";
    public static final String XDEBUG_PREF_IDEKEY = "org.eclipse.php.debug.core.xdebug_idekey";
    public static final String XDEBUG_PREF_PROXY = "org.eclipse.php.debug.core.xdebug_proxy";
    public static final String XDEBUG_PREF_WARN_NO_LOCALHOST_SESSION = "org.eclipse.php.debug.core.no_localhost_remote_session";
    public static final String[] remoteSessionOptions = new String[]{PHPDebugCoreMessages.XDebugConfigurationDialog_remoteSessionOption_off, PHPDebugCoreMessages.XDebugConfigurationDialog_remoteSessionOption_localhost, PHPDebugCoreMessages.XDebugConfigurationDialog_remoteSessionOption_any, PHPDebugCoreMessages.XDebugConfigurationDialog_remoteSessionOption_prompt};
    public static final String[] captureOutputOptions = new String[]{PHPDebugCoreMessages.XDebugConfigurationDialog_capture_off, PHPDebugCoreMessages.XDebugConfigurationDialog_capture_copy, PHPDebugCoreMessages.XDebugConfigurationDialog_capture_redirect};

    public static void setDefaults() {
        IEclipsePreferences prefs = PHPDebugPlugin.getDefaultPreferences();
        prefs.putInt(XDEBUG_PREF_PORT, XDebugPreferenceMgr.getPortDefault());
        prefs.putBoolean(XDEBUG_PREF_SHOWSUPERGLOBALS, XDebugPreferenceMgr.showSuperGlobalsDefault());
        prefs.putInt(XDEBUG_PREF_ARRAYDEPTH, XDebugPreferenceMgr.getDepthDefault());
        prefs.putBoolean(XDEBUG_PREF_MULTISESSION, XDebugPreferenceMgr.useMultiSessionDefault());
        prefs.putInt(XDEBUG_PREF_CHILDREN, XDebugPreferenceMgr.getChildrenDefault());
        prefs.putInt(XDEBUG_PREF_DATA, XDebugPreferenceMgr.getDataDefault());
        prefs.putInt(XDEBUG_PREF_REMOTESESSION, XDebugPreferenceMgr.getAcceptRemoteSessionDefault());
        prefs.putInt(XDEBUG_PREF_CAPTURESTDOUT, XDebugPreferenceMgr.getCaptureDefault());
        prefs.putInt(XDEBUG_PREF_CAPTURESTDERR, XDebugPreferenceMgr.getCaptureDefault());
        prefs.putBoolean(XDEBUG_PREF_WARN_NO_LOCALHOST_SESSION, XDebugPreferenceMgr.getWarnNoLocalhostSessionDefault());
    }

    public static void applyDefaults(IEclipsePreferences prefs) {
        IEclipsePreferences defaults = PHPDebugPlugin.getDefaultPreferences();
        prefs.putInt(XDEBUG_PREF_PORT, defaults.getInt(XDEBUG_PREF_PORT, 0));
        prefs.putBoolean(XDEBUG_PREF_SHOWSUPERGLOBALS, defaults.getBoolean(XDEBUG_PREF_SHOWSUPERGLOBALS, false));
        prefs.putInt(XDEBUG_PREF_ARRAYDEPTH, defaults.getInt(XDEBUG_PREF_ARRAYDEPTH, 0));
        prefs.putInt(XDEBUG_PREF_CHILDREN, defaults.getInt(XDEBUG_PREF_CHILDREN, 0));
        prefs.putInt(XDEBUG_PREF_DATA, defaults.getInt(XDEBUG_PREF_DATA, 0));
        prefs.putBoolean(XDEBUG_PREF_MULTISESSION, defaults.getBoolean(XDEBUG_PREF_MULTISESSION, false));
        prefs.putInt(XDEBUG_PREF_REMOTESESSION, defaults.getInt(XDEBUG_PREF_REMOTESESSION, 0));
        prefs.putInt(XDEBUG_PREF_CAPTURESTDOUT, defaults.getInt(XDEBUG_PREF_CAPTURESTDOUT, 0));
        prefs.putInt(XDEBUG_PREF_CAPTURESTDERR, defaults.getInt(XDEBUG_PREF_CAPTURESTDERR, 0));
        prefs.putBoolean(XDEBUG_PREF_USEPROXY, defaults.getBoolean(XDEBUG_PREF_USEPROXY, false));
        prefs.putBoolean(XDEBUG_PREF_IDEKEY, defaults.getBoolean(XDEBUG_PREF_IDEKEY, false));
        prefs.putBoolean(XDEBUG_PREF_PROXY, defaults.getBoolean(XDEBUG_PREF_PROXY, false));
        prefs.putBoolean(XDEBUG_PREF_WARN_NO_LOCALHOST_SESSION, defaults.getBoolean(XDEBUG_PREF_WARN_NO_LOCALHOST_SESSION, false));
    }

    public static DBGpPreferences createSessionPreferences() {
        DBGpPreferences sessionPrefs = new DBGpPreferences();
        int maxDepth = XDebugPreferenceMgr.getInt(XDEBUG_PREF_ARRAYDEPTH);
        if (1 == maxDepth) {
            XDebugPreferenceMgr.setDefaults();
            maxDepth = XDebugPreferenceMgr.getDepthDefault();
        }
        sessionPrefs.setValue("MaxDepth", maxDepth);
        int maxChildren = XDebugPreferenceMgr.getInt(XDEBUG_PREF_CHILDREN);
        sessionPrefs.setValue("MaxChildren", maxChildren);
        int maxData = XDebugPreferenceMgr.getInt(XDEBUG_PREF_DATA);
        sessionPrefs.setValue("MaxData", maxData);
        boolean getSuperGlobals = XDebugPreferenceMgr.getBoolean(XDEBUG_PREF_SHOWSUPERGLOBALS);
        sessionPrefs.setValue("ShowGlobals", getSuperGlobals);
        int captureStdout = XDebugPreferenceMgr.getInt(XDEBUG_PREF_CAPTURESTDOUT);
        sessionPrefs.setValue("CaptureStdout", captureStdout);
        int captureStderr = XDebugPreferenceMgr.getInt(XDEBUG_PREF_CAPTURESTDERR);
        sessionPrefs.setValue("CaptureStderr", captureStderr);
        return sessionPrefs;
    }

    public static int getPort() {
        return XDebugPreferenceMgr.getInt(XDEBUG_PREF_PORT);
    }

    public static void setPort(int port) {
        XDebugPreferenceMgr.setPort(PHPDebugPlugin.getInstancePreferences(), port);
    }

    public static void setPort(IEclipsePreferences preferences, int port) {
        preferences.putInt(XDEBUG_PREF_PORT, port);
    }

    public static boolean useMultiSession() {
        return XDebugPreferenceMgr.getBoolean(XDEBUG_PREF_MULTISESSION);
    }

    public static boolean useProxy() {
        return XDebugPreferenceMgr.getBoolean(XDEBUG_PREF_USEPROXY);
    }

    public static void setUseProxy(boolean newState) {
        PHPDebugPlugin.getInstancePreferences().putBoolean(XDEBUG_PREF_REMOTESESSION, newState);
    }

    public static AcceptRemoteSession getAcceptRemoteSession() {
        return AcceptRemoteSession.values()[XDebugPreferenceMgr.getInt(XDEBUG_PREF_REMOTESESSION)];
    }

    public static boolean getWarnNoLocalhostSession() {
        return XDebugPreferenceMgr.getBoolean(XDEBUG_PREF_WARN_NO_LOCALHOST_SESSION);
    }

    private static boolean getBoolean(String key) {
        return Platform.getPreferencesService().getBoolean("org.eclipse.php.debug.core", key, false, null);
    }

    private static int getInt(String key) {
        return Platform.getPreferencesService().getInt("org.eclipse.php.debug.core", key, 0, null);
    }

    private static int getDepthDefault() {
        return 3;
    }

    private static int getChildrenDefault() {
        return 51;
    }

    private static int getDataDefault() {
        return 1024;
    }

    private static int getPortDefault() {
        return 9000;
    }

    private static boolean showSuperGlobalsDefault() {
        return true;
    }

    private static int getCaptureDefault() {
        return CaptureOutput.copy.ordinal();
    }

    private static boolean useMultiSessionDefault() {
        return true;
    }

    private static int getAcceptRemoteSessionDefault() {
        return AcceptRemoteSession.localhost.ordinal();
    }

    private static boolean getWarnNoLocalhostSessionDefault() {
        return true;
    }

    public static enum AcceptRemoteSession {
        off,
        localhost,
        any,
        prompt;

    }

    public static enum CaptureOutput {
        off,
        copy,
        redirect;

    }
}

