/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.gem.views;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ptp.internal.gem.GemPlugin;
import org.eclipse.ptp.internal.gem.messages.Messages;
import org.eclipse.ptp.internal.gem.util.GemUtilities;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.part.ViewPart;

public class GemConsole
extends ViewPart {
    public static final String ID = "org.eclipse.ptp.gem.views.GemConsole";
    private Action clearConsoleAction;
    private Action writeToLocalFileAction;
    private Action getHelpAction;
    private Action terminateOperationAction;
    private MessageConsole msgConsole;
    private StyledText txtConViewer;
    private Thread disableTerminateButtonThread;
    private Thread clearConsoleThread;

    public void activate() {
        Thread activationThread = new Thread(){

            public void run() {
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                if (page != null) {
                    page.activate((IWorkbenchPart)GemConsole.this);
                }
            }
        };
        Display.getDefault().syncExec((Runnable)activationThread);
    }

    public void cancel() {
        Display.getDefault().syncExec((Runnable)this.disableTerminateButtonThread);
    }

    public void clear() {
        Display.getDefault().syncExec((Runnable)this.clearConsoleThread);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    public void createPartControl(Composite parent) {
        this.txtConViewer = new StyledText(parent, 2816);
        this.txtConViewer.setFont(new Font(null, "Courier", 10, 0));
        this.makeActions();
        this.contributeToActionBars();
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.clearConsoleAction);
        this.clearConsoleAction.setText(Messages.GemConsole_3);
        manager.add((IAction)this.writeToLocalFileAction);
        this.writeToLocalFileAction.setText(Messages.GemConsole_4);
        manager.add((IAction)this.getHelpAction);
        this.getHelpAction.setText(Messages.GemConsole_5);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.terminateOperationAction);
        manager.add((IAction)this.clearConsoleAction);
        manager.add((IAction)this.writeToLocalFileAction);
        manager.add((IAction)this.getHelpAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void init() {
        this.disableTerminateButtonThread = new Thread(){

            public void run() {
                GemConsole.this.terminateOperationAction.setEnabled(false);
            }
        };
        this.clearConsoleThread = new Thread(){

            public void run() {
                GemConsole.this.txtConViewer.setText("");
            }
        };
        this.terminateOperationAction.setEnabled(true);
    }

    private void makeActions() {
        this.terminateOperationAction = new Action(){

            public void run() {
                GemUtilities.terminateOperation();
            }
        };
        this.terminateOperationAction.setImageDescriptor(GemPlugin.getImageDescriptor("icons/progress_stop.gif"));
        this.terminateOperationAction.setToolTipText(Messages.GemAnalyzer_74);
        this.terminateOperationAction.setEnabled(false);
        this.clearConsoleAction = new Action(){

            public void run() {
                GemConsole.this.txtConViewer.setText("");
            }
        };
        this.clearConsoleAction.setToolTipText(Messages.GemConsole_6);
        this.clearConsoleAction.setImageDescriptor(GemPlugin.getImageDescriptor("icons/clear-console.gif"));
        this.writeToLocalFileAction = new Action(){

            public void run() {
                JFileChooser fc = new JFileChooser();
                JFrame frame = new JFrame();
                int result = fc.showSaveDialog(frame);
                if (result == 0) {
                    File file = fc.getSelectedFile();
                    if (file.exists()) {
                        result = fc.showDialog(frame, Messages.GemConsole_7);
                    }
                    if (result == 0) {
                        GemUtilities.saveToLocalFile(file, GemConsole.this.msgConsole.getDocument().get());
                    }
                } else if (result == -1) {
                    GemUtilities.showErrorDialog(Messages.GemConsole_8);
                }
            }
        };
        this.writeToLocalFileAction.setToolTipText(Messages.GemConsole_9);
        this.writeToLocalFileAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVE_EDIT"));
        this.getHelpAction = new Action(){

            public void run() {
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/org.eclipse.ptp.gem.help/html/consoleView.html");
            }
        };
        this.getHelpAction.setToolTipText(Messages.GemConsole_10);
        this.getHelpAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_LCL_LINKTO_HELP"));
    }

    public void setFocus() {
        this.txtConViewer.setFocus();
    }

    public void write(String message) {
        this.txtConViewer.append(message);
        this.txtConViewer.setTopIndex(this.txtConViewer.getLineCount() - 1);
    }

    public void writeStdErr(String consoleStdErrMessage) {
        int oldLen = this.txtConViewer.getText().length();
        this.write(consoleStdErrMessage);
        if (consoleStdErrMessage.length() > 2) {
            StyleRange styleRange = new StyleRange();
            Display display = Display.getDefault();
            styleRange.start = oldLen;
            styleRange.length = consoleStdErrMessage.length();
            styleRange.foreground = display.getSystemColor(3);
            styleRange.fontStyle = 1;
            this.txtConViewer.setStyleRange(styleRange);
        }
    }

    public void writeStdOut(String consoleStdOutMessage) {
        this.write(consoleStdOutMessage);
    }
}

