/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openacc.internal.actions;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorPragmaStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.ArtifactAnalysisBase;
import org.eclipse.ptp.pldt.common.IArtifactAnalysis;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.util.SourceInfo;
import org.eclipse.ptp.pldt.openacc.internal.actions.OpenACCCASTVisitor;
import org.eclipse.ptp.pldt.openacc.internal.messages.Messages;

public class OpenACCCArtifactAnalysis
extends ArtifactAnalysisBase
implements IArtifactAnalysis {
    private static final Pattern ACC_PRAGMA_PATTERN = Pattern.compile("acc[ \t]*(parallel|kernels|data|host_data|loop|cache|declare|update|wait).*");

    public ScanReturn runArtifactAnalysis(String languageID, ITranslationUnit tu, List<String> includes, boolean allowPrefixOnlyMatch) {
        ScanReturn msr = new ScanReturn();
        IASTTranslationUnit atu = this.getAST(tu);
        if (atu != null) {
            this.findOpenACCFunctionCalls(includes, msr, tu.getElementName(), atu, allowPrefixOnlyMatch);
            this.findOpenACCPragmas(atu, msr);
        }
        return msr;
    }

    private void findOpenACCFunctionCalls(List<String> includes, ScanReturn msr, String fileName, IASTTranslationUnit atu, boolean allowPrefixOnlyMatch) {
        atu.accept((ASTVisitor)new OpenACCCASTVisitor(includes, fileName, allowPrefixOnlyMatch, msr));
    }

    private void findOpenACCPragmas(IASTTranslationUnit atu, ScanReturn msr) {
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = atu.getAllPreprocessorStatements();
        int n = iASTPreprocessorStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorStatement preprocStmt = iASTPreprocessorStatementArray[n2];
            if (preprocStmt instanceof IASTPreprocessorPragmaStatement) {
                String pragmaText = String.valueOf(((IASTPreprocessorPragmaStatement)preprocStmt).getMessage()).trim();
                if (preprocStmt.isPartOfTranslationUnitFile() && ACC_PRAGMA_PATTERN.matcher(pragmaText).matches()) {
                    IASTFileLocation astFileLocation = preprocStmt.getFileLocation();
                    SourceInfo sourceInfo = new SourceInfo();
                    sourceInfo.setStartingLine(astFileLocation.getStartingLineNumber());
                    sourceInfo.setStart(astFileLocation.getNodeOffset());
                    sourceInfo.setEnd(astFileLocation.getNodeOffset() + astFileLocation.getNodeLength());
                    sourceInfo.setConstructType(3);
                    msr.addArtifact(new Artifact(preprocStmt.getContainingFilename(), astFileLocation.getStartingLineNumber(), 1, "#pragma " + pragmaText, Messages.RunAnalyseOpenACCcommandHandler_OpenACC_directive, sourceInfo, null));
                }
            }
            ++n2;
        }
    }
}

