/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.server.commands;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.remote.internal.proxy.server.commands.AbstractServerCommand;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public class ServerGetInputStreamCommand
extends AbstractServerCommand {
    private final OutputStream out;
    private final URI uri;
    private final int options;

    public ServerGetInputStreamCommand(StreamChannel chan, int options, String path) {
        this.out = chan.getOutputStream();
        this.options = options;
        this.uri = URI.create("file:" + path);
    }

    @Override
    public void exec() throws ProxyException {
        try {
            BufferedInputStream in = new BufferedInputStream(EFS.getStore((URI)this.uri).openInputStream(this.options, (IProgressMonitor)new NullProgressMonitor()));
            this.startForwarder(in, this.out);
        }
        catch (Exception e) {
            throw new ProxyException(e.getMessage());
        }
    }

    private void startForwarder(InputStream in, OutputStream out) {
        Forwarder forwarder = new Forwarder(in, out);
        new Thread(forwarder).start();
    }

    private class Forwarder
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;

        public Forwarder(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            byte[] buf = new byte[8192];
            try {
                int n;
                while ((n = this.in.read(buf)) >= 0) {
                    if (n <= 0) continue;
                    this.out.write(buf, 0, n);
                    this.out.flush();
                }
            }
            catch (IOException iOException) {}
            try {
                this.out.close();
            }
            catch (IOException iOException) {}
            try {
                this.in.close();
            }
            catch (IOException iOException) {}
        }
    }
}

