/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PossibleTypesService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.WithDef;
import org.eclipse.sapphire.ui.forms.WithPart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.RadioButtonsGroup;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.forms.swt.SapphireKeyboardActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.PageBookPresentation;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class WithPresentation
extends PageBookPresentation {
    @Text(value="None")
    private static LocalizableText noneSelection;
    @Text(value="Enable {0}")
    private static LocalizableText enableElementLabel;

    static {
        LocalizableText.init(WithPresentation.class);
    }

    public WithPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
    }

    @Override
    public WithPart part() {
        return (WithPart)super.part();
    }

    @Override
    public void render() {
        final WithPart part = this.part();
        final WithDef def = part.definition();
        final ElementHandle<?> property = part.property();
        Composite composite = new Composite(this.composite(), 0);
        composite.setLayoutData((Object)GridLayoutUtil.gdhspan(part.getScaleVertically() ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), 2));
        composite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
        this.register((Control)composite);
        final PossibleTypesService possibleTypesService = (PossibleTypesService)property.service(PossibleTypesService.class);
        final Composite typeSelectorComposite = new Composite(composite, 0);
        typeSelectorComposite.setLayoutData((Object)GridLayoutUtil.gdhfill());
        final Runnable renderTypeSelectorOp = new Runnable(){

            @Override
            public void run() {
                Runnable updateUserInterfaceOp;
                PropertyEditorAssistDecorator decorator;
                boolean showLabel;
                Control[] controlArray = typeSelectorComposite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    control.dispose();
                    ++n2;
                }
                Set allPossibleTypes = possibleTypesService.types();
                int allPossibleTypesCount = allPossibleTypes.size();
                WithPart.Style defaultStyle = allPossibleTypesCount == 1 ? WithPart.Style.CHECKBOX : (allPossibleTypesCount <= 3 ? WithPart.Style.RADIO_BUTTONS : WithPart.Style.DROP_DOWN_LIST);
                WithPart.Style style = WithPart.Style.decode(def.getHint("style"));
                if (style == null || style == WithPart.Style.CHECKBOX && allPossibleTypesCount != 1) {
                    style = defaultStyle;
                }
                SapphireActionGroup actions = part.getActions();
                SapphireActionPresentationManager actionPresentationManager = new SapphireActionPresentationManager(WithPresentation.this, actions);
                SapphireKeyboardActionPresentation actionPresentationKeyboard = new SapphireKeyboardActionPresentation(actionPresentationManager);
                boolean bl = showLabel = part.label() != null;
                if (style == WithPart.Style.CHECKBOX) {
                    typeSelectorComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
                    decorator = new PropertyEditorAssistDecorator(part, (Property)property, typeSelectorComposite);
                    decorator.control().setLayoutData((Object)GridLayoutUtil.gd());
                    final Button masterCheckBox = new Button(typeSelectorComposite, 32);
                    masterCheckBox.setLayoutData((Object)GridLayoutUtil.gd());
                    decorator.addEditorControl((Control)masterCheckBox);
                    actionPresentationKeyboard.attach((Control)masterCheckBox);
                    WithPresentation.attachHelp((Control)masterCheckBox, (Property)property);
                    if (showLabel) {
                        masterCheckBox.setText(part.label(CapitalizationType.FIRST_WORD_ONLY, true));
                        WithPresentation.this.attachPartListener((Listener)new FilteredListener<SapphirePart.LabelChangedEvent>(){

                            protected void handleTypedEvent(SapphirePart.LabelChangedEvent event) {
                                masterCheckBox.setText(part.label(CapitalizationType.FIRST_WORD_ONLY, true));
                                WithPresentation.this.layout();
                            }
                        });
                    }
                    updateUserInterfaceOp = new Runnable(){

                        @Override
                        public void run() {
                            if (Display.getCurrent() == null) {
                                masterCheckBox.getDisplay().asyncExec((Runnable)this);
                                return;
                            }
                            Element subModelElement = property.content();
                            masterCheckBox.setSelection(subModelElement != null);
                            masterCheckBox.setEnabled(property.enabled());
                        }
                    };
                    masterCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            block4: {
                                try {
                                    ElementHandle handle = property;
                                    if (masterCheckBox.getSelection()) {
                                        handle.content(true);
                                    } else {
                                        handle.clear();
                                    }
                                }
                                catch (Exception e) {
                                    EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                                    if (editFailedException != null) break block4;
                                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                                }
                            }
                        }
                    });
                } else {
                    typeSelectorComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(3, 0, 0), 2));
                    if (showLabel) {
                        final Label label = new Label(typeSelectorComposite, 0);
                        label.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gd(), 9));
                        label.setText(String.valueOf(part.label(CapitalizationType.FIRST_WORD_ONLY, true)) + ":");
                        WithPresentation.this.attachPartListener((Listener)new FilteredListener<SapphirePart.LabelChangedEvent>(){

                            protected void handleTypedEvent(SapphirePart.LabelChangedEvent event) {
                                label.setText(String.valueOf(part.label(CapitalizationType.FIRST_WORD_ONLY, true)) + ":");
                                WithPresentation.this.layout();
                            }
                        });
                    }
                    decorator = new PropertyEditorAssistDecorator(part, (Property)property, typeSelectorComposite);
                    decorator.control().setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), style == WithPart.Style.DROP_DOWN_LIST ? 128 : 0x1000000), showLabel ? 3 : 0));
                    if (style == WithPart.Style.RADIO_BUTTONS) {
                        final RadioButtonsGroup radioButtonsGroup = new RadioButtonsGroup(typeSelectorComposite, false);
                        radioButtonsGroup.setLayoutData(GridLayoutUtil.gdhfill());
                        final HashMap<ElementType, Button> typeToButton = new HashMap<ElementType, Button>();
                        final HashMap<Button, ElementType> buttonToType = new HashMap<Button, ElementType>();
                        for (ElementType type : allPossibleTypes) {
                            String label = type.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false);
                            Button button = radioButtonsGroup.addRadioButton(label);
                            typeToButton.put(type, button);
                            buttonToType.put(button, type);
                            decorator.addEditorControl((Control)button);
                            actionPresentationKeyboard.attach((Control)button);
                            WithPresentation.attachHelp((Control)button, (Property)property);
                        }
                        final Button noneButton = radioButtonsGroup.addRadioButton(noneSelection.text());
                        noneButton.setVisible(false);
                        decorator.addEditorControl((Control)noneButton);
                        actionPresentationKeyboard.attach((Control)noneButton);
                        WithPresentation.attachHelp((Control)noneButton, (Property)property);
                        updateUserInterfaceOp = new Runnable(){

                            @Override
                            public void run() {
                                Button button;
                                if (Display.getCurrent() == null) {
                                    radioButtonsGroup.getDisplay().asyncExec((Runnable)this);
                                    return;
                                }
                                Element subModelElement = property.content();
                                if (subModelElement == null) {
                                    button = noneButton;
                                    noneButton.setVisible(true);
                                } else {
                                    button = (Button)typeToButton.get(subModelElement.type());
                                    noneButton.setVisible(false);
                                }
                                if (radioButtonsGroup.getSelection() != button) {
                                    radioButtonsGroup.setSelection(button);
                                }
                                radioButtonsGroup.setEnabled(property.enabled());
                            }
                        };
                        radioButtonsGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                block4: {
                                    try {
                                        ElementHandle handle = property;
                                        Button button = radioButtonsGroup.getSelection();
                                        if (button == noneButton) {
                                            handle.clear();
                                        } else {
                                            ElementType type = (ElementType)buttonToType.get(button);
                                            handle.content(true, type);
                                        }
                                    }
                                    catch (Exception e) {
                                        EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                                        if (editFailedException != null) break block4;
                                        ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                                    }
                                }
                            }
                        });
                    } else if (style == WithPart.Style.DROP_DOWN_LIST) {
                        final Combo combo = new Combo(typeSelectorComposite, 2060);
                        combo.setLayoutData((Object)GridLayoutUtil.gdhfill());
                        decorator.addEditorControl((Control)combo);
                        actionPresentationKeyboard.attach((Control)combo);
                        WithPresentation.attachHelp((Control)combo, (Property)property);
                        final HashMap<ElementType, Integer> typeToIndex = new HashMap<ElementType, Integer>();
                        final HashMap<Integer, ElementType> indexToType = new HashMap<Integer, ElementType>();
                        int index = 0;
                        for (ElementType type : allPossibleTypes) {
                            String label = type.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false);
                            combo.add(label);
                            typeToIndex.put(type, index);
                            indexToType.put(index, type);
                            ++index;
                        }
                        updateUserInterfaceOp = new Runnable(){

                            @Override
                            public void run() {
                                if (Display.getCurrent() == null) {
                                    combo.getDisplay().asyncExec((Runnable)this);
                                    return;
                                }
                                Element subModelElement = property.content();
                                int index = subModelElement == null ? -1 : (Integer)typeToIndex.get(subModelElement.type());
                                if (combo.getSelectionIndex() != index) {
                                    if (index == -1) {
                                        combo.deselectAll();
                                    } else {
                                        combo.select(index);
                                    }
                                }
                                combo.setEnabled(property.enabled());
                            }
                        };
                        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                block4: {
                                    try {
                                        ElementHandle handle = property;
                                        int index = combo.getSelectionIndex();
                                        if (index == -1) {
                                            handle.clear();
                                        } else {
                                            ElementType type = (ElementType)indexToType.get(index);
                                            handle.content(true, type);
                                        }
                                    }
                                    catch (Exception e) {
                                        EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                                        if (editFailedException != null) break block4;
                                        ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                                    }
                                }
                            }
                        });
                    } else {
                        throw new IllegalStateException();
                    }
                }
                actionPresentationKeyboard.render();
                updateUserInterfaceOp.run();
                FilteredListener<PropertyEvent> modelPropertyListener = new FilteredListener<PropertyEvent>(){

                    protected void handleTypedEvent(PropertyEvent event) {
                        updateUserInterfaceOp.run();
                    }
                };
                property.attach((Listener)modelPropertyListener);
                typeSelectorComposite.layout(true, true);
                typeSelectorComposite.getChildren()[0].addDisposeListener(new DisposeListener((Listener)modelPropertyListener, actionPresentationManager, actionPresentationKeyboard){
                    private final /* synthetic */ Listener val$modelPropertyListener;
                    private final /* synthetic */ SapphireActionPresentationManager val$actionPresentationManager;
                    private final /* synthetic */ SapphireKeyboardActionPresentation val$actionPresentationKeyboard;
                    {
                        this.val$modelPropertyListener = listener;
                        this.val$actionPresentationManager = sapphireActionPresentationManager;
                        this.val$actionPresentationKeyboard = sapphireKeyboardActionPresentation;
                    }

                    public void widgetDisposed(DisposeEvent event) {
                        property.detach(this.val$modelPropertyListener);
                        this.val$actionPresentationManager.dispose();
                        this.val$actionPresentationKeyboard.dispose();
                    }
                });
            }
        };
        renderTypeSelectorOp.run();
        final Listener possibleTypesServiceListener = new Listener(){

            public void handle(Event event) {
                renderTypeSelectorOp.run();
            }
        };
        possibleTypesService.attach(possibleTypesServiceListener);
        typeSelectorComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                possibleTypesService.detach(possibleTypesServiceListener);
            }
        });
        Composite separatorComposite = new Composite(composite, 0);
        separatorComposite.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), 2), 9));
        separatorComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 5));
        Label separator = new Label(separatorComposite, 258);
        separator.setLayoutData((Object)GridLayoutUtil.gdhfill());
        super.render(composite);
    }
}

