/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.ui.proposal;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.NlsCore;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.action.NlsEntryNewAction;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.proposal.AbstractNlsProposal;
import org.eclipse.scout.sdk.s2e.nls.model.INlsEntry;
import org.eclipse.scout.sdk.s2e.nls.model.Language;
import org.eclipse.scout.sdk.s2e.nls.model.NlsEntry;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class NewNlsProposal
extends AbstractNlsProposal {
    private final Image m_image = NlsCore.getImage("text_add");
    private final INlsProject m_project;
    private INlsEntry m_nlsEntry;

    public NewNlsProposal(INlsProject project, String prefix, int initialOffset) {
        super(prefix, initialOffset);
        this.m_project = project;
    }

    @Override
    public int getRelevance() {
        return 0;
    }

    @Override
    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            Point keyRange = this.findKeyRange(document, offset);
            if (keyRange != null) {
                return keyRange.x < offset && keyRange.y >= offset;
            }
        }
        catch (BadLocationException e) {
            SdkLog.error((Object[])new Object[]{e});
        }
        return false;
    }

    @Override
    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.apply(viewer.getDocument(), trigger, offset);
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        String searchText = null;
        int initalOffset = this.getInitialOffset();
        try {
            searchText = document.get(initalOffset - this.getPrefix().length(), this.getPrefix().length() + offset - initalOffset);
        }
        catch (BadLocationException e1) {
            SdkLog.warning((Object[])new Object[]{e1});
        }
        String proposalFieldText = "";
        if (StringUtils.isNotEmpty(searchText)) {
            proposalFieldText = CoreUtils.fromStringLiteral((String)("\"" + searchText + "\""));
        }
        String key = this.m_project.generateNewKey(proposalFieldText);
        NlsEntry entry = new NlsEntry(key, this.m_project);
        Language devLang = this.m_project.getDevelopmentLanguage();
        entry.addTranslation(devLang, proposalFieldText);
        if (!Language.LANGUAGE_DEFAULT.equals(devLang)) {
            entry.addTranslation(Language.LANGUAGE_DEFAULT, proposalFieldText);
        }
        NlsEntryNewAction action = new NlsEntryNewAction(Display.getDefault().getActiveShell(), this.m_project, entry, true);
        action.run();
        try {
            action.join();
        }
        catch (InterruptedException e) {
            SdkLog.warning((Object[])new Object[]{e});
        }
        this.m_nlsEntry = action.getEntry();
        if (this.m_nlsEntry != null) {
            try {
                this.replaceWith(document, offset, this.m_nlsEntry.getKey());
            }
            catch (BadLocationException e) {
                SdkLog.error((Object[])new Object[]{e});
            }
        }
    }

    @Override
    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    @Override
    public char[] getTriggerCharacters() {
        return null;
    }

    @Override
    public int getContextInformationPosition() {
        return 0;
    }

    @Override
    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return "New text...";
    }

    public Image getImage() {
        return this.m_image;
    }

    @Override
    public IContextInformation getContextInformation() {
        return null;
    }

    @Override
    public boolean isAutoInsertable() {
        return false;
    }
}

