/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.policies;

import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Vector;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionEditPartQuery;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.locator.EdgeLabelLocator;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;

public class InitialPointsOfRequestDataManager {
    private static final String INITIAL_POINTS_KEY = "InitialPointsManagerForEdgePolicy.initialPointsKey";
    private PointList initialPoints;

    public void storeInitialPointsInRequest(LocationRequest request, ConnectionEditPart connectionEditPart) {
        if (this.initialPoints == null) {
            this.initialPoints = new PointList();
            Connection connection = (Connection)connectionEditPart.getFigure();
            int i = 0;
            while (i < connection.getPoints().size()) {
                this.initialPoints.addPoint(connection.getPoints().getPoint(i).getCopy());
                ++i;
            }
            request.getExtendedData().put(INITIAL_POINTS_KEY, this.initialPoints);
            List children = connectionEditPart.getChildren();
            for (Object child : children) {
                Object currentConstraint;
                if (!(child instanceof AbstractDEdgeNameEditPart)) continue;
                Object view = ((AbstractDEdgeNameEditPart)child).getModel();
                IFigure figure = ((AbstractDEdgeNameEditPart)child).getFigure();
                if (!(view instanceof Node) || !(figure instanceof SiriusWrapLabel) || !((currentConstraint = connection.getLayoutManager().getConstraint(figure)) instanceof EdgeLabelLocator)) continue;
                EdgeLabelLocator edgeLabelLocator = (EdgeLabelLocator)((Object)currentConstraint);
                edgeLabelLocator.setFeedbackData(this.initialPoints, new Vector((double)edgeLabelLocator.getOffset().x, (double)edgeLabelLocator.getOffset().y), new ConnectionEditPartQuery(connectionEditPart).isEdgeWithObliqueRoutingStyle());
            }
        }
    }

    public void eraseInitialPoints(Connection connection) {
        this.initialPoints = null;
        for (Object object : connection.getChildren()) {
            Object currentConstraint;
            if (!(object instanceof SiriusWrapLabel) || !((currentConstraint = connection.getLayoutManager().getConstraint((IFigure)((SiriusWrapLabel)((Object)object)))) instanceof EdgeLabelLocator)) continue;
            ((EdgeLabelLocator)((Object)currentConstraint)).eraseFeedbackData();
        }
    }

    public static PointList getOriginalPoints(LocationRequest request) {
        return (PointList)request.getExtendedData().get(INITIAL_POINTS_KEY);
    }
}

