/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ITransparentFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ImageFigureWithAlpha;
import org.eclipse.sirius.diagram.ui.tools.api.figure.StyledFigure;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.TransparentFigureGraphicsModifier;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public abstract class AbstractTransparentImage
extends ImageFigure
implements StyledFigure,
ITransparentFigure,
ImageFigureWithAlpha {
    private int viewpointAlpha = 100;
    private boolean transparent;
    private ImageData imageData;

    public AbstractTransparentImage(Image flyWeightImage) {
        super(flyWeightImage);
        this.imageData = flyWeightImage.getImageData();
    }

    protected void paintFigure(Graphics graphics) {
        if (this.getImage() != null) {
            TransparentFigureGraphicsModifier modifier = new TransparentFigureGraphicsModifier(this, graphics);
            modifier.pushState();
            graphics.drawImage(this.getImage(), new Rectangle(this.getImage().getBounds()), this.getBounds());
            modifier.popState();
        }
    }

    @Override
    public int getSiriusAlpha() {
        return this.viewpointAlpha;
    }

    @Override
    public boolean isTransparent() {
        return this.transparent;
    }

    @Override
    public void setSiriusAlpha(int alpha) {
        this.viewpointAlpha = alpha;
    }

    @Override
    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    @Override
    public int getImageHeight() {
        return this.imageData.height;
    }

    @Override
    public int getImageWidth() {
        return this.imageData.width;
    }

    @Override
    public int getImageAlphaValue(int x, int y) {
        if (x < this.imageData.width && y < this.imageData.height) {
            return this.imageData.getAlpha(x, y) == 0 ? 0 : 255;
        }
        return 255;
    }

    public void setImage(Image image) {
        if (this.getImage() == image) {
            return;
        }
        super.setImage(image);
        this.imageData = image.getImageData();
    }
}

