/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.views.providers.filters;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.ui.tools.internal.handler.ChangeFilterActivation;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.filters.FiltersActivationAdapter;
import org.eclipse.swt.widgets.Item;

public class FiltersCellModifier
implements ICellModifier {
    private final IDiagramWorkbenchPart diagramPart;
    private final String[] filtersColumns;

    public FiltersCellModifier(FiltersActivationAdapter adapter, IDiagramWorkbenchPart part, String[] columns) {
        this.diagramPart = part;
        this.filtersColumns = columns;
    }

    public boolean canModify(Object element, String property) {
        return property.equals(this.filtersColumns[0]);
    }

    public Object getValue(Object element, String property) {
        FilterDescription filter = (FilterDescription)element;
        Object result = null;
        if (property.equals(this.filtersColumns[0])) {
            EObject designerElement;
            DiagramEditPart diaEditPart = this.diagramPart.getDiagramEditPart();
            Object obj = diaEditPart.getModel();
            if (obj instanceof View && (designerElement = ((View)obj).getElement()) instanceof DDiagram) {
                EList activatedFilters = ((DDiagram)designerElement).getActivatedFilters();
                result = activatedFilters.contains(element) ? Boolean.TRUE : Boolean.FALSE;
            }
        } else {
            result = filter.getName();
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        DiagramEditPart diaEditPart;
        Object obj;
        Object objElement = element instanceof Item ? ((Item)element).getData() : element;
        FilterDescription filterDescription = (FilterDescription)objElement;
        if (property.equals(this.filtersColumns[0]) && (obj = (diaEditPart = this.diagramPart.getDiagramEditPart()).getModel()) instanceof View) {
            EObject designerElement = ((View)obj).getElement();
            PaletteViewer paletteViewer = this.diagramPart.getDiagramGraphicalViewer().getEditDomain().getPaletteViewer();
            if (designerElement instanceof DDiagram && paletteViewer != null) {
                ChangeFilterActivation change = new ChangeFilterActivation(this.diagramPart, (DDiagram)designerElement, filterDescription, value.equals(Boolean.TRUE));
                change.run();
            }
        }
    }
}

