/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.va;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.runtime.interfaces.ISharedConstants;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.processes.ProcessOutputReaderThread;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.core.nls.Messages;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.core.va.AbstractValueAdd;
import org.eclipse.tcf.te.tcf.core.va.ValueAddException;
import org.eclipse.tcf.te.tcf.core.va.ValueAddLauncher;

public abstract class AbstractExternalValueAdd
extends AbstractValueAdd {
    final Map<String, ValueAddEntry> entries = new HashMap<String, ValueAddEntry>();

    protected boolean disposeProcess(Process process) {
        Assert.isNotNull((Object)process);
        return false;
    }

    @Override
    public IPeer getPeer(String id) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        IPeer peer = null;
        ValueAddEntry entry = this.entries.get(id);
        if (entry != null) {
            peer = entry.peer;
        }
        return peer;
    }

    @Override
    public void isAlive(String id, ICallback done) {
        this.isAlive(id, done, true);
    }

    public void isAlive(final String id, final ICallback done, boolean testResponsive) {
        String[] attrs;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)done);
        done.setResult((Object)Boolean.FALSE);
        ValueAddEntry entry = this.entries.get(id);
        if (entry == null && this.getDebugPeerId() != null && (attrs = this.getDebugPeerId().split(":")).length == 3) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("ID", this.getDebugPeerId());
            props.put("TransportName", attrs[0]);
            if (attrs[1].length() > 0) {
                props.put("Host", attrs[1]);
            } else {
                props.put("Host", IPAddressUtil.getInstance().getIPv4LoopbackAddress());
            }
            props.put("Port", attrs[2]);
            entry = new ValueAddEntry();
            entry.peer = new Peer(props);
            this.entries.put(id, entry);
        }
        if (entry != null) {
            boolean exited = false;
            if (entry.process != null) {
                Assert.isNotNull((Object)entry.peer);
                try {
                    entry.process.exitValue();
                    exited = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
            }
            if (!exited) {
                if (testResponsive) {
                    final ValueAddEntry finEntry = entry;
                    final IChannel channel = entry.peer.openChannel();
                    channel.addChannelListener(new IChannel.IChannelListener(){

                        public void onChannelOpened() {
                            channel.removeChannelListener((IChannel.IChannelListener)this);
                            channel.close();
                            done.setResult((Object)Boolean.TRUE);
                            done.done((Object)AbstractExternalValueAdd.this, Status.OK_STATUS);
                        }

                        public void onChannelClosed(Throwable error) {
                            channel.removeChannelListener((IChannel.IChannelListener)this);
                            AbstractExternalValueAdd.this.entries.remove(id);
                            finEntry.dispose();
                            done.done((Object)AbstractExternalValueAdd.this, Status.OK_STATUS);
                        }

                        public void congestionLevel(int level) {
                        }
                    });
                } else {
                    done.setResult((Object)Boolean.TRUE);
                    done.done((Object)this, Status.OK_STATUS);
                }
            } else {
                done.done((Object)this, Status.OK_STATUS);
            }
        } else {
            done.done((Object)this, Status.OK_STATUS);
        }
    }

    @Override
    public void launch(String id, ICallback done) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)done);
        ValueAddException error = null;
        IPath path = this.getLocation();
        if (path != null && path.toFile().canRead()) {
            ValueAddEntry entry;
            ValueAddLauncher launcher;
            block34: {
                launcher = this.createLauncher(id, path);
                try {
                    launcher.launch();
                }
                catch (ValueAddException e) {
                    error = e;
                }
                entry = new ValueAddEntry();
                if (error == null) {
                    if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                        CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.AbstractExternalValueAdd_start_at, (Object)ISharedConstants.TIME_FORMAT.format(new Date(System.currentTimeMillis())), (Object)id), 0, "trace/channelManager", 1, (Object)this);
                    }
                    Process process = launcher.getProcess();
                    try {
                        int exitCode = process.exitValue();
                        error = this.onProcessDied(launcher, exitCode);
                        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.AbstractExternalValueAdd_died_at, (Object[])new Object[]{ISharedConstants.TIME_FORMAT.format(new Date(System.currentTimeMillis())), exitCode, id}), 0, "trace/channelManager", 1, (Object)this);
                        }
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        entry.process = process;
                        entry.outputReader = launcher.getOutputReader();
                        entry.errorReader = launcher.getErrorReader();
                        if (!CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) break block34;
                        CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.AbstractExternalValueAdd_running_at, (Object)ISharedConstants.TIME_FORMAT.format(new Date(System.currentTimeMillis())), (Object)id), 0, "trace/channelManager", 1, (Object)this);
                    }
                }
            }
            String output = null;
            if (error == null) {
                long timeout = this.getWaitForValueAddOutputTimeout();
                int counter = Long.valueOf(Math.max(timeout, 200L) / 200L).intValue();
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.AbstractExternalValueAdd_start_waiting_at, (Object[])new Object[]{ISharedConstants.TIME_FORMAT.format(new Date(System.currentTimeMillis())), timeout, counter, id}), 0, "trace/channelManager", 1, (Object)this);
                }
                while (counter > 0 && output == null) {
                    try {
                        int exitCode = entry.process.exitValue();
                        error = this.onProcessDied(launcher, exitCode);
                        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.AbstractExternalValueAdd_died_at, (Object[])new Object[]{ISharedConstants.TIME_FORMAT.format(new Date(System.currentTimeMillis())), exitCode, id}), 0, "trace/channelManager", 1, (Object)this);
                        }
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {}
                    if (error != null) break;
                    output = launcher.getOutputReader().getOutput();
                    if ("".equals(output) || output.indexOf("Server-Properties:") == -1) {
                        output = null;
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    --counter;
                }
                if (output == null && error == null) {
                    String stderr = !"".equals(launcher.getErrorReader().getOutput()) ? NLS.bind((String)Messages.AbstractExternalValueAdd_error_output, (Object)this.getLabel(), (Object)this.formatErrorOutput(launcher.getErrorReader().getOutput())) : "";
                    error = new ValueAddException(new IOException(NLS.bind((String)Messages.AbstractExternalValueAdd_error_failedToReadOutput, (Object)this.getLabel(), (Object)stderr)));
                }
            }
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.AbstractExternalValueAdd_stop_waiting_at, (Object[])new Object[]{ISharedConstants.TIME_FORMAT.format(new Date(System.currentTimeMillis())), error, id}), 0, "trace/channelManager", 1, (Object)this);
            }
            HashMap<String, String> attrs = null;
            if (error == null) {
                int start;
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.AbstractExternalValueAdd_output, (Object)output, (Object)id), 0, "trace/channelManager", 1, (Object)this);
                }
                if ((start = output.indexOf("Server-Properties:")) != -1 && start > 0) {
                    output = output.substring(start);
                }
                output = output.replace("Server-Properties:", " ");
                if ((output = output.trim()).indexOf(10) != -1) {
                    output = output.substring(0, output.indexOf(10));
                    output = output.trim();
                }
                Object object = null;
                try {
                    object = JSON.parseOne((byte[])output.getBytes("UTF-8"));
                    attrs = new HashMap<String, String>((Map)object);
                }
                catch (IOException e) {
                    error = new ValueAddException(e);
                }
            }
            if (error == null) {
                String transport = (String)attrs.get("TransportName");
                String port = (String)attrs.get("Port");
                String ip = IPAddressUtil.getInstance().getIPv4LoopbackAddress();
                if (transport != null && ip != null && port != null) {
                    String peerId = String.valueOf(transport) + ":" + ip + ":" + port;
                    attrs.put("ID", peerId);
                    attrs.put("Host", ip);
                    entry.peer = new Peer(attrs);
                } else {
                    error = new ValueAddException(new IOException(NLS.bind((String)Messages.AbstractExternalValueAdd_error_invalidPeerAttributes, (Object)this.getLabel())));
                }
            }
            if (error == null) {
                Assert.isNotNull((Object)entry.process);
                Assert.isNotNull((Object)entry.peer);
                this.entries.put(id, entry);
            }
            if (launcher.getOutputReader() != null) {
                launcher.getOutputReader().setBuffering(false);
            }
            if (launcher.getErrorReader() != null) {
                launcher.getErrorReader().setBuffering(false);
            }
            if (error != null) {
                entry.dispose();
            }
        } else {
            error = new ValueAddException(new FileNotFoundException(NLS.bind((String)Messages.AbstractExternalValueAdd_error_invalidLocation, (Object)this.getLabel(), (Object)(path != null ? path.toOSString() : "n/a"))));
        }
        IStatus status = Status.OK_STATUS;
        if (error != null) {
            status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), error.getLocalizedMessage(), (Throwable)error);
        }
        done.done((Object)this, status);
    }

    protected abstract IPath getLocation();

    protected ValueAddException onProcessDied(ValueAddLauncher launcher, int exitCode) {
        Assert.isNotNull((Object)((Object)launcher));
        String output = launcher.getErrorReader() != null ? launcher.getErrorReader().getOutput() : null;
        String cause = output != null && !"".equals(output) ? NLS.bind((String)Messages.AbstractExternalValueAdd_error_cause, (Object)this.formatErrorOutput(output)) : null;
        String message = NLS.bind((String)Messages.AbstractExternalValueAdd_error_processDied, (Object)this.getLabel(), (Object)exitCode);
        return new ValueAddException(new IOException(cause != null ? String.valueOf(message) + cause : message));
    }

    protected String formatErrorOutput(String output) {
        Assert.isNotNull((Object)output);
        return output;
    }

    protected long getWaitForValueAddOutputTimeout() {
        return 2000L;
    }

    protected ValueAddLauncher createLauncher(String id, IPath path) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)path);
        return new ValueAddLauncher(id, path, this.getLabel() != null ? this.getLabel() : this.getId());
    }

    @Override
    public void shutdown(final String id, final ICallback done) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)done);
        final ValueAddEntry entry = this.entries.get(id);
        if (entry != null) {
            this.isAlive(id, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    boolean alive = (Boolean)this.getResult();
                    if (alive) {
                        AbstractExternalValueAdd.this.entries.remove(id);
                        entry.dispose();
                    }
                    done.done((Object)AbstractExternalValueAdd.this, Status.OK_STATUS);
                }
            }, false);
        } else {
            done.done((Object)this, Status.OK_STATUS);
        }
    }

    @Override
    public void shutdownAll(ICallback done) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)done);
        for (Map.Entry<String, ValueAddEntry> entry : this.entries.entrySet()) {
            ValueAddEntry value = entry.getValue();
            value.dispose();
        }
        this.entries.clear();
        done.done((Object)this, Status.OK_STATUS);
    }

    protected class ValueAddEntry
    implements IDisposable {
        public Process process;
        public IPeer peer;
        public ProcessOutputReaderThread outputReader;
        public ProcessOutputReaderThread errorReader;

        protected ValueAddEntry() {
        }

        public void dispose() {
            if (this.process != null) {
                if (!AbstractExternalValueAdd.this.disposeProcess(this.process)) {
                    this.process.destroy();
                }
                this.process = null;
            }
            if (this.outputReader != null) {
                this.outputReader.interrupt();
                this.outputReader = null;
            }
            if (this.errorReader != null) {
                this.errorReader.interrupt();
                this.errorReader = null;
            }
        }
    }
}

