/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare;

import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.compare.LocalTypedElement;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;

public class EditableSharedDocumentAdapter
extends SharedDocumentAdapter
implements IElementStateListener {
    private int connectionCount;
    private final ISharedDocumentAdapterListener listener;
    private IEditorInput bufferedKey;

    public EditableSharedDocumentAdapter(ISharedDocumentAdapterListener listener) {
        this.listener = listener;
    }

    public void connect(IDocumentProvider provider, IEditorInput documentKey) throws CoreException {
        super.connect(provider, documentKey);
        ++this.connectionCount;
        if (this.connectionCount == 1) {
            provider.addElementStateListener((IElementStateListener)this);
            this.listener.handleDocumentConnected();
        }
    }

    public void disconnect(IDocumentProvider provider, IEditorInput documentKey) {
        try {
            super.disconnect(provider, documentKey);
        }
        finally {
            if (this.connectionCount > 0) {
                --this.connectionCount;
            }
            if (this.connectionCount == 0) {
                provider.removeElementStateListener((IElementStateListener)this);
                this.listener.handleDocumentDisconnected();
            }
        }
    }

    public boolean isConnected() {
        return this.connectionCount > 0;
    }

    public boolean saveDocument(IEditorInput input, IProgressMonitor monitor) throws CoreException {
        if (this.isConnected()) {
            IDocumentProvider provider = SharedDocumentAdapter.getDocumentProvider((IEditorInput)input);
            try {
                this.saveDocument(provider, input, provider.getDocument((Object)input), true, monitor);
            }
            finally {
                this.releaseBuffer();
            }
            return true;
        }
        return false;
    }

    public void releaseBuffer() {
        if (this.bufferedKey != null) {
            IDocumentProvider provider = SharedDocumentAdapter.getDocumentProvider((IEditorInput)this.bufferedKey);
            provider.disconnect((Object)this.bufferedKey);
            this.bufferedKey = null;
        }
    }

    public void flushDocument(IDocumentProvider provider, IEditorInput documentKey, IDocument document, boolean overwrite) throws CoreException {
        if (!this.hasBufferedContents()) {
            this.bufferedKey = documentKey;
            provider.connect((Object)this.bufferedKey);
        }
        this.listener.handleDocumentFlushed();
    }

    public void elementContentAboutToBeReplaced(Object element) {
    }

    public void elementContentReplaced(Object element) {
    }

    public void elementDeleted(Object element) {
        this.listener.handleDocumentDeleted();
    }

    public void elementDirtyStateChanged(Object element, boolean isDirty) {
        if (!isDirty) {
            this.listener.handleDocumentSaved();
        }
    }

    public void elementMoved(Object originalElement, Object movedElement) {
    }

    public boolean hasBufferedContents() {
        return this.bufferedKey != null;
    }

    public IEditorInput getDocumentKey(Object element) {
        if (element instanceof LocalTypedElement) {
            LocalTypedElement localElement = (LocalTypedElement)element;
            return localElement.getEditorInput();
        }
        return super.getDocumentKey(element);
    }

    public static interface ISharedDocumentAdapterListener {
        public void handleDocumentConnected();

        public void handleDocumentDisconnected();

        public void handleDocumentFlushed();

        public void handleDocumentDeleted();

        public void handleDocumentSaved();
    }
}

