/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.util.StringMatcher;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.CommitCommentArea;
import org.eclipse.team.internal.ccvs.ui.wizards.ModeWizard;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ModeWizardSelectionPage
extends WizardPage {
    private static final int LARGE_COLUMN = 50;
    protected static final int INDEX_FILE = 0;
    protected static final int INDEX_MODE = 1;
    protected static final int INDEX_PATH = 2;
    protected static final String PROPERTY_FILE = "file";
    protected static final String PROPERTY_MODE = "mode";
    protected static final String PROPERTY_CHANGED = "changed";
    protected static final Command.KSubstOption[] MODES = Command.KSubstOption.getAllKSubstOptions();
    protected static final String[] COMBO_TEXT;
    static final int COLUMN_MIN_WIDTH_IN_CHARS;
    private final List fChanges;
    protected ModeChangeTable fTable;
    private CommitCommentArea fCommentArea;

    static {
        Arrays.sort(MODES, new Comparator(){

            public int compare(Object a, Object b) {
                String aKey = ((Command.KSubstOption)a).getLongDisplayText();
                String bKey = ((Command.KSubstOption)b).getLongDisplayText();
                return aKey.compareTo(bKey);
            }
        });
        COMBO_TEXT = new String[MODES.length];
        int maxLength = 0;
        int i = 0;
        while (i < MODES.length) {
            ModeWizardSelectionPage.COMBO_TEXT[i] = MODES[i].getLongDisplayText();
            if (COMBO_TEXT[i].length() > maxLength) {
                maxLength = COMBO_TEXT[i].length();
            }
            ++i;
        }
        COLUMN_MIN_WIDTH_IN_CHARS = maxLength;
    }

    public ModeWizardSelectionPage(List modeChanges) {
        super(CVSUIMessages.ModeWizardSelectionPage_18, CVSUIMessages.ModeWizardSelectionPage_19, CVSUIPlugin.getPlugin().getImageDescriptor("wizban/keywordsub_wizban.png"));
        this.setDescription(CVSUIMessages.ModeWizardSelectionPage_20);
        this.fChanges = modeChanges;
    }

    public void createControl(Composite parent) {
        PixelConverter converter = SWTUtils.createDialogPixelConverter((Control)parent);
        int horizontalSpace = converter.convertHorizontalDLUsToPixels(7);
        int verticalSpace = converter.convertVerticalDLUsToPixels(7);
        Composite mainComposite = SWTUtils.createHVFillComposite((Composite)parent, (int)-1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainComposite, "org.eclipse.team.cvs.ui.keyword_substitution_page_context");
        SashForm mainSash = new SashForm(mainComposite, 512);
        mainSash.setLayoutData((Object)SWTUtils.createHVFillGridData());
        Composite topComposite = SWTUtils.createHVFillComposite((Composite)mainSash, (int)0);
        ((GridLayout)topComposite.getLayout()).marginBottom = verticalSpace;
        Group topGroup = SWTUtils.createHVFillGroup((Composite)topComposite, (String)CVSUIMessages.ModeWizardSelectionPage_21, (int)1);
        Composite filterComposite = SWTUtils.createHFillComposite((Composite)topGroup, (int)0, (int)2);
        FilterTextBox filterBox = new FilterTextBox(this, filterComposite, converter);
        this.fTable = new ModeChangeTable((Composite)topGroup, converter, this.fChanges);
        Composite selectionComposite = SWTUtils.createHFillComposite((Composite)topGroup, (int)0, (int)2);
        new ChangeCounterLabel(selectionComposite, this.fTable);
        new SelectionCounterLabel(selectionComposite, this.fTable);
        new ShowChangesOnlyCheckbox(this, selectionComposite);
        Composite buttonComposite = SWTUtils.createHFillComposite((Composite)selectionComposite, (int)0, (int)2);
        buttonComposite.setLayoutData((Object)new GridData());
        new SelectAllButton(this, buttonComposite, converter);
        new SelectNoneButton(this, buttonComposite, converter);
        SashForm bottomSash = new SashForm((Composite)mainSash, 0);
        bottomSash.setLayoutData((Object)SWTUtils.createHFillGridData());
        Composite leftComposite = SWTUtils.createHVFillComposite((Composite)bottomSash, (int)0, (int)1);
        ((GridLayout)leftComposite.getLayout()).marginRight = horizontalSpace;
        ((GridLayout)leftComposite.getLayout()).marginTop = verticalSpace;
        final Group leftGroup = SWTUtils.createHVFillGroup((Composite)leftComposite, (String)CVSUIMessages.ModeWizardSelectionPage_22, (int)1, (int)3);
        new ModeCombo(this.fTable, (Composite)leftGroup);
        new GuessButton(this.fTable, (Composite)leftGroup, converter);
        new ResetButton(this.fTable, (Composite)leftGroup, converter);
        SWTUtils.createPlaceholder((Composite)leftGroup, (int)1);
        final Label infoLabel = SWTUtils.createLabel((Composite)leftGroup, (String)CVSUIMessages.ModeWizardSelectionPage_23, (int)3);
        this.fTable.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                boolean enabled = !ModeWizardSelectionPage.this.fTable.getSelection().isEmpty();
                leftGroup.setEnabled(enabled);
                infoLabel.setEnabled(enabled);
            }
        });
        Composite rightComposite = SWTUtils.createHVFillComposite((Composite)bottomSash, (int)0);
        ((GridLayout)rightComposite.getLayout()).marginLeft = horizontalSpace;
        ((GridLayout)rightComposite.getLayout()).marginTop = verticalSpace;
        Group rightGroup = SWTUtils.createHVFillGroup((Composite)rightComposite, (String)CVSUIMessages.ModeWizardSelectionPage_24, (int)1);
        this.fCommentArea = new CommitCommentArea();
        this.fCommentArea.createArea((Composite)rightGroup);
        mainSash.setWeights(new int[]{5, 2});
        bottomSash.setWeights(new int[]{3, 2});
        this.fTable.modelChanged(true);
        this.fTable.selectAll();
        filterBox.setFocus();
        this.setupListeners();
        this.setControl((Control)mainComposite);
        this.validatePage();
    }

    private void setupListeners() {
        this.fCommentArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() != null) {
                    ModeWizardSelectionPage.this.validatePage();
                }
            }
        });
    }

    protected ModeChangeTable getTable() {
        return this.fTable;
    }

    public List getChanges() {
        ArrayList<ModeWizard.ModeChange> changes = new ArrayList<ModeWizard.ModeChange>();
        for (ModeWizard.ModeChange change : this.fChanges) {
            if (!change.hasChanged()) continue;
            changes.add(change);
        }
        return changes;
    }

    public String getComment(Shell shell) {
        return this.fCommentArea.getCommentWithPrompt(shell);
    }

    private void validatePage() {
        IPreferenceStore store;
        String allowEmptyComment;
        if (this.fCommentArea.getComment(false).equals("") && (allowEmptyComment = (store = CVSUIPlugin.getPlugin().getPreferenceStore()).getString("pref_allow_empty_commit_comment")).equals("never")) {
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }

    private static final class ChangeCounterLabel
    implements Observer {
        private final Label fLabel;
        private final ModeChangeTable fTable;

        ChangeCounterLabel(Composite parent, ModeChangeTable table) {
            this.fTable = table;
            this.fTable.addObserver(this);
            this.fLabel = SWTUtils.createLabel((Composite)parent, null);
            this.fLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        }

        @Override
        public void update(Observable o, Object arg) {
            this.updateText(this.fTable.getNumberOfChanges());
        }

        private void updateText(int numberOfChanges) {
            this.fLabel.setText(NLS.bind((String)CVSUIMessages.ModeWizardSelectionPage_17, (Object[])new String[]{Integer.toString(numberOfChanges)}));
        }
    }

    private static final class Filter
    extends ViewerFilter {
        private boolean fFilterUnchanged = false;
        private StringMatcher fMatcher = new StringMatcher("*", true, false);

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            ModeWizard.ModeChange change = (ModeWizard.ModeChange)element;
            if (this.fFilterUnchanged && !change.hasChanged()) {
                return false;
            }
            return this.fMatcher.match(change.getFile().getName());
        }

        public void setPattern(String pattern) {
            if (!(pattern = pattern.trim()).endsWith("*")) {
                pattern = String.valueOf(pattern) + "*";
            }
            this.fMatcher = new StringMatcher(pattern, true, false);
        }

        public void filterUnchanged(boolean filter) {
            this.fFilterUnchanged = filter;
        }
    }

    private static final class FilterTextBox
    extends SelectionAdapter
    implements ModifyListener {
        private final ModeWizardSelectionPage fPage;
        private final Text fTextField;

        public FilterTextBox(ModeWizardSelectionPage page, Composite parent, PixelConverter converter) {
            this.fPage = page;
            this.fTextField = new Text(parent, 2052);
            this.fTextField.setLayoutData((Object)SWTUtils.createHFillGridData());
            int buttonWidth = converter.convertHorizontalDLUsToPixels(61);
            Button button = new Button(parent, 8);
            button.setText(CVSUIMessages.ModeWizardSelectionPage_15);
            button.setLayoutData((Object)SWTUtils.createGridData((int)buttonWidth, (int)-1, (int)4, (int)0x1000000, (boolean)false, (boolean)false));
            button.addSelectionListener((SelectionListener)this);
            this.fTextField.addModifyListener((ModifyListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            this.fTextField.setText("");
            this.fTextField.setFocus();
        }

        public void modifyText(ModifyEvent e) {
            ModeChangeTable table = this.fPage.getTable();
            table.getFilter().setPattern(this.fTextField.getText());
            table.modelChanged(false);
        }

        public void setFocus() {
            this.fTextField.setFocus();
        }
    }

    private static final class GuessButton
    extends SelectionAdapter
    implements Observer {
        private final ModeChangeTable fTable;
        private final Button fButton;

        public GuessButton(ModeChangeTable table, Composite parent, PixelConverter converter) {
            this.fTable = table;
            int buttonWidth = converter.convertHorizontalDLUsToPixels(61);
            this.fButton = new Button(parent, 0);
            this.fButton.setLayoutData((Object)SWTUtils.createGridData((int)buttonWidth, (int)-1, (int)4, (int)0x1000000, (boolean)false, (boolean)false));
            this.fButton.setText(CVSUIMessages.ModeWizardSelectionPage_10);
            this.fButton.setToolTipText(CVSUIMessages.ModeWizardSelectionPage_11);
            this.fButton.addSelectionListener((SelectionListener)this);
            this.fTable.addObserver(this);
        }

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection selection = this.fTable.getSelection();
            for (ModeWizard.ModeChange change : selection) {
                change.setNewMode(Command.KSubstOption.fromFile((IFile)change.getFile()));
            }
            this.fTable.modelChanged(true);
        }

        @Override
        public void update(Observable o, Object arg) {
            this.fButton.setEnabled(!this.fTable.getSelection().isEmpty());
        }
    }

    private static final class ModeChangeCellModifier
    implements ICellModifier {
        private final ModeChangeTable fTable;

        public ModeChangeCellModifier(ModeChangeTable table) {
            this.fTable = table;
        }

        public boolean canModify(Object element, String property) {
            return ModeWizardSelectionPage.PROPERTY_MODE.equals(property);
        }

        public Object getValue(Object element, String property) {
            if (ModeWizardSelectionPage.PROPERTY_MODE.equals(property)) {
                Command.KSubstOption mode = ((ModeWizard.ModeChange)element).getNewMode();
                int i = 0;
                while (i < MODES.length) {
                    if (MODES[i].equals((Object)mode)) {
                        return new Integer(i);
                    }
                    ++i;
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (ModeWizardSelectionPage.PROPERTY_MODE.equals(property)) {
                ((ModeWizard.ModeChange)element).setNewMode(MODES[(Integer)value]);
                this.fTable.modelChanged(true);
            }
        }
    }

    private static final class ModeChangeContentProvider
    implements IStructuredContentProvider {
        private ModeChangeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }
    }

    private static final class ModeChangeLabelProvider
    implements ITableLabelProvider {
        private final DecoratingLabelProvider fDecoratingLP;
        private final ModeChangeTable fTable;

        public ModeChangeLabelProvider(ModeChangeTable table) {
            this.fTable = table;
            this.fDecoratingLP = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
            this.fDecoratingLP.addListener((ILabelProviderListener)this.fTable);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.fDecoratingLP.getImage((Object)((ModeWizard.ModeChange)element).getFile());
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ModeWizard.ModeChange change = (ModeWizard.ModeChange)element;
            switch (columnIndex) {
                case 0: {
                    return String.valueOf(change.hasChanged() ? "* " : "") + change.getFile().getName();
                }
                case 1: {
                    return change.getNewMode().getLongDisplayText();
                }
                case 2: {
                    return change.getFile().getFullPath().toOSString();
                }
            }
            throw new IllegalArgumentException();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
            this.fDecoratingLP.removeListener((ILabelProviderListener)this.fTable);
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static final class ModeChangeTable
    extends Observable
    implements ISelectionChangedListener,
    ILabelProviderListener {
        private final List fChanges;
        private final TableViewer fViewer;
        private final Filter fFilter;
        private int fNumberOfChanges;

        public ModeChangeTable(Composite composite, PixelConverter converter, List changes) {
            this.fChanges = changes;
            this.fNumberOfChanges = 0;
            Table table = new Table(composite, 68098);
            table.setLayoutData((Object)SWTUtils.createHVFillGridData());
            table.setLinesVisible(false);
            table.setHeaderVisible(true);
            TableColumn fileColumn = new TableColumn(table, 0, 0);
            fileColumn.setWidth(converter.convertWidthInCharsToPixels(50));
            fileColumn.setText(CVSUIMessages.ModeWizardSelectionPage_2);
            table.setSortColumn(fileColumn);
            table.setSortDirection(1024);
            TableColumn newModeColumn = new TableColumn(table, 0, 1);
            newModeColumn.setWidth(converter.convertWidthInCharsToPixels(COLUMN_MIN_WIDTH_IN_CHARS + 6));
            newModeColumn.setText(CVSUIMessages.ModeWizardSelectionPage_3);
            TableColumn pathColumn = new TableColumn(table, 0, 2);
            pathColumn.setWidth(converter.convertWidthInCharsToPixels(50));
            pathColumn.setText(CVSUIMessages.ModeWizardSelectionPage_4);
            this.fViewer = new TableViewer(table);
            this.fViewer.setContentProvider((IContentProvider)new ModeChangeContentProvider());
            this.fViewer.setLabelProvider((IBaseLabelProvider)new ModeChangeLabelProvider(this));
            this.fViewer.getControl().setLayoutData((Object)SWTUtils.createHVFillGridData());
            ComboBoxCellEditor newModeEditor = new ComboBoxCellEditor((Composite)table, COMBO_TEXT, 8);
            CellEditor[] cellEditorArray = new CellEditor[3];
            cellEditorArray[1] = newModeEditor;
            this.fViewer.setCellEditors(cellEditorArray);
            this.fViewer.setColumnProperties(new String[]{ModeWizardSelectionPage.PROPERTY_FILE, ModeWizardSelectionPage.PROPERTY_MODE, ModeWizardSelectionPage.PROPERTY_CHANGED});
            this.fViewer.setCellModifier((ICellModifier)new ModeChangeCellModifier(this));
            this.fFilter = new Filter();
            this.fViewer.addFilter((ViewerFilter)this.fFilter);
            this.fViewer.setComparator((ViewerComparator)new TableComparator(this.fViewer, fileColumn, newModeColumn, pathColumn));
            this.fViewer.setInput((Object)this.fChanges);
            this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            fileColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                }
            });
            this.fViewer.refresh();
        }

        public TableViewer getViewer() {
            return this.fViewer;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.setChanged();
            this.notifyObservers(this.fViewer.getSelection());
        }

        public void modelChanged(boolean updateLabels) {
            this.fViewer.refresh(updateLabels);
            this.fNumberOfChanges = 0;
            for (ModeWizard.ModeChange change : this.fChanges) {
                if (!change.hasChanged()) continue;
                ++this.fNumberOfChanges;
            }
            this.setChanged();
            this.notifyObservers();
        }

        public Filter getFilter() {
            return this.fFilter;
        }

        public IStructuredSelection getSelection() {
            return (IStructuredSelection)this.fViewer.getSelection();
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            this.fViewer.refresh();
        }

        public void selectAll() {
            this.fViewer.setSelection((ISelection)new StructuredSelection(this.fChanges));
            this.fViewer.getControl().setFocus();
        }

        public void selectNone() {
            this.fViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            this.fViewer.getControl().setFocus();
        }

        public int getNumberOfChanges() {
            return this.fNumberOfChanges;
        }
    }

    private static final class ModeCombo
    extends SelectionAdapter
    implements Observer {
        private final Combo fCombo;
        private final ModeChangeTable fTable;

        public ModeCombo(ModeChangeTable table, Composite parent) {
            this.fTable = table;
            this.fCombo = new Combo(parent, 8);
            this.fCombo.setLayoutData((Object)SWTUtils.createHFillGridData());
            this.fCombo.setItems(COMBO_TEXT);
            this.fCombo.addSelectionListener((SelectionListener)this);
            this.fTable.addObserver(this);
        }

        public void widgetSelected(SelectionEvent e) {
            Command.KSubstOption mode = MODES[this.fCombo.getSelectionIndex()];
            IStructuredSelection selection = this.fTable.getSelection();
            for (ModeWizard.ModeChange change : selection) {
                change.setNewMode(mode);
            }
            this.fTable.modelChanged(true);
        }

        @Override
        public void update(Observable o, Object arg) {
            IStructuredSelection selection = (IStructuredSelection)this.fTable.getViewer().getSelection();
            if (selection.isEmpty()) {
                this.fCombo.deselectAll();
                this.fCombo.setEnabled(false);
            } else {
                this.fCombo.setEnabled(true);
                Command.KSubstOption option = ((ModeWizard.ModeChange)selection.getFirstElement()).getNewMode();
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    if (option == ((ModeWizard.ModeChange)iter.next()).getNewMode()) continue;
                    this.fCombo.deselectAll();
                    return;
                }
                this.fCombo.setText(option.getLongDisplayText());
            }
        }
    }

    private static final class ResetButton
    extends SelectionAdapter
    implements Observer {
        private final ModeChangeTable fTable;
        private final Button fButton;

        public ResetButton(ModeChangeTable table, Composite parent, PixelConverter converter) {
            int buttonWidth = converter.convertHorizontalDLUsToPixels(61);
            this.fTable = table;
            this.fButton = new Button(parent, 0);
            this.fButton.setLayoutData((Object)SWTUtils.createGridData((int)buttonWidth, (int)-1, (int)4, (int)0x1000000, (boolean)false, (boolean)false));
            this.fButton.setText(CVSUIMessages.ModeWizardSelectionPage_8);
            this.fButton.setToolTipText(CVSUIMessages.ModeWizardSelectionPage_9);
            this.fButton.addSelectionListener((SelectionListener)this);
            this.fTable.addObserver(this);
        }

        public void widgetSelected(SelectionEvent e) {
            this.fButton.setEnabled(false);
            IStructuredSelection selection = this.fTable.getSelection();
            for (ModeWizard.ModeChange change : selection) {
                change.setNewMode(change.getMode());
            }
            this.fTable.modelChanged(true);
        }

        @Override
        public void update(Observable o, Object arg) {
            IStructuredSelection selection = this.fTable.getSelection();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                if (!((ModeWizard.ModeChange)iter.next()).hasChanged()) continue;
                this.fButton.setEnabled(true);
                return;
            }
            this.fButton.setEnabled(false);
        }
    }

    private static final class SelectAllButton
    extends SelectionAdapter {
        private final ModeWizardSelectionPage fPage;
        private final Button fButton;

        public SelectAllButton(ModeWizardSelectionPage page, Composite parent, PixelConverter converter) {
            this.fPage = page;
            int buttonWidth = converter.convertHorizontalDLUsToPixels(61);
            this.fButton = new Button(parent, 0);
            this.fButton.setLayoutData((Object)SWTUtils.createGridData((int)buttonWidth, (int)-1, (int)4, (int)0x1000000, (boolean)false, (boolean)false));
            this.fButton.setText(CVSUIMessages.ModeWizardSelectionPage_12);
            this.fButton.addSelectionListener((SelectionListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            this.fPage.getTable().selectAll();
        }
    }

    private static final class SelectNoneButton
    extends SelectionAdapter {
        private final ModeWizardSelectionPage fPage;
        private final Button fButton;

        public SelectNoneButton(ModeWizardSelectionPage page, Composite parent, PixelConverter converter) {
            this.fPage = page;
            int buttonWidth = converter.convertHorizontalDLUsToPixels(61);
            this.fButton = new Button(parent, 0);
            this.fButton.setLayoutData((Object)SWTUtils.createGridData((int)buttonWidth, (int)-1, (int)4, (int)0x1000000, (boolean)false, (boolean)false));
            this.fButton.setText(CVSUIMessages.ModeWizardSelectionPage_13);
            this.fButton.addSelectionListener((SelectionListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            this.fPage.getTable().selectNone();
        }
    }

    private static final class SelectionCounterLabel
    implements Observer {
        private final Label fLabel;
        private final ModeChangeTable fTable;

        public SelectionCounterLabel(Composite parent, ModeChangeTable table) {
            this.fTable = table;
            this.fTable.addObserver(this);
            this.fLabel = new Label(parent, 131136);
            this.fLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        }

        @Override
        public void update(Observable o, Object arg) {
            this.updateText(this.fTable.getSelection().size());
        }

        private void updateText(int selected) {
            this.fLabel.setText(NLS.bind((String)CVSUIMessages.ModeWizardSelectionPage_25, (Object[])new String[]{Integer.toString(selected)}));
        }
    }

    private static final class ShowChangesOnlyCheckbox
    extends SelectionAdapter {
        private final ModeWizardSelectionPage fPage;
        private final Button fCheck;

        public ShowChangesOnlyCheckbox(ModeWizardSelectionPage page, Composite parent) {
            this.fPage = page;
            this.fCheck = new Button(parent, 32);
            this.fCheck.setText(CVSUIMessages.ModeWizardSelectionPage_14);
            this.fCheck.setLayoutData((Object)SWTUtils.createHFillGridData());
            this.fCheck.setSelection(false);
            this.fCheck.addSelectionListener((SelectionListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            ModeChangeTable table = this.fPage.getTable();
            table.getFilter().filterUnchanged(this.fCheck.getSelection());
            table.modelChanged(true);
        }
    }

    private static final class TableComparator
    extends ViewerComparator
    implements SelectionListener {
        private final Collator fCollator = Collator.getInstance();
        private final TableViewer fViewer;
        private final TableColumn fFile;
        private final TableColumn fMode;
        private final TableColumn fPath;
        private int fIndex;
        private boolean fAscending;

        public TableComparator(TableViewer viewer, TableColumn fileColumn, TableColumn modeColumn, TableColumn pathColumn) {
            this.fViewer = viewer;
            this.fFile = fileColumn;
            this.fMode = modeColumn;
            this.fPath = pathColumn;
            this.fIndex = 0;
            this.fViewer.getTable().setSortColumn(this.fFile);
            this.fViewer.getTable().setSortDirection(1024);
            this.fAscending = true;
            fileColumn.addSelectionListener((SelectionListener)this);
            modeColumn.addSelectionListener((SelectionListener)this);
            pathColumn.addSelectionListener((SelectionListener)this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String s2;
            String s1;
            ModeWizard.ModeChange mc1 = (ModeWizard.ModeChange)e1;
            ModeWizard.ModeChange mc2 = (ModeWizard.ModeChange)e2;
            switch (this.fIndex) {
                case 0: {
                    s1 = mc1.getFile().getName();
                    s2 = mc2.getFile().getName();
                    break;
                }
                case 1: {
                    s1 = mc1.getNewMode().getLongDisplayText();
                    s2 = mc2.getNewMode().getLongDisplayText();
                    break;
                }
                case 2: {
                    s1 = mc1.getFile().getFullPath().toOSString();
                    s2 = mc2.getFile().getFullPath().toOSString();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            int compare = this.fCollator.compare(s1, s2);
            return this.fAscending ? compare : -compare;
        }

        public void widgetSelected(SelectionEvent e) {
            int index = this.columnToIndex(e.widget);
            if (index == this.fIndex) {
                this.fIndex = index;
                this.fAscending = !this.fAscending;
                this.fViewer.getTable().setSortDirection(this.fAscending ? 1024 : 128);
            } else {
                this.fIndex = index;
                TableColumn tableCol = null;
                switch (this.fIndex) {
                    case 0: {
                        tableCol = this.fFile;
                        break;
                    }
                    case 1: {
                        tableCol = this.fMode;
                        break;
                    }
                    case 2: {
                        tableCol = this.fPath;
                    }
                }
                this.fViewer.getTable().setSortColumn(tableCol);
                this.fViewer.getTable().setSortDirection(this.fAscending ? 1024 : 128);
            }
            this.fViewer.refresh();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private int columnToIndex(Object column) {
            if (column == this.fFile) {
                return 0;
            }
            if (column == this.fMode) {
                return 1;
            }
            if (column == this.fPath) {
                return 2;
            }
            throw new IllegalArgumentException();
        }
    }
}

