/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model;

import java.util.Map;
import java.util.Objects;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.core.model.TmfCommonXAxisModel;

public final class TmfCommonXAxisResponseFactory {
    private TmfCommonXAxisResponseFactory() {
    }

    public static TmfModelResponse<ITmfCommonXAxisModel> create(String title, long[] xValues, Map<String, IYModel> yModels, boolean isComplete) {
        TmfCommonXAxisModel model = new TmfCommonXAxisModel(title, xValues, yModels);
        if (isComplete) {
            return new TmfModelResponse<ITmfCommonXAxisModel>(model, ITmfResponse.Status.COMPLETED, Objects.requireNonNull(CommonStatusMessage.COMPLETED));
        }
        return new TmfModelResponse<ITmfCommonXAxisModel>(model, ITmfResponse.Status.RUNNING, Objects.requireNonNull(CommonStatusMessage.RUNNING));
    }

    public static TmfModelResponse<ITmfCommonXAxisModel> createFailedResponse(String message) {
        return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, message);
    }

    public static TmfModelResponse<ITmfCommonXAxisModel> createCancelledResponse(String message) {
        return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, message);
    }
}

