/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.event;

import com.google.common.base.Preconditions;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IMatchUpdateListener;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.MatchUpdateAdapter;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.transformation.evm.api.event.EventHandler;
import org.eclipse.viatra.transformation.evm.api.event.adapter.EventSourceAdapter;
import org.eclipse.viatra.transformation.evm.notification.IAttributeMonitorListener;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDEventTypeEnum;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEvent;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEventRealm;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEventSourceSpecification;

public class ViatraQueryEventSource<Match extends IPatternMatch>
extends EventSourceAdapter<Match> {
    private final ViatraQueryMatcher<Match> matcher;
    private IAttributeMonitorListener<Match> attributeMonitorListener;
    private IMatchUpdateListener<Match> matchUpdateListener;

    protected ViatraQueryEventSource(ViatraQueryEventRealm realm, ViatraQueryEventSourceSpecification<Match> sourceDefinition) throws ViatraQueryException {
        super(sourceDefinition, realm);
        ViatraQueryMatcher<Match> _matcher = sourceDefinition.getMatcher(realm.getEngine());
        this.matcher = _matcher;
    }

    public ViatraQueryMatcher<Match> getMatcher() {
        return this.matcher;
    }

    @Override
    protected void beforeHandlerAdded(EventHandler<Match> handler, boolean handlersEmpty) {
        this.resendEventsForExistingMatches(handler);
        if (handlersEmpty) {
            ((AdvancedViatraQueryEngine)this.matcher.getEngine()).addMatchUpdateListener(this.matcher, this.matchUpdateListener, false);
        }
    }

    @Override
    protected void afterHandlerRemoved(EventHandler<Match> handler, boolean handlersEmpty) {
        if (handlersEmpty) {
            ((AdvancedViatraQueryEngine)this.matcher.getEngine()).removeMatchUpdateListener(this.matcher, this.matchUpdateListener);
        }
    }

    @Override
    protected void prepareSource() {
        this.attributeMonitorListener = this.prepareAttributeMonitorListener();
        this.matchUpdateListener = this.prepareMatchUpdateListener();
    }

    protected IAttributeMonitorListener<Match> prepareAttributeMonitorListener() {
        return new IAttributeMonitorListener<Match>(){

            @Override
            public void notifyUpdate(Match atom) {
                ViatraQueryEventSource.this.notifyHandlers(new ViatraQueryEvent(CRUDEventTypeEnum.UPDATED, atom));
            }
        };
    }

    protected IMatchUpdateListener<Match> prepareMatchUpdateListener() {
        IMatchProcessor matchAppearProcessor = new IMatchProcessor<Match>(){

            public void process(Match match) {
                ViatraQueryEventSource.this.notifyHandlers(new ViatraQueryEvent(CRUDEventTypeEnum.CREATED, match));
            }
        };
        IMatchProcessor matchDisppearProcessor = new IMatchProcessor<Match>(){

            public void process(Match match) {
                ViatraQueryEventSource.this.notifyHandlers(new ViatraQueryEvent(CRUDEventTypeEnum.DELETED, match));
            }
        };
        return new MatchUpdateAdapter(matchAppearProcessor, matchDisppearProcessor);
    }

    private void resendEventsForExistingMatches(final EventHandler<Match> handler) {
        this.matcher.forEachMatch(new IMatchProcessor<Match>(){

            public void process(Match match) {
                handler.handleEvent(new ViatraQueryEvent(CRUDEventTypeEnum.CREATED, match));
            }
        });
    }

    @Override
    public void dispose() {
        ((AdvancedViatraQueryEngine)this.matcher.getEngine()).removeMatchUpdateListener(this.matcher, this.matchUpdateListener);
        super.dispose();
    }

    public IAttributeMonitorListener<Match> getAttributeMonitorListener() {
        Preconditions.checkState((this.attributeMonitorListener != null ? 1 : 0) != 0, (Object)"Event source not prepared yet!");
        return this.attributeMonitorListener;
    }
}

