/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.util.WSDLUtil;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;

public class BP2112
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean rpcLiteralFound = false;
    private ErrorList errors = new ErrorList();

    public BP2112(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public void visit(SOAPBinding binding, Object parent, WSDLTraversalContext ctx) {
        String style = binding.getStyle() == null ? "document" : binding.getStyle();
        ctx.addParameter("bindingStyle", style);
    }

    public void visit(BindingOperation op, Object parent, WSDLTraversalContext ctx) {
        ctx.removeParameter("operationStyle");
    }

    public void visit(SOAPOperation operation, Object parent, WSDLTraversalContext ctx) {
        ctx.addParameter("operationStyle", operation.getStyle());
    }

    public void visit(SOAPBody body, Object parent, WSDLTraversalContext ctx) {
        String opStyle = (String)ctx.getParameter("operationStyle");
        String bStyle = (String)ctx.getParameter("bindingStyle");
        if (opStyle == null && !"rpc".equals(bStyle) || opStyle != null && !"rpc".equals(opStyle)) {
            ctx.cancelBindingOperationProcessing();
            return;
        }
        if ("literal".equals(body.getUse())) {
            Message m;
            this.rpcLiteralFound = true;
            Operation op = ctx.getBindingOperation().getOperation();
            if (op == null || parent instanceof BindingInput && op.getInput() == null || parent instanceof BindingOutput && op.getOutput() == null) {
                return;
            }
            Message message = m = parent instanceof BindingInput ? op.getInput().getMessage() : op.getOutput().getMessage();
            if (m == null) {
                return;
            }
            List parts = WSDLUtil.getParts(op, m, body, "rpc");
            if (parts == null) {
                return;
            }
            Iterator it = parts.iterator();
            while (it.hasNext()) {
                Part part = (Part)it.next();
                if (part.getElementName() == null) continue;
                this.errors.add(part.getName());
            }
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitSOAPBinding(true);
        traversal.visitBindingOperation(true);
        traversal.visitSOAPOperation(true);
        traversal.visitSOAPBody(true);
        traversal.ignoreReferences();
        traversal.ignoreImport();
        traversal.traverse((Binding)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = !this.rpcLiteralFound ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

