/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.base.Predicate;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.ReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinderExtension1;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceAcceptor;
import org.eclipse.xtext.ui.editor.findrefs.TargetURIConverter;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

@Deprecated
public class DefaultReferenceFinder
extends ReferenceFinder
implements IReferenceFinder,
IReferenceFinderExtension1 {
    private IResourceDescriptions indexData;
    @Inject
    private TargetURIConverter converter;
    private static final int MONITOR_FIND_LOCAL_CHUNK_SIZE = 10;

    @Inject
    public DefaultReferenceFinder(IResourceDescriptions indexData, IResourceServiceProvider.Registry serviceProviderRegistry) {
        this(indexData, serviceProviderRegistry, new TargetURIConverter());
    }

    public DefaultReferenceFinder(IResourceDescriptions indexData, IResourceServiceProvider.Registry serviceProviderRegistry, TargetURIConverter converter) {
        super(serviceProviderRegistry);
        this.indexData = indexData;
        this.converter = converter;
    }

    protected IResourceDescriptions getIndexData() {
        return this.indexData;
    }

    protected MyReferenceAcceptor toAcceptor(IAcceptor<IReferenceDescription> acceptor) {
        if (acceptor instanceof MyReferenceAcceptor) {
            return (MyReferenceAcceptor)acceptor;
        }
        return new MyReferenceAcceptor(acceptor, this.getServiceProviderRegistry());
    }

    public void findReferences(TargetURIs targetURIs, IResourceDescription resourceDescription, IReferenceFinder.IResourceAccess resourceAccess, IReferenceFinder.Acceptor acceptor, IProgressMonitor monitor) {
        this.findReferences(targetURIs.asSet(), resourceDescription, (IAcceptor<IReferenceDescription>)((IAcceptor)acceptor), monitor, (IReferenceFinder.ILocalResourceAccess)resourceAccess);
    }

    public void findReferences(Predicate<URI> targetURIs, Resource resource, IReferenceFinder.Acceptor acceptor, IProgressMonitor monitor) {
        this.findLocalReferencesInResource(targetURIs, resource, (IAcceptor<IReferenceDescription>)((IAcceptor)acceptor));
    }

    protected org.eclipse.xtext.findReferences.IReferenceFinder getLanguageSpecificReferenceFinder(URI candidate) {
        return this;
    }

    @Override
    public void findReferences(Iterable<URI> targetURIs, Iterable<URI> sourceResourceURIs, IReferenceFinder.ILocalResourceAccess localResourceAccess, IAcceptor<IReferenceDescription> referenceAcceptor, IProgressMonitor monitor) {
        TargetURIs converted = this.converter.fromIterable(targetURIs);
        HashSet sourceResourcesAsSet = Sets.newHashSet(sourceResourceURIs);
        super.findReferences(converted, (Set)sourceResourcesAsSet, (IReferenceFinder.IResourceAccess)localResourceAccess, this.indexData, (IReferenceFinder.Acceptor)this.toAcceptor(referenceAcceptor), monitor);
        if (localResourceAccess != null && !converted.isEmpty() && this.getClass() != DefaultReferenceFinder.class) {
            this.findLocalReferences((Iterable<URI>)converted, localResourceAccess, referenceAcceptor, monitor);
        }
    }

    @Override
    public void findAllReferences(Iterable<URI> targetURIs, IReferenceFinder.ILocalResourceAccess localResourceAccess, IAcceptor<IReferenceDescription> referenceAcceptor, IProgressMonitor monitor) {
        TargetURIs converted = this.converter.fromIterable(targetURIs);
        if (!converted.isEmpty()) {
            this.findAllIndexedReferences(referenceAcceptor, SubMonitor.convert((IProgressMonitor)monitor, (int)1), converted.asSet(), localResourceAccess);
            if (localResourceAccess != null && !converted.isEmpty() && this.getClass() != DefaultReferenceFinder.class) {
                this.findLocalReferences((Iterable<URI>)converted, localResourceAccess, referenceAcceptor, monitor);
            }
        }
    }

    @Deprecated
    protected void findAllIndexedReferences(IAcceptor<IReferenceDescription> referenceAcceptor, SubMonitor subMonitor, Set<URI> targetURIsAsSet) {
        this.findAllIndexedReferences(referenceAcceptor, subMonitor, targetURIsAsSet, null);
    }

    protected void findAllIndexedReferences(IAcceptor<IReferenceDescription> referenceAcceptor, SubMonitor subMonitor, Set<URI> targetURIsAsSet, IReferenceFinder.ILocalResourceAccess localResourceAccess) {
        TargetURIs targetURIs = this.converter.fromIterable(targetURIsAsSet);
        if (!targetURIs.isEmpty()) {
            subMonitor.setWorkRemaining(Iterables.size((Iterable)this.indexData.getAllResourceDescriptions()) / 100 + 1);
            int i = 0;
            SubMonitor useMe = subMonitor.newChild(1);
            for (IResourceDescription resourceDescription : this.indexData.getAllResourceDescriptions()) {
                IResourceServiceProvider serviceProvider = this.getServiceProviderRegistry().getResourceServiceProvider(resourceDescription.getURI());
                if (serviceProvider != null) {
                    org.eclipse.xtext.findReferences.IReferenceFinder referenceFinder = (org.eclipse.xtext.findReferences.IReferenceFinder)serviceProvider.get(org.eclipse.xtext.findReferences.IReferenceFinder.class);
                    if (referenceFinder instanceof IReferenceFinderExtension1) {
                        IReferenceFinderExtension1 extension1 = (IReferenceFinderExtension1)referenceFinder;
                        extension1.findReferences(targetURIsAsSet, resourceDescription, referenceAcceptor, (IProgressMonitor)useMe, localResourceAccess);
                    } else {
                        this.findReferences(targetURIsAsSet, resourceDescription, referenceAcceptor, (IProgressMonitor)useMe, localResourceAccess);
                    }
                }
                if (++i % 100 != 0) continue;
                useMe = subMonitor.newChild(1);
            }
        }
    }

    protected void findLocalReferences(Iterable<URI> localTargets, IReferenceFinder.ILocalResourceAccess localResourceAccess, final IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        final TargetURIs targetURIs = this.converter.fromIterable(localTargets);
        Collection resourceURIs = targetURIs.getTargetResourceURIs();
        final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(resourceURIs.size() / 10 + 1));
        int i = 0;
        for (final URI resourceURI : resourceURIs) {
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            localResourceAccess.readOnly(resourceURI, (IUnitOfWork)new IUnitOfWork.Void<ResourceSet>(){

                public void process(ResourceSet resourceSet) throws Exception {
                    Resource resource = resourceSet.getResource(resourceURI, true);
                    DefaultReferenceFinder.super.findReferences((Predicate)targetURIs, resource, (IReferenceFinder.Acceptor)DefaultReferenceFinder.this.toAcceptor((IAcceptor<IReferenceDescription>)acceptor), (IProgressMonitor)subMonitor);
                }
            });
            if (++i % 10 != 0) continue;
            subMonitor.worked(1);
        }
    }

    protected void findLocalReferencesInResource(Predicate<URI> targetURIs, Resource resource, IAcceptor<IReferenceDescription> acceptor) {
        Map<EObject, URI> exportedElementsMap = this.createExportedElementsMap(resource);
        for (EObject content : resource.getContents()) {
            this.findLocalReferencesFromElement(targetURIs, content, resource, acceptor, null, exportedElementsMap);
        }
    }

    protected void findLocalReferencesFromElement(Predicate<URI> targetURIs, EObject sourceCandidate, Resource localResource, IAcceptor<IReferenceDescription> acceptor, URI currentExportedContainerURI, Map<EObject, URI> exportedElementsMap) {
        super.findLocalReferencesFromElement(targetURIs, sourceCandidate, localResource, (IReferenceFinder.Acceptor)this.toAcceptor(acceptor));
    }

    @Deprecated
    protected Map<EObject, URI> createExportedElementsMap(final Resource resource) {
        return new ForwardingMap<EObject, URI>(){
            private Map<EObject, URI> delegate;

            protected Map<EObject, URI> delegate() {
                if (this.delegate != null) {
                    return this.delegate;
                }
                URI uri = EcoreUtil2.getPlatformResourceOrNormalizedURI((Resource)resource);
                IResourceServiceProvider resourceServiceProvider = DefaultReferenceFinder.this.getServiceProviderRegistry().getResourceServiceProvider(uri);
                if (resourceServiceProvider == null) {
                    this.delegate = Collections.emptyMap();
                    return this.delegate;
                }
                IResourceDescription.Manager resourceDescriptionManager = resourceServiceProvider.getResourceDescriptionManager();
                if (resourceDescriptionManager == null) {
                    this.delegate = Collections.emptyMap();
                    return this.delegate;
                }
                IResourceDescription resourceDescription = resourceDescriptionManager.getResourceDescription(resource);
                IdentityHashMap exportedElementMap = Maps.newIdentityHashMap();
                if (resourceDescription != null) {
                    for (IEObjectDescription exportedEObjectDescription : resourceDescription.getExportedObjects()) {
                        EObject eObject = resource.getEObject(exportedEObjectDescription.getEObjectURI().fragment());
                        if (eObject == null) continue;
                        exportedElementMap.put(eObject, exportedEObjectDescription.getEObjectURI());
                    }
                }
                this.delegate = exportedElementMap;
                return this.delegate;
            }
        };
    }

    @Deprecated
    protected URI findClosestExportedContainerURI(EObject element, Map<EObject, URI> exportedElementsMap) {
        EObject current = element;
        while (current != null) {
            URI uri = exportedElementsMap.get(current);
            if (uri != null) {
                return uri;
            }
            current = current.eContainer();
        }
        return null;
    }

    @Deprecated
    protected void findIndexedReferences(Set<URI> targetURIs, IResourceDescription resourceDescription, IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor) {
        this.findReferences(targetURIs, resourceDescription, acceptor, monitor, null);
    }

    @Override
    public void findReferences(Set<URI> targetURIs, IResourceDescription resourceDescription, IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor, IReferenceFinder.ILocalResourceAccess localResourceAccess) {
        super.findReferences(this.converter.fromIterable(targetURIs), resourceDescription, (IReferenceFinder.IResourceAccess)localResourceAccess, (IReferenceFinder.Acceptor)this.toAcceptor(acceptor), monitor);
    }

    protected static class MyReferenceAcceptor
    extends ReferenceAcceptor
    implements IAcceptor<IReferenceDescription> {
        protected MyReferenceAcceptor(IAcceptor<IReferenceDescription> delegate, IResourceServiceProvider.Registry serviceProviderRegistry) {
            super(delegate, serviceProviderRegistry);
        }
    }
}

