/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDebugElementStatus;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.IEnableDisableTarget;
import org.eclipse.cdt.debug.internal.ui.CDebugUIMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpoints.CBreakpointPropertyDialogAction;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IUnassociatedEditorStrategy;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.registry.SystemEditorOrTextEditorStrategy;
import org.eclipse.ui.internal.ide.registry.UnassociatedEditorStrategyRegistry;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class CDebugUIUtils {
    public static IRegion findWord(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public static ICStackFrame getCurrentStackFrame() {
        IAdaptable context = DebugUITools.getDebugContext();
        return context != null ? (ICStackFrame)context.getAdapter(ICStackFrame.class) : null;
    }

    public static String getValueText(IValue value) {
        StringBuilder label = new StringBuilder();
        if (value instanceof ICDebugElementStatus && !((ICDebugElementStatus)value).isOK()) {
            label.append(MessageFormat.format((String)CDebugUIMessages.getString("CDTDebugModelPresentation.4"), (Object[])new String[]{((ICDebugElementStatus)value).getMessage()}));
        } else if (value instanceof ICValue) {
            ICType type = null;
            try {
                type = ((ICValue)value).getType();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            try {
                String valueString = value.getValueString();
                if (valueString != null) {
                    valueString = valueString.trim();
                    if (type != null && type.isCharacter()) {
                        if (valueString.length() == 0) {
                            valueString = ".";
                        }
                        label.append(valueString);
                    } else if (valueString.length() > 0) {
                        label.append(valueString);
                    }
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return label.toString();
    }

    public static String getVariableTypeName(ICType type) {
        StringBuilder result = new StringBuilder();
        if (type != null) {
            int index;
            String typeName = type.getName();
            if (typeName != null) {
                typeName = typeName.trim();
            }
            if (type.isArray() && typeName != null && (index = typeName.indexOf(91)) != -1) {
                typeName = typeName.substring(0, index).trim();
            }
            if (typeName != null && typeName.length() > 0) {
                result.append(typeName);
                if (type.isArray()) {
                    int[] dims = type.getArrayDimensions();
                    int i = 0;
                    while (i < dims.length) {
                        result.append('[');
                        result.append(dims[i]);
                        result.append(']');
                        ++i;
                    }
                }
            }
        }
        return result.toString();
    }

    public static String getVariableName(IVariable variable) throws DebugException {
        return CDebugUIUtils.decorateText(variable, variable.getName());
    }

    public static String getEditorFilePath(IEditorInput input) throws CoreException {
        IPath uriPath;
        if (input instanceof IFileEditorInput) {
            IPath uriPath2;
            IPath location = ((IFileEditorInput)input).getFile().getLocation();
            if (location != null) {
                return location.toOSString();
            }
            URI locationURI = ((IFileEditorInput)input).getFile().getLocationURI();
            if (locationURI != null && (uriPath2 = URIUtil.toPath((URI)locationURI)) != null) {
                return uriPath2.toOSString();
            }
            return "";
        }
        if (input instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)input).getStorage().getFullPath().toOSString();
        }
        if (input instanceof IPathEditorInput) {
            return ((IPathEditorInput)input).getPath().toOSString();
        }
        if (input instanceof IURIEditorInput && (uriPath = URIUtil.toPath((URI)((IURIEditorInput)input).getURI())) != null) {
            return uriPath.toOSString();
        }
        return "";
    }

    public static String decorateText(Object element, String text) {
        IEnableDisableTarget target;
        if (text == null) {
            return null;
        }
        StringBuilder baseText = new StringBuilder(text);
        if (element instanceof ICDebugElementStatus && !((ICDebugElementStatus)element).isOK()) {
            baseText.append(MessageFormat.format((String)" <{0}>", (Object[])new Object[]{((ICDebugElementStatus)element).getMessage()}));
        }
        if (element instanceof IAdaptable && (target = (IEnableDisableTarget)((IAdaptable)element).getAdapter(IEnableDisableTarget.class)) != null && !target.isEnabled()) {
            baseText.append(' ');
            baseText.append(CDebugUIMessages.getString("CDTDebugModelPresentation.25"));
        }
        return baseText.toString();
    }

    public static void openError(final String title, final String message, final Exception e) {
        UIJob uiJob = new UIJob("open error"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                String detail = "";
                if (e != null) {
                    detail = e.getMessage();
                }
                Shell shell = CDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)title, (String)(String.valueOf(message) + "\n" + detail));
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.schedule();
    }

    public static IBreakpoint getBreakpointFromEditor(ITextEditor editor, IVerticalRulerInfo info) {
        IAnnotationModel annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof SimpleMarkerAnnotation)) continue;
                SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)object;
                IMarker marker = markerAnnotation.getMarker();
                try {
                    IBreakpoint breakpoint;
                    Position position;
                    int line;
                    if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER) || (line = document.getLineOfOffset((position = annotationModel.getPosition((Annotation)markerAnnotation)).getOffset())) != info.getLineOfLastMouseButtonActivity() || (breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) == null) continue;
                    return breakpoint;
                }
                catch (CoreException coreException) {
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static void editBreakpointProperties(IWorkbenchPart part, final ICBreakpoint bp) {
        final ISelection debugContext = DebugUITools.getDebugContextForPart((IWorkbenchPart)part);
        CBreakpointPropertyDialogAction propertiesAction = new CBreakpointPropertyDialogAction((IShellProvider)part.getSite(), new ISelectionProvider(){

            public ISelection getSelection() {
                return new StructuredSelection((Object)bp);
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        }, new IDebugContextProvider(){

            public ISelection getActiveContext() {
                return debugContext;
            }

            public void addDebugContextListener(IDebugContextListener listener) {
            }

            public void removeDebugContextListener(IDebugContextListener listener) {
            }

            public IWorkbenchPart getPart() {
                return null;
            }
        });
        propertiesAction.run();
        propertiesAction.dispose();
    }

    public static final String formatKeyBindingString(int modifierKeys, String keyOrClick) {
        return String.valueOf(KeyStroke.getInstance((int)modifierKeys, (int)0).format()) + keyOrClick;
    }

    @Deprecated
    public static String getEditorId(IFileStore fileStore, boolean allowInteractive) throws PartInitException {
        String name = fileStore.fetchInfo().getName();
        if (name == null) {
            throw new IllegalArgumentException();
        }
        IContentType contentType = null;
        try (InputStream is2 = null;){
            is2 = fileStore.openInputStream(0, null);
            contentType = Platform.getContentTypeManager().findContentTypeFor(is2, name);
        }
        catch (CoreException is2) {
        }
        catch (IOException is2) {
            // empty catch block
        }
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor defaultEditor = editorReg.getDefaultEditor(name, contentType);
        defaultEditor = IDE.overrideDefaultEditorAssociation((IEditorInput)new FileStoreEditorInput(fileStore), (IContentType)contentType, (IEditorDescriptor)defaultEditor);
        return CDebugUIUtils.getEditorDescriptor(name, editorReg, defaultEditor, allowInteractive).getId();
    }

    @Deprecated
    private static IEditorDescriptor getEditorDescriptor(String name, IEditorRegistry editorReg, IEditorDescriptor defaultDescriptor, boolean allowInteractive) throws PartInitException {
        IEditorDescriptor editorDesc;
        if (defaultDescriptor != null) {
            return defaultDescriptor;
        }
        IUnassociatedEditorStrategy strategy = CDebugUIUtils.getUnassociatedEditorStrategy(allowInteractive);
        try {
            editorDesc = strategy.getEditorDescriptor(name, editorReg);
        }
        catch (CoreException e) {
            throw new PartInitException(IDEWorkbenchMessages.IDE_noFileEditorFound, (Throwable)e);
        }
        if (editorDesc == null) {
            throw new PartInitException(IDEWorkbenchMessages.IDE_noFileEditorFound);
        }
        return editorDesc;
    }

    private static IUnassociatedEditorStrategy getUnassociatedEditorStrategy(boolean allowInteractive) {
        String preferedStrategy = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("unassociatedEditorStrategy");
        IUnassociatedEditorStrategy res = null;
        UnassociatedEditorStrategyRegistry registry = IDEWorkbenchPlugin.getDefault().getUnassociatedEditorStrategyRegistry();
        if (allowInteractive || !registry.isInteractive(preferedStrategy)) {
            res = registry.getStrategy(preferedStrategy);
        }
        if (res == null) {
            res = new SystemEditorOrTextEditorStrategy();
        }
        return res;
    }
}

