/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.etypes.EtypesPackage;
import org.eclipse.emf.cdo.server.IPermissionManager;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerIndicationWithMonitoring;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.RWOLockManager;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTransactionIndication
extends CDOServerIndicationWithMonitoring {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CommitTransactionIndication.class);
    protected InternalCommitContext commitContext;

    public CommitTransactionIndication(CDOServerProtocol protocol) {
        super(protocol, (short)11);
    }

    protected CommitTransactionIndication(CDOServerProtocol protocol, short signalID) {
        super(protocol, signalID);
    }

    @Override
    protected InternalCDOPackageRegistry getPackageRegistry() {
        return this.commitContext.getPackageRegistry();
    }

    protected void initializeCommitContext(CDODataInput in) throws Exception {
        int viewID = in.readXInt();
        this.commitContext = this.getTransaction(viewID).createCommitContext();
    }

    @Override
    protected void indicating(CDODataInput in, OMMonitor monitor) throws Exception {
        try {
            try {
                monitor.begin(10.0);
                this.indicatingRead(in, monitor.fork(1.0));
                this.indicatingCommit(in, monitor.fork(9.0));
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (TRACER.isEnabled()) {
                    TRACER.trace((Throwable)ex);
                }
                throw WrappedException.wrap((Exception)ex);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void indicatingRead(CDODataInput in, OMMonitor monitor) throws Exception {
        this.initializeCommitContext(in);
        this.commitContext.preWrite();
        long lastUpdateTime = in.readXLong();
        int commitNumber = in.readXInt();
        String commitComment = in.readString();
        CDOBranchPoint commitMergeSource = CDOBranchUtil.readBranchPointOrNull((CDODataInput)in);
        CDOLockState[] locksOnNewObjects = new CDOLockState[in.readXInt()];
        CDOID[] idsToUnlock = new CDOID[in.readXInt()];
        InternalCDOPackageUnit[] newPackageUnits = new InternalCDOPackageUnit[in.readXInt()];
        InternalCDORevision[] newObjects = new InternalCDORevision[in.readXInt()];
        InternalCDORevisionDelta[] dirtyObjectDeltas = new InternalCDORevisionDelta[in.readXInt()];
        CDOID[] detachedObjects = new CDOID[in.readXInt()];
        monitor.begin((double)(locksOnNewObjects.length + idsToUnlock.length + newPackageUnits.length + newObjects.length + dirtyObjectDeltas.length + detachedObjects.length));
        try {
            int i;
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} locks on new objects", new Object[]{locksOnNewObjects.length});
            }
            int i2 = 0;
            while (i2 < locksOnNewObjects.length) {
                locksOnNewObjects[i2] = in.readCDOLockState();
                monitor.worked();
                ++i2;
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} IDs to unlock", new Object[]{idsToUnlock.length});
            }
            i2 = 0;
            while (i2 < idsToUnlock.length) {
                idsToUnlock[i2] = in.readCDOID();
                monitor.worked();
                ++i2;
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} new package units", new Object[]{newPackageUnits.length});
            }
            if (newPackageUnits.length != 0) {
                InternalCDOPackageRegistry packageRegistry = this.commitContext.getPackageRegistry();
                ResourceSet resourceSet = this.createResourceSet(packageRegistry);
                i = 0;
                while (i < newPackageUnits.length) {
                    newPackageUnits[i] = (InternalCDOPackageUnit)in.readCDOPackageUnit(resourceSet);
                    packageRegistry.putPackageUnit(newPackageUnits[i]);
                    monitor.worked();
                    ++i;
                }
                EMFUtil.safeResolveAll((ResourceSet)resourceSet);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} new objects", new Object[]{newObjects.length});
            }
            boolean usingEcore = false;
            boolean usingEtypes = false;
            i = 0;
            while (i < newObjects.length) {
                newObjects[i] = (InternalCDORevision)in.readCDORevision();
                EPackage ePackage = newObjects[i].getEClass().getEPackage();
                if (ePackage == EcorePackage.eINSTANCE) {
                    usingEcore = true;
                } else if (ePackage == EtypesPackage.eINSTANCE) {
                    usingEtypes = true;
                }
                monitor.worked();
                ++i;
            }
            Arrays.sort(newObjects, new Comparator<InternalCDORevision>(){

                @Override
                public int compare(InternalCDORevision r1, InternalCDORevision r2) {
                    return r1.getID().compareTo((Object)r2.getID());
                }
            });
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} dirty object deltas", new Object[]{dirtyObjectDeltas.length});
            }
            i = 0;
            while (i < dirtyObjectDeltas.length) {
                dirtyObjectDeltas[i] = (InternalCDORevisionDelta)in.readCDORevisionDelta();
                monitor.worked();
                ++i;
            }
            boolean clearResourcePathCache = in.readBoolean();
            boolean auditing = this.getRepository().isSupportingAudits();
            boolean ensuringReferentialIntegrity = this.getRepository().isEnsuringReferentialIntegrity();
            Map detachedObjectTypes = null;
            if (auditing || ensuringReferentialIntegrity) {
                detachedObjectTypes = CDOIDUtil.createMap();
            }
            CDOBranchVersion[] detachedObjectVersions = null;
            if (auditing && detachedObjects.length != 0) {
                detachedObjectVersions = new CDOBranchVersion[detachedObjects.length];
            }
            CDOBranch transactionBranch = this.commitContext.getBranchPoint().getBranch();
            int i3 = 0;
            while (i3 < detachedObjects.length) {
                CDOID id;
                detachedObjects[i3] = id = in.readCDOID();
                if (detachedObjectTypes != null) {
                    EClass eClass = (EClass)in.readCDOClassifierRefAndResolve();
                    detachedObjectTypes.put(id, eClass);
                }
                if (detachedObjectVersions != null) {
                    CDOBranch branch;
                    int version = in.readXInt();
                    if (version < 0) {
                        version = -version;
                        branch = in.readCDOBranch();
                    } else {
                        branch = transactionBranch;
                    }
                    detachedObjectVersions[i3] = branch.getVersion(version);
                }
                monitor.worked();
                ++i3;
            }
            if (detachedObjectTypes != null && detachedObjectTypes.isEmpty()) {
                detachedObjectTypes = null;
            }
            this.commitContext.setCommitNumber(commitNumber);
            this.commitContext.setLastUpdateTime(lastUpdateTime);
            this.commitContext.setClearResourcePathCache(clearResourcePathCache);
            this.commitContext.setUsingEcore(usingEcore);
            this.commitContext.setUsingEtypes(usingEtypes);
            this.commitContext.setNewPackageUnits(newPackageUnits);
            this.commitContext.setLocksOnNewObjects(locksOnNewObjects);
            this.commitContext.setNewObjects(newObjects);
            this.commitContext.setDirtyObjectDeltas(dirtyObjectDeltas);
            this.commitContext.setDetachedObjects(detachedObjects);
            this.commitContext.setDetachedObjectTypes(detachedObjectTypes);
            this.commitContext.setDetachedObjectVersions(detachedObjectVersions);
            this.commitContext.setCommitComment(commitComment);
            this.commitContext.setCommitMergeSource(commitMergeSource);
            this.commitContext.setLobs(this.getIndicationStream());
            this.commitContext.setLocksOnNewObjects(locksOnNewObjects);
            this.commitContext.setIDsToUnlock(idsToUnlock);
        }
        finally {
            monitor.done();
        }
    }

    protected void indicatingCommit(CDODataInput in, OMMonitor monitor) {
        this.getRepository().commit(this.commitContext, monitor);
    }

    @Override
    protected void indicatingFailed() {
        if (this.commitContext != null) {
            this.commitContext.postCommit(false);
            this.commitContext = null;
        }
    }

    @Override
    protected void responding(CDODataOutput out, OMMonitor monitor) throws Exception {
        boolean success = false;
        try {
            byte rollbackReason = this.commitContext.getRollbackReason();
            String rollbackMessage = this.commitContext.getRollbackMessage();
            List xRefs = this.commitContext.getXRefs();
            success = this.respondingException(out, rollbackReason, rollbackMessage, xRefs);
            if (success) {
                this.respondingResult(out);
                this.respondingMappingNewObjects(out);
                this.respondingNewLockStates(out);
                this.respondingNewPermissions(out);
            }
        }
        finally {
            this.commitContext.postCommit(success);
        }
    }

    protected boolean respondingException(CDODataOutput out, byte rollbackReason, String rollbackMessage, List<CDOIDReference> xRefs) throws Exception {
        boolean success = rollbackMessage == null;
        out.writeBoolean(success);
        if (!success) {
            out.writeByte((int)rollbackReason);
            out.writeString(rollbackMessage);
            out.writeCDOBranchPoint(this.commitContext.getBranchPoint());
            out.writeXLong(this.commitContext.getPreviousTimeStamp());
            if (xRefs != null) {
                out.writeXInt(xRefs.size());
                for (CDOIDReference xRef : xRefs) {
                    out.writeCDOIDReference(xRef);
                }
            } else {
                out.writeXInt(0);
            }
        }
        return success;
    }

    protected void respondingResult(CDODataOutput out) throws Exception {
        out.writeCDOBranchPoint(this.commitContext.getBranchPoint());
        out.writeXLong(this.commitContext.getPreviousTimeStamp());
        out.writeByte((int)this.commitContext.getSecurityImpact());
    }

    protected void respondingMappingNewObjects(CDODataOutput out) throws Exception {
        Map idMappings = this.commitContext.getIDMappings();
        for (Map.Entry entry : idMappings.entrySet()) {
            CDOID oldID = (CDOID)entry.getKey();
            CDOID newID = (CDOID)entry.getValue();
            out.writeCDOID(oldID);
            out.writeCDOID(newID);
        }
        out.writeCDOID(CDOID.NULL);
    }

    protected void respondingNewLockStates(CDODataOutput out) throws Exception {
        List newLockStates = this.commitContext.getPostCommmitLockStates();
        if (newLockStates != null) {
            out.writeXInt(newLockStates.size());
            for (RWOLockManager.LockState lockState : newLockStates) {
                CDOLockState cdoLockState = CDOLockUtil.createLockState((RWOLockManager.LockState)lockState);
                out.writeCDOLockState(cdoLockState);
            }
        } else {
            out.writeXInt(0);
        }
    }

    protected void respondingNewPermissions(CDODataOutput out) throws Exception {
        InternalSession session = this.getSession();
        IPermissionManager permissionManager = session.getManager().getPermissionManager();
        if (permissionManager != null && this.commitContext.getSecurityImpact() != 2) {
            out.writeBoolean(true);
            InternalCDORevision[] newObjects = this.commitContext.getNewObjects();
            InternalCDORevision[] dirtyObjects = this.commitContext.getDirtyObjects();
            out.writeXInt(newObjects.length + dirtyObjects.length);
            this.respondingNewPermissions(out, permissionManager, session, newObjects);
            this.respondingNewPermissions(out, permissionManager, session, dirtyObjects);
            return;
        }
        out.writeBoolean(false);
    }

    protected void respondingNewPermissions(CDODataOutput out, IPermissionManager permissionManager, InternalSession session, InternalCDORevision[] revisions) throws Exception {
        int size = revisions.length;
        if (size != 0) {
            CDOBranchPoint securityContext = this.commitContext.getBranchPoint();
            int i = 0;
            while (i < size) {
                InternalCDORevision revision = revisions[i];
                CDOPermission permission = permissionManager.getPermission((CDORevision)revision, securityContext, (ISession)session);
                out.writeCDOID(revision.getID());
                out.writeEnum((Enum)permission);
                ++i;
            }
        }
    }

    protected InternalTransaction getTransaction(int viewID) {
        InternalView view = this.getView(viewID);
        if (view instanceof InternalTransaction) {
            return (InternalTransaction)view;
        }
        throw new IllegalStateException("Illegal transaction: " + view);
    }

    private ResourceSet createResourceSet(InternalCDOPackageRegistry packageRegistry) {
        ResourceSetImpl resourceSet = new ResourceSetImpl(){

            protected void demandLoad(Resource resource) throws IOException {
            }
        };
        EcoreResourceFactoryImpl resourceFactory = new EcoreResourceFactoryImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", resourceFactory);
        resourceSet.setPackageRegistry((EPackage.Registry)packageRegistry);
        return resourceSet;
    }
}

