/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;

public abstract class AbstractMergeRunnable {
    private final boolean isLeftEditable;
    private final boolean isRightEditable;
    private final MergeMode mergeMode;
    private IDiffRelationshipComputer diffRelationshipComputer;

    public AbstractMergeRunnable(boolean isLeftEditable, boolean isRightEditable, MergeMode mergeMode, IDiffRelationshipComputer diffRelationshipComputer) {
        this.isLeftEditable = isLeftEditable;
        this.isRightEditable = isRightEditable;
        this.mergeMode = mergeMode;
        this.diffRelationshipComputer = diffRelationshipComputer;
    }

    protected boolean isLeftEditable() {
        return this.isLeftEditable;
    }

    protected boolean isRightEditable() {
        return this.isRightEditable;
    }

    protected MergeMode getMergeMode() {
        return this.mergeMode;
    }

    protected IDiffRelationshipComputer getDiffRelationshipComputer(IMerger.Registry mergerRegistry) {
        if (this.diffRelationshipComputer == null) {
            this.diffRelationshipComputer = new DiffRelationshipComputer(mergerRegistry);
        }
        this.diffRelationshipComputer.setMergerRegistry(mergerRegistry);
        return this.diffRelationshipComputer;
    }

    protected void markAllAsMerged(Collection<? extends Diff> diffToMarkAsMerged, MergeMode mode, IMerger.Registry mergerRegistry) {
        Iterator<? extends Diff> iterator = diffToMarkAsMerged.iterator();
        while (iterator.hasNext()) {
            Diff diff;
            boolean isLeftToRight = mode.isLeftToRight(diff = iterator.next(), this.isLeftEditable(), this.isRightEditable());
            this.markAsMerged(diff, mode, !isLeftToRight, mergerRegistry);
        }
    }

    protected void markAsMerged(Diff diff, MergeMode mode, boolean mergeRightToLeft, IMerger.Registry mergerRegistry) {
        if (AbstractMerger.isInTerminalState((Diff)diff)) {
            return;
        }
        IDiffRelationshipComputer computer = this.getDiffRelationshipComputer(mergerRegistry);
        if (AbstractMerger.isAccepting((Diff)diff, (boolean)mergeRightToLeft)) {
            Set implied = computer.getAllResultingMerges(diff, mergeRightToLeft);
            Set rejections = computer.getAllResultingRejections(diff, mergeRightToLeft);
            for (Diff impliedDiff : Sets.difference((Set)implied, (Set)rejections)) {
                impliedDiff.setState(DifferenceState.MERGED);
            }
            for (Diff impliedRejection : rejections) {
                impliedRejection.setState(DifferenceState.DISCARDED);
            }
        } else {
            Set implied = computer.getAllResultingMerges(diff, mergeRightToLeft);
            for (Diff impliedDiff : implied) {
                impliedDiff.setState(DifferenceState.DISCARDED);
            }
        }
    }
}

