/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gef.dot.internal.language.dot.AttrList;
import org.eclipse.gef.dot.internal.language.dot.AttrStmt;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.DotAst;
import org.eclipse.gef.dot.internal.language.dot.DotGraph;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhs;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsNode;
import org.eclipse.gef.dot.internal.language.dot.EdgeStmtNode;
import org.eclipse.gef.dot.internal.language.dot.NodeId;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.language.dot.Subgraph;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlAttr;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlContent;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlTag;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

public class DotLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    public DotLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    String image(DotAst ast) {
        return "file.png";
    }

    String image(DotGraph graph) {
        return "graph_outline.png";
    }

    String image(Subgraph graph) {
        return "subgraph.png";
    }

    String image(NodeStmt node) {
        return "node.png";
    }

    String image(EdgeStmtNode edge) {
        return "edge.png";
    }

    String image(AttrStmt attr) {
        return "attributes.png";
    }

    String image(Attribute attr) {
        return "attribute.png";
    }

    String image(AttrList attrs) {
        return "attributes.png";
    }

    String image(NodeId attrs) {
        return "id.png";
    }

    String image(EdgeRhs rhs) {
        return "rhs.png";
    }

    String image(HtmlTag htmlTag) {
        return "html_tag.png";
    }

    String image(HtmlAttr htmlAttr) {
        return "attribute.png";
    }

    String image(HtmlContent htmlContent) {
        return "html_text.png";
    }

    Object text(DotAst model) {
        return DotLabelProvider.styled(String.valueOf(model.eResource().getURI().lastSegment()) + ": File");
    }

    Object text(DotGraph graph) {
        ID name = graph.getName();
        return DotLabelProvider.styled(String.valueOf(name != null ? name.toValue() : "<?>") + ": Graph");
    }

    Object text(Subgraph graph) {
        ID name = graph.getName();
        return DotLabelProvider.styled(String.valueOf(name != null ? name.toValue() : "<?>") + ": Subgraph");
    }

    Object text(NodeStmt node) {
        return DotLabelProvider.styled(node.getNode().getName() + ": Node");
    }

    Object text(EdgeStmtNode edge) {
        String format = "%s %s [%s %s]: Edges";
        String sourceNode = edge.getNode().getName().toValue();
        EList edgeRHS = edge.getEdgeRHS();
        if (edgeRHS != null && edgeRHS.size() > 0) {
            String opLiteral = ((EdgeRhs)edge.getEdgeRHS().get(0)).getOp().getLiteral();
            int targetNodeCount = edge.getEdgeRHS().size();
            return DotLabelProvider.styled(String.format(format, sourceNode, opLiteral, targetNodeCount, targetNodeCount > 1 ? "Nodes" : "Node"));
        }
        return "<?>: Edges";
    }

    Object text(AttrStmt attr) {
        String format = "%s: Attributes";
        String attrLiteral = attr.getType().getLiteral();
        return DotLabelProvider.styled(String.format(format, attrLiteral));
    }

    Object text(Attribute attr) {
        String format = "%s = %s: Attribute";
        ID attributeValue = attr.getValue();
        String displayValue = attributeValue.getType() == ID.Type.HTML_STRING ? "<HTML-Label>" : attributeValue.toString();
        return DotLabelProvider.styled(String.format(format, attr.getName(), displayValue));
    }

    Object text(AttrList attrs) {
        String format = "%s %s: Attributes";
        int attrCount = attrs.getAttributes().size();
        return DotLabelProvider.styled(String.format(format, attrCount, attrCount > 1 ? "Attributes" : "Attribute"));
    }

    Object text(NodeId id) {
        return DotLabelProvider.styled(id.getName() + ": Node");
    }

    Object text(EdgeRhs rhs) {
        if (!(rhs instanceof EdgeRhsNode)) {
            return super.text((Object)rhs);
        }
        String format = "%s %s %s";
        String name = rhs.getOp().getName();
        String literal = rhs.getOp().getLiteral();
        Object targetNodeText = this.text(((EdgeRhsNode)rhs).getNode());
        return DotLabelProvider.styled(String.format(format, name, literal, targetNodeText));
    }

    Object text(HtmlTag htmlTag) {
        String format = htmlTag.isSelfClosing() ? "<%s/>: Tag" : "<%s>: Tag";
        return DotLabelProvider.styled(String.format(format, htmlTag.getName()));
    }

    Object text(HtmlAttr htmlAttr) {
        String format = "%s = %s: Attribute";
        return DotLabelProvider.styled(String.format(format, htmlAttr.getName(), htmlAttr.getValue()));
    }

    Object text(HtmlContent htmlContent) {
        String format = "%s: Text";
        String text = htmlContent.getText() == null ? "" : htmlContent.getText().trim();
        return DotLabelProvider.styled(String.format(format, text));
    }

    static StyledString styled(String format) {
        StyledString styled = new StyledString(format);
        int offset = format.indexOf(58);
        styled.setStyle(offset, format.length() - offset, StyledString.DECORATIONS_STYLER);
        return styled;
    }
}

