/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.persistence;

import java.util.Map;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkOptions;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkTargetDatabase;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkTargetServer;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnitProperties;
import org.eclipse.text.edits.ReplaceEdit;

public class EclipseLinkOptionsImpl
extends EclipseLinkPersistenceUnitProperties
implements EclipseLinkOptions {
    private String sessionName;
    private String sessionsXml;
    private Boolean includeDescriptorQueries;
    private String targetDatabase;
    private String targetServer;
    private String eventListener;
    private Boolean temporalMutable;

    public EclipseLinkOptionsImpl(PersistenceUnit parent) {
        super(parent);
    }

    protected void initializeProperties() {
        this.sessionName = this.getStringValue("eclipselink.session-name");
        this.sessionsXml = this.getStringValue("eclipselink.sessions-xml");
        this.includeDescriptorQueries = this.getBooleanValue("eclipselink.session.include.descriptor.queries");
        this.targetDatabase = this.getTargetDatabaseFromPersistenceXml();
        this.targetServer = this.getTargetServerFromPersistenceXml();
        this.eventListener = this.getStringValue("eclipselink.session-event-listener");
        this.temporalMutable = this.getBooleanValue("eclipselink.temporal.mutable");
    }

    protected String getTargetDatabaseFromPersistenceXml() {
        String value = this.getStringValue("eclipselink.target-database");
        if (value == null) {
            return null;
        }
        EclipseLinkTargetDatabase standardTargetDatabase = (EclipseLinkTargetDatabase)this.getEnumValue("eclipselink.target-database", EclipseLinkTargetDatabase.values());
        return standardTargetDatabase == null ? value : this.getPropertyStringValueOf(standardTargetDatabase);
    }

    protected String getTargetServerFromPersistenceXml() {
        String value = this.getStringValue("eclipselink.target-server");
        if (value == null) {
            return null;
        }
        EclipseLinkTargetServer standardTargetServer = (EclipseLinkTargetServer)this.getEnumValue("eclipselink.target-server", EclipseLinkTargetServer.values());
        return standardTargetServer == null ? value : this.getPropertyStringValueOf(standardTargetServer);
    }

    public void propertyValueChanged(String propertyName, String newValue) {
        if (propertyName.equals("eclipselink.session-name")) {
            this.sessionNameChanged(newValue);
        } else if (propertyName.equals("eclipselink.sessions-xml")) {
            this.sessionsXmlChanged(newValue);
        } else if (propertyName.equals("eclipselink.target-database")) {
            this.targetDatabaseChanged(newValue);
        } else if (propertyName.equals("eclipselink.target-server")) {
            this.targetServerChanged(newValue);
        } else if (propertyName.equals("eclipselink.session.include.descriptor.queries")) {
            this.includeDescriptorQueriesChanged(newValue);
        } else if (propertyName.equals("eclipselink.session-event-listener")) {
            this.eventListenerChanged(newValue);
        } else if (propertyName.equals("eclipselink.temporal.mutable")) {
            this.temporalMutableChanged(newValue);
        }
    }

    public void propertyRemoved(String propertyName) {
        if (propertyName.equals("eclipselink.session-name")) {
            this.sessionNameChanged(null);
        } else if (propertyName.equals("eclipselink.sessions-xml")) {
            this.sessionsXmlChanged(null);
        } else if (propertyName.equals("eclipselink.target-database")) {
            this.targetDatabaseChanged(null);
        } else if (propertyName.equals("eclipselink.target-server")) {
            this.targetServerChanged(null);
        } else if (propertyName.equals("eclipselink.session.include.descriptor.queries")) {
            this.includeDescriptorQueriesChanged(null);
        } else if (propertyName.equals("eclipselink.session-event-listener")) {
            this.eventListenerChanged(null);
        } else if (propertyName.equals("eclipselink.temporal.mutable")) {
            this.temporalMutableChanged(null);
        }
    }

    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.session-name", "sessionName");
        propertyNames.put("eclipselink.sessions-xml", "sessionsXml");
        propertyNames.put("eclipselink.session.include.descriptor.queries", "includeDescriptorQueriesy");
        propertyNames.put("eclipselink.target-database", "targetDatabase");
        propertyNames.put("eclipselink.target-server", "targetServer");
        propertyNames.put("eclipselink.session-event-listener", "eventListener");
        propertyNames.put("eclipselink.temporal.mutable", "temporalMutable");
    }

    @Override
    public String getSessionName() {
        return this.sessionName;
    }

    @Override
    public void setSessionName(String newSessionName) {
        String old = this.sessionName;
        this.sessionName = newSessionName;
        this.putProperty("sessionName", newSessionName);
        this.firePropertyChanged("sessionName", old, newSessionName);
    }

    private void sessionNameChanged(String newValue) {
        String old = this.sessionName;
        this.sessionName = newValue;
        this.firePropertyChanged("sessionName", old, newValue);
    }

    @Override
    public String getDefaultSessionName() {
        return "";
    }

    @Override
    public String getSessionsXml() {
        return this.sessionsXml;
    }

    @Override
    public void setSessionsXml(String newSessionsXml) {
        String old = this.sessionsXml;
        this.sessionsXml = newSessionsXml;
        this.putProperty("sessionsXml", newSessionsXml);
        this.firePropertyChanged("sessionsXml", old, newSessionsXml);
    }

    private void sessionsXmlChanged(String newValue) {
        String old = this.sessionsXml;
        this.sessionsXml = newValue;
        this.firePropertyChanged("sessionsXml", old, newValue);
    }

    @Override
    public String getDefaultSessionsXml() {
        return "";
    }

    @Override
    public Boolean getIncludeDescriptorQueries() {
        return this.includeDescriptorQueries;
    }

    @Override
    public void setIncludeDescriptorQueries(Boolean newIncludeDescriptorQueries) {
        Boolean old = this.includeDescriptorQueries;
        this.includeDescriptorQueries = newIncludeDescriptorQueries;
        this.putProperty("includeDescriptorQueriesy", newIncludeDescriptorQueries);
        this.firePropertyChanged("includeDescriptorQueriesy", old, newIncludeDescriptorQueries);
    }

    private void includeDescriptorQueriesChanged(String stringValue) {
        Boolean newValue = this.getBooleanValueOf(stringValue);
        Boolean old = this.includeDescriptorQueries;
        this.includeDescriptorQueries = newValue;
        this.firePropertyChanged("includeDescriptorQueriesy", old, newValue);
    }

    @Override
    public Boolean getDefaultIncludeDescriptorQueries() {
        return DEFAULT_SESSION_INCLUDE_DESCRIPTOR_QUERIES;
    }

    @Override
    public String getTargetDatabase() {
        return this.targetDatabase;
    }

    @Override
    public void setTargetDatabase(EclipseLinkTargetDatabase newTargetDatabase) {
        if (newTargetDatabase == null) {
            this.setTargetDatabase_(null);
            return;
        }
        this.setTargetDatabase_(this.getPropertyStringValueOf(newTargetDatabase));
    }

    @Override
    public void setTargetDatabase(String newTargetDatabase) {
        if (newTargetDatabase == null) {
            this.setTargetDatabase_(null);
            return;
        }
        EclipseLinkTargetDatabase customTargetDatabase = EclipseLinkTargetDatabase.getTargetDatabaseFor(newTargetDatabase);
        if (customTargetDatabase == null) {
            this.setTargetDatabase_(newTargetDatabase);
        } else {
            this.setTargetDatabase(customTargetDatabase);
        }
    }

    private void setTargetDatabase_(String newTargetDatabase) {
        String old = this.targetDatabase;
        this.targetDatabase = newTargetDatabase;
        this.putProperty("targetDatabase", newTargetDatabase);
        this.firePropertyChanged("targetDatabase", old, newTargetDatabase);
    }

    private void targetDatabaseChanged(String newValue) {
        String old = this.targetDatabase;
        this.targetDatabase = newValue;
        this.firePropertyChanged("targetDatabase", old, newValue);
    }

    @Override
    public String getDefaultTargetDatabase() {
        return DEFAULT_TARGET_DATABASE;
    }

    @Override
    public String getTargetServer() {
        return this.targetServer;
    }

    @Override
    public void setTargetServer(EclipseLinkTargetServer newTargetServer) {
        if (newTargetServer == null) {
            this.setTargetServer_(null);
            return;
        }
        this.setTargetServer_(this.getPropertyStringValueOf(newTargetServer));
    }

    @Override
    public void setTargetServer(String newTargetServer) {
        if (newTargetServer == null) {
            this.setTargetServer_(null);
            return;
        }
        EclipseLinkTargetServer customTargetServer = EclipseLinkTargetServer.getTargetServerFor(newTargetServer);
        if (customTargetServer == null) {
            this.setTargetServer_(newTargetServer);
        } else {
            this.setTargetServer(customTargetServer);
        }
    }

    private void setTargetServer_(String newTargetServer) {
        String old = this.targetServer;
        this.targetServer = newTargetServer;
        this.putProperty("targetServer", newTargetServer);
        this.firePropertyChanged("targetServer", old, newTargetServer);
    }

    private void targetServerChanged(String newValue) {
        String old = this.targetServer;
        this.targetServer = newValue;
        this.firePropertyChanged("targetServer", old, newValue);
    }

    @Override
    public String getDefaultTargetServer() {
        return DEFAULT_TARGET_SERVER;
    }

    @Override
    public String getEventListener() {
        return this.eventListener;
    }

    @Override
    public void setEventListener(String newEventListener) {
        String old = this.eventListener;
        this.eventListener = newEventListener;
        this.putProperty("eventListener", newEventListener);
        this.firePropertyChanged("eventListener", old, newEventListener);
    }

    private void eventListenerChanged(String newValue) {
        String old = this.eventListener;
        this.eventListener = newValue;
        this.firePropertyChanged("eventListener", old, newValue);
    }

    @Override
    public String getDefaultEventListener() {
        return DEFAULT_SESSION_EVENT_LISTENER;
    }

    @Override
    public Boolean getTemporalMutable() {
        return this.temporalMutable;
    }

    @Override
    public void setTemporalMutable(Boolean newTemporalMutable) {
        Boolean old = this.temporalMutable;
        this.temporalMutable = newTemporalMutable;
        this.putProperty("temporalMutable", newTemporalMutable);
        this.firePropertyChanged("temporalMutable", old, newTemporalMutable);
    }

    private void temporalMutableChanged(String stringValue) {
        Boolean newValue = this.getBooleanValueOf(stringValue);
        Boolean old = this.temporalMutable;
        this.temporalMutable = newValue;
        this.firePropertyChanged("temporalMutable", old, newValue);
    }

    @Override
    public Boolean getDefaultTemporalMutable() {
        return DEFAULT_TEMPORAL_MUTABLE;
    }

    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.createEventListenerRenameTypeEdits(originalType, newName);
    }

    protected Iterable<ReplaceEdit> createEventListenerRenameTypeEdits(IType originalType, String newName) {
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty("eclipselink.session-event-listener");
        return property != null ? property.createRenameTypeEdits(originalType, newName) : IterableTools.emptyIterable();
    }

    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.createEventListenerMoveTypeEdits(originalType, newPackage);
    }

    protected Iterable<ReplaceEdit> createEventListenerMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty("eclipselink.session-event-listener");
        return property != null ? property.createMoveTypeEdits(originalType, newPackage) : IterableTools.emptyIterable();
    }

    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.createEventListenerRenamePackageEdits(originalPackage, newName);
    }

    protected Iterable<ReplaceEdit> createEventListenerRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty("eclipselink.session-event-listener");
        return property != null ? property.createRenamePackageEdits(originalPackage, newName) : IterableTools.emptyIterable();
    }
}

