/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.tester.adapter;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuItemComponent;
import org.eclipse.jubula.rc.swing.tester.adapter.AbstractComponentAdapter;
import org.eclipse.jubula.rc.swing.tester.adapter.JMenuAdapter;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;

public class JMenuItemAdapter
extends AbstractComponentAdapter
implements IMenuItemComponent {
    private JMenuItem m_menuItem;

    public JMenuItemAdapter(Object objectToAdapt) {
        this.m_menuItem = (JMenuItem)objectToAdapt;
    }

    protected IRobot getRobot() throws RobotException {
        return this.getRobotFactory().getRobot();
    }

    public IEventThreadQueuer getEventThreadQueuer() {
        return this.getRobotFactory().getEventThreadQueuer();
    }

    public Object getRealComponent() {
        return this.m_menuItem;
    }

    public void setComponent(Object element) {
        this.m_menuItem = (JMenuItem)element;
    }

    public boolean isEnabled() {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("isEnabled", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() {
                if (JMenuItemAdapter.this.m_menuItem != null && JMenuItemAdapter.this.m_menuItem.isEnabled()) {
                    return true;
                }
                return false;
            }
        });
    }

    public String getText() {
        return (String)this.getEventThreadQueuer().invokeAndWait("getText", (IRunnable)new IRunnable<String>(){

            public String run() {
                return JMenuItemAdapter.this.m_menuItem.getText();
            }
        });
    }

    public boolean isShowing() {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("isShowing", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() {
                if (JMenuItemAdapter.this.m_menuItem != null && JMenuItemAdapter.this.m_menuItem.isShowing()) {
                    return true;
                }
                return false;
            }
        });
    }

    public boolean isExisting() {
        return this.m_menuItem != null;
    }

    public boolean isSelected() {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("isSelected", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() {
                if (JMenuItemAdapter.this.m_menuItem != null && JMenuItemAdapter.this.m_menuItem.isSelected()) {
                    return true;
                }
                return false;
            }
        });
    }

    public IMenuComponent getMenu() {
        if (this.m_menuItem instanceof JMenu) {
            return new JMenuAdapter(this.m_menuItem);
        }
        return null;
    }

    public boolean hasSubMenu() {
        return this.m_menuItem.getSubElements().length > 0;
    }

    public boolean isSeparator() {
        return this.m_menuItem == null;
    }

    public void selectMenuItem() {
        this.clickMenuItem(this.getRobot(), this.m_menuItem);
    }

    public IMenuComponent openSubMenu() {
        if (!this.m_menuItem.isEnabled()) {
            throw new StepExecutionException("menu item not enabled", EventFactory.createActionError((String)"TestErrorEvent.MenuItemNotEnabled"));
        }
        if (!(this.m_menuItem instanceof JMenu)) {
            throw new StepExecutionException("unexpected item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        JMenu menu = (JMenu)this.m_menuItem;
        this.clickMenuItem(this.getRobot(), this.m_menuItem);
        RobotTiming.sleepPostShowSubMenuItem((int)menu.getDelay());
        return this.getMenu();
    }

    private void clickMenuItem(IRobot robot, JMenuItem item) {
        if (EnvironmentUtils.isMacOS()) {
            TimeUtil.delay((long)300L);
        }
        if (!item.isEnabled()) {
            throw new StepExecutionException("menu item not enabled", EventFactory.createActionError((String)"TestErrorEvent.MenuItemNotEnabled"));
        }
        MenuSelectionManager selectionmanager = MenuSelectionManager.defaultManager();
        MenuElement[] menus = new MenuElement[]{};
        if (selectionmanager != null) {
            menus = MenuSelectionManager.defaultManager().getSelectedPath();
        }
        if (item.getParent() instanceof JPopupMenu && ((JPopupMenu)item.getParent()).getInvoker().getParent() instanceof JMenuBar) {
            if (!EnvironmentUtils.isMacOS() || menus.length > 0 && menus[0] instanceof JPopupMenu) {
                robot.click((Object)item, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED).setFirstHorizontal(false));
            } else {
                item.doClick();
            }
        } else if (!EnvironmentUtils.isMacOS() || menus.length > 0 && menus[0] instanceof JPopupMenu) {
            robot.click((Object)item, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
        } else {
            item.doClick();
        }
    }
}

