/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.references;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.references.LSSearchResult;
import org.eclipse.lsp4j.ReferenceContext;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSFindReferences
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<LanguageServiceAccessor.LSPDocumentInfo> infos;
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (part instanceof ITextEditor && !(infos = LanguageServiceAccessor.getLSPDocumentInfosFor(LSPEclipseUtils.getDocument((ITextEditor)part), capabilities -> Boolean.TRUE.equals(capabilities.getReferencesProvider()))).isEmpty()) {
            LanguageServiceAccessor.LSPDocumentInfo info = (LanguageServiceAccessor.LSPDocumentInfo)infos.iterator().next();
            ISelection sel = ((AbstractTextEditor)part).getSelectionProvider().getSelection();
            if (sel instanceof TextSelection) {
                try {
                    ReferenceParams params = new ReferenceParams();
                    params.setContext(new ReferenceContext(true));
                    params.setTextDocument(new TextDocumentIdentifier(info.getFileUri().toString()));
                    params.setPosition(LSPEclipseUtils.toPosition(((TextSelection)sel).getOffset(), info.getDocument()));
                    CompletableFuture references = info.getLanguageClient().getTextDocumentService().references(params);
                    LSSearchResult search = new LSSearchResult(references);
                    NewSearchUI.runQueryInBackground((ISearchQuery)search.getQuery());
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof ITextEditor) {
            List<LanguageServiceAccessor.LSPDocumentInfo> infos = LanguageServiceAccessor.getLSPDocumentInfosFor(LSPEclipseUtils.getDocument((ITextEditor)part), capabilities -> Boolean.TRUE.equals(capabilities.getReferencesProvider()));
            ISelection selection = ((ITextEditor)part).getSelectionProvider().getSelection();
            return !infos.isEmpty() && !selection.isEmpty() && selection instanceof ITextSelection;
        }
        return false;
    }

    public boolean isHandled() {
        return true;
    }
}

