/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.console;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.console.actions.ConsoleAction;
import org.eclipse.remote.console.actions.IConsoleActionFactory;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.internal.console.Activator;
import org.eclipse.remote.internal.console.ConsoleMessages;
import org.eclipse.remote.internal.console.TerminalConsole;
import org.eclipse.remote.internal.console.TerminalConsoleExtensionManager;
import org.eclipse.remote.internal.console.actions.ConsoleActionConnect;
import org.eclipse.remote.internal.console.actions.ConsoleActionDisconnect;
import org.eclipse.remote.internal.console.actions.ConsoleActionScrollLock;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.TerminalViewControlFactory;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.actions.CloseConsoleAction;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.UIJob;

public class TerminalConsolePage
extends Page
implements IAdaptable {
    public static final String TOOLBAR_GROUP_ID = "org.eclipse.remote.internal.terminal.console.Toolbar";
    public static final String CONTRIBUTIONS_GROUP_ID = "org.eclipse.remote.internal.terminal.console.Toolbar.contributions";
    private final ConsoleActionConnect connectAction;
    private final ConsoleActionDisconnect disconnectAction;
    private final TerminalConsole terminalConsole;
    private final String encoding;
    private Composite mainComposite;
    private ITerminalViewControl tViewCtrl;
    private Job connectTerminalJob = new ConnectTerminalJob();
    private final ITerminalListener listener = new ITerminalListener(){

        public void setState(TerminalState state) {
            if (state == TerminalState.CONNECTING || state == TerminalState.CONNECTED) {
                TerminalConsolePage.this.disconnectAction.setEnabled(true);
                TerminalConsolePage.this.connectAction.setEnabled(false);
            } else if (state == TerminalState.CLOSED) {
                TerminalConsolePage.this.disconnectAction.setEnabled(false);
                TerminalConsolePage.this.connectAction.setEnabled(true);
            }
            TerminalConsolePage.this.terminalConsole.setState(state);
        }

        public void setTerminalTitle(String title) {
        }
    };

    public TerminalConsolePage(TerminalConsole console, String encoding) {
        this.terminalConsole = console;
        this.encoding = encoding;
        this.connectAction = new ConsoleActionConnect(console);
        this.disconnectAction = new ConsoleActionDisconnect(console);
    }

    public TerminalConsole getConsole() {
        return this.terminalConsole;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        IToolBarManager toolBarManager = pageSite.getActionBars().getToolBarManager();
        toolBarManager.insertBefore("outputGroup", (IContributionItem)new GroupMarker(TOOLBAR_GROUP_ID));
        toolBarManager.appendToGroup(TOOLBAR_GROUP_ID, (IAction)this.connectAction);
        toolBarManager.appendToGroup(TOOLBAR_GROUP_ID, (IAction)this.disconnectAction);
        toolBarManager.appendToGroup(TOOLBAR_GROUP_ID, (IAction)new ConsoleActionScrollLock(this));
        toolBarManager.appendToGroup(TOOLBAR_GROUP_ID, (IAction)new CloseConsoleAction((IConsole)this.terminalConsole));
        toolBarManager.insertAfter(TOOLBAR_GROUP_ID, (IContributionItem)new GroupMarker(CONTRIBUTIONS_GROUP_ID));
        this.addToolbarContributions(toolBarManager);
    }

    private void addToolbarContributions(IToolBarManager toolBarManager) {
        String connectionType = this.terminalConsole.getConnection().getConnectionType().getId();
        List<String> actions = TerminalConsoleExtensionManager.getInstance().getActionsForType(connectionType);
        for (String id : actions) {
            ConsoleAction action;
            IConsoleActionFactory factory = TerminalConsoleExtensionManager.getInstance().getFactory(id);
            if (factory == null || (action = factory.createAction(id, connectionType, this)) == null) continue;
            toolBarManager.appendToGroup(CONTRIBUTIONS_GROUP_ID, (IAction)action);
        }
    }

    public void createControl(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        this.mainComposite.setLayout((Layout)new FillLayout());
        this.tViewCtrl = TerminalViewControlFactory.makeControl((ITerminalListener)this.listener, (Composite)this.mainComposite, (ITerminalConnector[])new ITerminalConnector[0]);
        this.tViewCtrl.setConnector(this.terminalConsole.getTerminalConnector().newPageConnector());
        try {
            this.tViewCtrl.setEncoding(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Status status = new Status(4, "org.eclipse.remote.console", NLS.bind((String)ConsoleMessages.ENCODING_UNAVAILABLE_1, (Object)this.encoding));
            Activator.log((IStatus)status);
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)ConsoleMessages.OPEN_CONSOLE_ERROR, (String)ConsoleMessages.ENCODING_UNAVAILABLE_0, (IStatus)status);
        }
        this.connectTerminalJob.schedule();
    }

    public Control getControl() {
        return this.mainComposite;
    }

    public void setFocus() {
        this.tViewCtrl.setFocus();
    }

    public void dispose() {
        this.tViewCtrl.disposeTerminal();
        super.dispose();
    }

    public TerminalState getTerminalState() {
        return this.tViewCtrl.getState();
    }

    public void connectTerminal() {
        if (!this.tViewCtrl.isConnected()) {
            this.connectTerminalJob.schedule();
        }
    }

    public void disconnectTerminal() {
        if (this.tViewCtrl.getState() != TerminalState.CLOSED) {
            this.tViewCtrl.disconnectTerminal();
        }
    }

    public void setScrollLock(boolean enabled) {
        this.tViewCtrl.setScrollLock(enabled);
    }

    public boolean getScrollLock() {
        return this.tViewCtrl.isScrollLock();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(IRemoteConnection.class)) {
            return (T)this.terminalConsole.getConnection();
        }
        if (adapter.equals(TerminalConsole.class)) {
            return (T)this.terminalConsole;
        }
        if (adapter.equals(TerminalConsolePage.class)) {
            return (T)((Object)this);
        }
        return null;
    }

    class ConnectTerminalJob
    extends UIJob {
        public ConnectTerminalJob() {
            super(ConsoleMessages.CONNECTING_TO_TERMINAL);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (TerminalConsolePage.this.tViewCtrl != null && !TerminalConsolePage.this.tViewCtrl.isDisposed()) {
                TerminalConsolePage.this.tViewCtrl.clearTerminal();
                TerminalConsolePage.this.tViewCtrl.connectTerminal();
            }
            return Status.OK_STATUS;
        }
    }
}

