/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.sapphire.Context;
import org.eclipse.sapphire.osgi.BundleLocator;
import org.osgi.framework.Bundle;

public final class BundleBasedContext
extends Context {
    private final Bundle bundle;

    public static final Context adapt(String bundleId) {
        if (bundleId == null) {
            throw new IllegalArgumentException();
        }
        return BundleBasedContext.adapt(BundleLocator.find(bundleId));
    }

    public static final Context adapt(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException();
        }
        return new BundleBasedContext(bundle);
    }

    private BundleBasedContext(Bundle bundle) {
        this.bundle = bundle;
    }

    public <T> Class<T> findClass(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.bundle.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public InputStream findResource(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        URL url = this.bundle.getResource(name);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BundleBasedContext) {
            BundleBasedContext context = (BundleBasedContext)((Object)obj);
            return this.bundle == context.bundle;
        }
        return false;
    }

    public int hashCode() {
        return this.bundle.hashCode();
    }
}

