/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.help.IContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.ISapphireEditorActionContributor;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.SapphireHelpContext;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.def.EditorPageDef;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.ui.diagram.ConnectionService;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.def.DiagramEditorPageDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramDirectEditPartEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramPageEvent;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.layout.DiagramLayoutPersistenceService;
import org.eclipse.sapphire.ui.forms.swt.ActionBridge;
import org.eclipse.sapphire.ui.forms.swt.ActionSystemPartBridge;
import org.eclipse.sapphire.ui.forms.swt.EditorPagePresentation;
import org.eclipse.sapphire.ui.forms.swt.HelpSystem;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.forms.swt.SapphireToolBarManagerActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditorFactory;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramGridLayer;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramKeyHandler;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramOutline;
import org.eclipse.sapphire.ui.swt.gef.SapphirePaletteRoot;
import org.eclipse.sapphire.ui.swt.gef.SapphirePaletteViewer;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.ContextButtonManager;
import org.eclipse.sapphire.ui.swt.gef.dnd.ObjectsTransferDropTargetListener;
import org.eclipse.sapphire.ui.swt.gef.dnd.SapphireTemplateTransferDropTargetListener;
import org.eclipse.sapphire.ui.swt.gef.internal.DiagramEditorContextMenuProvider;
import org.eclipse.sapphire.ui.swt.gef.layout.HorizontalGraphLayout;
import org.eclipse.sapphire.ui.swt.gef.layout.VerticalGraphLayout;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModelBase;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModel;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModelUtil;
import org.eclipse.sapphire.ui.swt.gef.palette.DefaultFlyoutPalettePreferences;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramConnectionEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramNodeEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.SapphireDiagramEditorEditPartFactory;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPagePresentation;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.SizeCache;
import org.eclipse.ui.internal.forms.widgets.FormHeading;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SapphireDiagramEditor
extends GraphicalEditorWithFlyoutPalette
implements ISapphireEditorActionContributor,
EditorPagePresentation {
    private final SapphireEditor editor;
    private Element element;
    private DefinitionLoader.Reference<EditorPageDef> definition;
    private SapphireDiagramEditorPagePart part;
    private DiagramLayoutPersistenceService layoutPersistenceService;
    private ConnectionService connectionService;
    private PaletteRoot root;
    private DiagramPagePresentation diagramPresentation;
    private DiagramModel diagramModel;
    private Listener layoutPersistenceServiceListener;
    private List<ISapphirePart> selectedParts = new ArrayList<ISapphirePart>();
    private List<GraphicalEditPart> selectedEditParts = null;
    private boolean editorIsDirty = false;
    private Point mouseLocation;
    private DiagramConfigurationManager configManager;
    private GraphicalViewerKeyHandler graphicalViewerKeyHandler;
    private SapphireDiagramKeyHandler diagramKeyHandler;
    private ContextButtonManager contextButtonManager = null;
    private boolean directEditingActive = false;
    private FormHeading header;
    private Composite body;
    private SizeCache bodyCache = new SizeCache();
    private SizeCache headCache = new SizeCache();
    private FormColors formColors;
    private Listener diagramEditorPagePartListener;
    private Map<String, ActionBridge> globalActions;
    private SapphireDiagramOutline diagramOutline;
    private boolean isSelectionFromPagePart = false;

    public SapphireDiagramEditor(SapphireEditor editor, Element element, DefinitionLoader.Reference<EditorPageDef> definition) {
        if (editor == null) {
            throw new IllegalArgumentException();
        }
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (definition == null) {
            throw new IllegalArgumentException();
        }
        this.editor = editor;
        this.element = element;
        this.definition = definition;
        this.part = new SapphireDiagramEditorPagePart();
        this.part.init((ISapphirePart)editor, this.element, (PartDef)this.definition.resolve(), Collections.emptyMap());
        this.part.initialize();
        String partName = ((EditorPageDef)this.definition.resolve()).getPageName().localized(CapitalizationType.TITLE_STYLE, false);
        this.setPartName(partName);
        this.connectionService = SapphireDiagramEditorFactory.getConnectionService(this.part);
        this.layoutPersistenceService = SapphireDiagramEditorFactory.getLayoutPersistenceService(this.part);
        this.configManager = new DiagramConfigurationManager(this);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.part.attach(new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphireEditorPagePart.SelectionChangedEvent) {
                    SapphireDiagramEditor.this.isSelectionFromPagePart = true;
                    SapphireDiagramEditor.this.selectParts(SapphireDiagramEditor.this.part.getSelections());
                    SapphireDiagramEditor.this.isSelectionFromPagePart = false;
                } else if (event instanceof DiagramPageEvent) {
                    SapphireDiagramEditor.this.handleDiagramPageEvent((DiagramPageEvent)event);
                } else if (event instanceof DiagramDirectEditPartEvent) {
                    SapphireDiagramEditor.this.selectAndDirectEditPart((ISapphirePart)((DiagramDirectEditPartEvent)event).part());
                }
            }
        });
        this.layoutPersistenceServiceListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof DiagramLayoutPersistenceService.DirtyStateEvent) {
                    DiagramLayoutPersistenceService.DirtyStateEvent evt = (DiagramLayoutPersistenceService.DirtyStateEvent)event;
                    if (evt.after()) {
                        SapphireDiagramEditor.this.markEditorDirty();
                    } else {
                        SapphireDiagramEditor.this.markEditorClean();
                    }
                }
            }
        };
        this.layoutPersistenceService.attach(this.layoutPersistenceServiceListener);
        this.diagramEditorPagePartListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphireEditorPagePart.PageHeaderTextEvent) {
                    SapphireDiagramEditor.this.refreshPageHeaderText();
                } else if (event instanceof SapphireEditorPagePart.PageHeaderImageEvent) {
                    SapphireDiagramEditor.this.refreshPageHeaderImage();
                } else if (event instanceof SapphireDiagramEditorPagePart.ZoomLevelEvent) {
                    SapphireDiagramEditor.this.refreshZoomLevel();
                } else if (event instanceof SapphireDiagramEditorPagePart.AutoLayoutEvent) {
                    SapphireDiagramEditor.this.autoLayout(((SapphireDiagramEditorPagePart.AutoLayoutEvent)event).horizontal());
                }
            }
        };
        this.part.attach(this.diagramEditorPagePartListener);
    }

    private void handleDiagramPageEvent(DiagramPageEvent event) {
        switch (event.getDiagramPageEventType()) {
            case GridStateChange: {
                this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)this.part.isGridVisible());
                this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)this.part.isGridVisible());
                this.getGraphicalViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(this.part.getGridUnit(), this.part.getVerticalGridUnit()));
                this.markEditorDirty();
                break;
            }
            case GuideStateChange: {
                this.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)this.part.isShowGuides());
                this.markEditorDirty();
                break;
            }
            case DiagramChange: {
                this.refreshPalette();
                break;
            }
            case DiagramSave: {
                break;
            }
            case SelectAll: {
                this.selectAll();
                break;
            }
            case SelectAllNodes: {
                this.selectAllNodes();
                break;
            }
        }
    }

    public DiagramEditorPageDef getDiagramEditorPageDef() {
        return (DiagramEditorPageDef)this.definition.resolve();
    }

    public final SapphireEditor getEditor() {
        return this.editor;
    }

    public SapphireDiagramEditorPagePart getPart() {
        return this.part;
    }

    public final Element getModelElement() {
        return this.part.getModelElement();
    }

    public DiagramLayoutPersistenceService getLayoutPersistenceService() {
        return this.layoutPersistenceService;
    }

    public ConnectionService getConnectionService() {
        return this.connectionService;
    }

    public boolean isDirty() {
        return this.editorIsDirty;
    }

    protected void markEditorDirty() {
        this.editorIsDirty = true;
        this.firePropertyChange(257);
    }

    protected void markEditorClean() {
        this.editorIsDirty = false;
        this.firePropertyChange(257);
    }

    public DefaultEditDomain getEditDomain() {
        return super.getEditDomain();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IEditorPart activeEditor;
        boolean editorIsActive = this.getSite().getPage().isPartVisible((IWorkbenchPart)this);
        if (!editorIsActive && (activeEditor = this.getSite().getPage().getActiveEditor()) != null) {
            editorIsActive = this.getSite().getPage().isPartVisible((IWorkbenchPart)activeEditor);
            if (activeEditor instanceof FormEditor && !((Object)((Object)this)).equals(((FormEditor)activeEditor).getActiveEditor())) {
                editorIsActive = false;
            }
        }
        if (editorIsActive && selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            ArrayList<ISapphirePart> partList = new ArrayList<ISapphirePart>();
            ArrayList<GraphicalEditPart> editPartList = new ArrayList<GraphicalEditPart>();
            for (Object object : structuredSelection) {
                EditPart editPart = null;
                if (object instanceof EditPart) {
                    editPart = (EditPart)object;
                } else if (object instanceof IAdaptable) {
                    editPart = (EditPart)((IAdaptable)object).getAdapter(EditPart.class);
                }
                if (editPart == null || !(editPart.getModel() instanceof DiagramModelBase)) continue;
                SapphirePart sp = ((DiagramModelBase)editPart.getModel()).getSapphirePart();
                partList.add((ISapphirePart)sp);
                editPartList.add((GraphicalEditPart)editPart);
            }
            if (!partList.isEmpty()) {
                this.selectedParts = partList;
                this.selectedEditParts = editPartList;
                if (!this.isSelectionFromPagePart) {
                    this.getPart().setSelections(partList, false);
                }
                this.updateKeyHandler();
                this.contextButtonManager.refresh();
            }
        }
    }

    private void initActions() {
        this.globalActions = new HashMap<String, ActionBridge>();
        ActionBridge selectAllBridge = new ActionBridge((Presentation)this.diagramPresentation, this.part.getAction("Sapphire.Diagram.SelectAll"));
        this.globalActions.put(ActionFactory.SELECT_ALL.getId(), selectAllBridge);
        ActionBridge deleteBridge = new ActionBridge((Presentation)this.diagramPresentation, this.part.getAction("Sapphire.Delete"));
        this.globalActions.put(ActionFactory.DELETE.getId(), deleteBridge);
        ActionBridge printBridge = new ActionBridge((Presentation)this.diagramPresentation, this.part.getAction("Sapphire.Diagram.Print"));
        this.globalActions.put(ActionFactory.PRINT.getId(), printBridge);
    }

    private void updateKeyHandler() {
        if (this.diagramKeyHandler != null) {
            this.diagramKeyHandler.dispose();
            this.diagramKeyHandler = null;
        }
        List<ISapphirePart> selectedParts = this.getSelectedParts();
        this.diagramKeyHandler = new SapphireDiagramKeyHandler(this, selectedParts);
        if (this.graphicalViewerKeyHandler == null) {
            this.graphicalViewerKeyHandler = new GraphicalViewerKeyHandler(this.getGraphicalViewer());
        }
        KeyHandler parentKeyHandler = this.graphicalViewerKeyHandler.setParent((KeyHandler)this.diagramKeyHandler);
        this.getGraphicalViewer().setKeyHandler(parentKeyHandler);
    }

    private void refreshPalette() {
        PaletteRoot pr = this.getPaletteRoot();
        if (pr instanceof SapphirePaletteRoot) {
            SapphirePaletteRoot spr = (SapphirePaletteRoot)pr;
            spr.updatePaletteEntries();
        }
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.root == null) {
            this.root = new SapphirePaletteRoot(this.part);
        }
        return this.root;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.part.saveDiagram();
            this.markEditorClean();
        }
        catch (Exception e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.getControl().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                SapphireDiagramEditor.this.setMouseLocation(e.x, e.y);
            }
        });
        viewer.setContents((Object)this.diagramModel);
        viewer.addDropTargetListener((TransferDropTargetListener)new SapphireTemplateTransferDropTargetListener(this));
        viewer.addDropTargetListener((org.eclipse.jface.util.TransferDropTargetListener)new ObjectsTransferDropTargetListener((EditPartViewer)viewer));
        this.postInit();
    }

    private void postInit() {
        for (DiagramNodeModel node : this.diagramModel.getNodes()) {
            node.handleMoveNode();
        }
        this.initActions();
        this.configureDiagramHeading();
        if (this.hasNoExistingLayout()) {
            this.getGraphicalViewer().flush();
            this.getPart().autoLayout(true);
            this.markEditorClean();
        }
    }

    private void autoLayout(boolean horizontal) {
        if (horizontal) {
            new HorizontalGraphLayout().layout(this, true);
        } else {
            new VerticalGraphLayout().layout(this, true);
        }
    }

    private boolean hasNoExistingLayout() {
        if (this.layoutPersistenceService == null) {
            return true;
        }
        List<DiagramNodeModel> nodes = this.diagramModel.getNodes();
        for (DiagramNodeModel node : nodes) {
            DiagramNodePart nodePart = node.getModelPart();
            DiagramNodeBounds bounds = nodePart.getNodeBounds();
            if (bounds.getX() != -1 && bounds.getY() != -1) continue;
            return true;
        }
        return false;
    }

    public DiagramPagePresentation getDiagramPresentation() {
        return this.diagramPresentation;
    }

    public DiagramModel getDiagramModel() {
        return this.diagramModel;
    }

    public DiagramResourceCache getResourceCache() {
        return this.diagramPresentation.getResourceCache();
    }

    public DiagramConfigurationManager getConfigurationManager() {
        return this.configManager;
    }

    public ContextButtonManager getContextButtonManager() {
        return this.contextButtonManager;
    }

    public void createPartControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FormLayout());
        this.header = new FormHeading(main, 0);
        this.formColors = new FormColors(parent.getDisplay());
        super.createPartControl(main);
        this.body = this.getGraphicalControl().getParent();
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        this.diagramPresentation = new DiagramPagePresentation((SapphirePart)this.part, this.configManager, viewer.getControl().getShell());
        this.diagramModel = new DiagramModel(this.diagramPresentation);
        viewer.setEditPartFactory((EditPartFactory)new SapphireDiagramEditorEditPartFactory(this.getConfigurationManager()));
        viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart(){

            protected GridLayer createGridLayer() {
                return new SapphireDiagramGridLayer(SapphireDiagramEditor.this.diagramModel);
            }
        });
        DiagramEditorContextMenuProvider cmProvider = new DiagramEditorContextMenuProvider(this);
        viewer.setContextMenu((MenuManager)cmProvider);
        boolean isGridVisibleInViewer = false;
        if (viewer.getProperty("SnapToGrid.isVisible") != null) {
            isGridVisibleInViewer = (Boolean)viewer.getProperty("SnapToGrid.isVisible");
        }
        if (this.part.isGridVisible() != isGridVisibleInViewer) {
            viewer.setProperty("SnapToGrid.isVisible", (Object)this.part.isGridVisible());
            viewer.setProperty("SnapToGrid.isEnabled", (Object)this.part.isGridVisible());
            viewer.setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(this.part.getGridUnit(), this.part.getVerticalGridUnit()));
        }
        boolean isShowGuidesInViewer = false;
        if (viewer.getProperty("SnapToGeometry.isEnabled") != null) {
            isShowGuidesInViewer = (Boolean)viewer.getProperty("SnapToGeometry.isEnabled");
        }
        if (this.part.isShowGuides() != isShowGuidesInViewer) {
            viewer.setProperty("SnapToGeometry.isEnabled", (Object)this.part.isShowGuides());
        }
        this.getGraphicalControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                ISapphirePart part;
                SapphireHelpContext context;
                if (SapphireDiagramEditor.this.getSelectedParts() != null && SapphireDiagramEditor.this.getSelectedParts().size() == 1 && ((context = new SapphireHelpContext((part = SapphireDiagramEditor.this.getSelectedParts().get(0)).getLocalModelElement(), null)).getText() != null || context.getRelatedTopics() != null && context.getRelatedTopics().length > 0)) {
                    org.eclipse.swt.graphics.Point point = HelpSystem.computePopUpLocation((Display)event.widget.getDisplay());
                    PlatformUI.getWorkbench().getHelpSystem().displayContext((IContext)context, point.x, point.y);
                }
            }
        });
        this.contextButtonManager = new ContextButtonManager(this);
        int zoomLevel = (Integer)this.getPart().state().getZoomLevel().content();
        double zoom = (double)zoomLevel / 100.0;
        this.getZoomManager().setZoom(zoom);
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }

            public PaletteViewer createPaletteViewer(Composite parent) {
                SapphirePaletteViewer pViewer = new SapphirePaletteViewer();
                pViewer.createControl(parent);
                this.configurePaletteViewer(pViewer);
                this.hookPaletteViewer(pViewer);
                return pViewer;
            }
        };
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return new DefaultFlyoutPalettePreferences(this.getPart().state());
    }

    public IAction getAction(String actionId) {
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            return (IAction)this.globalActions.get(ActionFactory.SELECT_ALL.getId());
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            return (IAction)this.globalActions.get(ActionFactory.DELETE.getId());
        }
        if (actionId.equals(ActionFactory.PRINT.getId())) {
            return (IAction)this.globalActions.get(ActionFactory.PRINT.getId());
        }
        return this.getActionRegistry().getAction((Object)actionId);
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            return this.getDiagramOutline();
        }
        return super.getAdapter(type);
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public List<ISapphirePart> getSelectedParts() {
        return this.selectedParts;
    }

    public List<GraphicalEditPart> getSelectedEditParts() {
        return this.selectedEditParts;
    }

    public GraphicalEditPart getGraphicalEditPart(ISapphirePart sapphirePart) {
        if (sapphirePart instanceof DiagramNodePart || sapphirePart instanceof ShapePart || sapphirePart instanceof DiagramConnectionPart) {
            GraphicalViewer viewer = this.getGraphicalViewer();
            Object editpartObj = null;
            DiagramNodePart nodePart = null;
            DiagramConnectionPart connPart = null;
            if (sapphirePart instanceof DiagramNodePart) {
                nodePart = (DiagramNodePart)sapphirePart;
                DiagramNodeModel nodeModel = this.getDiagramModel().getDiagramNodeModel(nodePart);
                editpartObj = viewer.getEditPartRegistry().get(nodeModel);
            } else if (sapphirePart instanceof ShapePart) {
                nodePart = (DiagramNodePart)sapphirePart.nearest(DiagramNodePart.class);
                DiagramNodeModel nodeModel = this.getDiagramModel().getDiagramNodeModel(nodePart);
                ShapeModel shapeModel = ShapeModelUtil.getChildShapeModel(nodeModel.getShapeModel(), (ShapePart)sapphirePart);
                editpartObj = viewer.getEditPartRegistry().get(shapeModel);
            } else if (sapphirePart instanceof DiagramConnectionPart) {
                connPart = (DiagramConnectionPart)sapphirePart;
                DiagramConnectionModel connModel = this.getDiagramModel().getDiagramConnectionModel(connPart);
                editpartObj = viewer.getEditPartRegistry().get(connModel);
            }
            return editpartObj;
        }
        return null;
    }

    public void selectAndDirectEditPart(ISapphirePart part) {
        if (part instanceof DiagramNodePart || part instanceof ShapePart || part instanceof DiagramConnectionPart) {
            GraphicalViewer viewer = this.getGraphicalViewer();
            GraphicalEditPart editpart = this.getGraphicalEditPart(part);
            ISapphirePart parentPart = part.parent();
            while (!(editpart != null && editpart.isSelectable() || parentPart == null)) {
                editpart = this.getGraphicalEditPart(parentPart);
                parentPart = parentPart.parent();
            }
            if (editpart != null) {
                viewer.flush();
                viewer.select((EditPart)editpart);
                viewer.reveal((EditPart)editpart);
                if (part instanceof DiagramNodePart) {
                    this.getDiagramModel().handleDirectEditing((DiagramNodePart)part);
                } else if (part instanceof ShapePart) {
                    this.getDiagramModel().handleDirectEditing((ShapePart)part);
                } else if (part instanceof DiagramConnectionPart) {
                    this.getDiagramModel().handleDirectEditing((DiagramConnectionPart)part);
                }
            }
        }
    }

    public void selectAll() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        for (Object obj : viewer.getEditPartRegistry().values()) {
            if (!(obj instanceof DiagramConnectionEditPart) && !(obj instanceof DiagramNodeEditPart)) continue;
            viewer.appendSelection((EditPart)obj);
        }
    }

    public void selectAllNodes() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.deselectAll();
        for (Object obj : viewer.getEditPartRegistry().values()) {
            if (!(obj instanceof DiagramNodeEditPart)) continue;
            viewer.appendSelection((EditPart)((DiagramNodeEditPart)obj));
        }
    }

    public void selectParts(List<ISapphirePart> selections) {
        boolean selectionChanged = false;
        if (this.selectedParts.size() != selections.size()) {
            selectionChanged = true;
        } else if (!this.selectedParts.containsAll(selections) || !selections.containsAll(this.selectedParts)) {
            selectionChanged = true;
        }
        if (selectionChanged) {
            GraphicalViewer viewer = this.getGraphicalViewer();
            if (selections.isEmpty()) {
                viewer.flush();
                viewer.deselectAll();
                return;
            }
            boolean first = true;
            for (ISapphirePart sapphirePart : selections) {
                GraphicalEditPart editpartObj = this.getGraphicalEditPart(sapphirePart);
                if (editpartObj == null) continue;
                if (first) {
                    viewer.flush();
                    viewer.select((EditPart)editpartObj);
                    first = false;
                } else {
                    viewer.appendSelection((EditPart)editpartObj);
                }
                viewer.reveal((EditPart)editpartObj);
            }
        }
    }

    public Point getMouseLocation() {
        if (this.mouseLocation == null) {
            this.mouseLocation = new Point();
        }
        return this.mouseLocation;
    }

    private void setMouseLocation(int x, int y) {
        this.getMouseLocation().setLocation(x, y);
        Point realLocation = this.calculateRealMouseLocation(this.getMouseLocation());
        this.part.setMouseLocation(realLocation.x, realLocation.y);
    }

    public FigureCanvas getFigureCanvas() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        return (FigureCanvas)viewer.getControl();
    }

    public double getZoomLevel() {
        ZoomManager zoomManager = this.getZoomManager();
        if (zoomManager == null) {
            return 1.0;
        }
        return Math.max(0.05, zoomManager.getZoom());
    }

    public Point calculateRealMouseLocation(Point nativeLocation) {
        Point ret = new Point(nativeLocation);
        Point viewLocation = this.getFigureCanvas().getViewport().getViewLocation();
        ret.x += viewLocation.x;
        ret.y += viewLocation.y;
        ZoomManager zoomManager = this.getZoomManager();
        if (zoomManager != null) {
            ret = ret.getScaled(1.0 / zoomManager.getZoom());
        }
        return ret;
    }

    public void dispose() {
        super.dispose();
        this.diagramPresentation.dispose();
        if (this.layoutPersistenceService != null) {
            this.layoutPersistenceService.detach(this.layoutPersistenceServiceListener);
            this.layoutPersistenceService.dispose();
        }
        this.part.detach(this.diagramEditorPagePartListener);
        Image image = this.header.getImage();
        if (image != null) {
            image.dispose();
        }
        for (ActionSystemPartBridge actionSystemPartBridge : this.globalActions.values()) {
            actionSystemPartBridge.dispose();
        }
        this.element = null;
        this.part.dispose();
        this.part = null;
        this.definition.dispose();
        this.definition = null;
    }

    public boolean isDirectEditingActive() {
        return this.directEditingActive;
    }

    public void setDirectEditingActive(boolean directEditingActive) {
        this.directEditingActive = directEditingActive;
        this.getContextButtonManager().hideContextButtonsInstantly();
    }

    private void configureDiagramHeading() {
        this.decorateHeading();
        SapphireActionGroup actions = this.part.getActions("Sapphire.Diagram.Header");
        if (actions != null && !actions.isEmpty()) {
            SapphireActionPresentationManager actionPresentationManager = new SapphireActionPresentationManager((Presentation)this.diagramPresentation, actions);
            SapphireToolBarManagerActionPresentation actionPresentation = new SapphireToolBarManagerActionPresentation(actionPresentationManager);
            actionPresentation.setToolBarManager(this.header.getToolBarManager());
            actionPresentation.render();
        }
        this.refreshPageHeaderText();
        this.refreshPageHeaderImage();
    }

    private void decorateHeading() {
        Color top = this.formColors.getColor("org.eclipse.ui.forms.H_GRADIENT_END");
        Color bot = this.formColors.getColor("org.eclipse.ui.forms.H_GRADIENT_START");
        this.header.setTextBackground(new Color[]{top, bot}, new int[]{100}, true);
        this.header.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1", this.formColors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1"));
        this.header.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", this.formColors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2"));
        this.header.putColor("org.eclipse.ui.forms.H_H_HOVER_LIGHT", this.formColors.getColor("org.eclipse.ui.forms.H_H_HOVER_LIGHT"));
        this.header.putColor("org.eclipse.ui.forms.H_H_HOVER_FULL", this.formColors.getColor("org.eclipse.ui.forms.H_H_HOVER_FULL"));
        this.header.putColor("org.eclipse.ui.forms.TB_TOGGLE", this.formColors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        this.header.putColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER", this.formColors.getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER"));
        this.header.setSeparatorVisible(true);
        this.header.setFont(JFaceResources.getHeaderFont());
        this.header.setForeground(this.formColors.getColor("org.eclipse.ui.forms.TITLE"));
    }

    private void refreshPageHeaderText() {
        this.header.setText(LabelTransformer.transform((String)this.part.getPageHeaderText(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false));
        this.header.layout();
    }

    private void refreshPageHeaderImage() {
        ImageData newImageData;
        Image oldImage = this.header.getImage();
        if (oldImage != null) {
            oldImage.dispose();
        }
        if ((newImageData = this.part.getPageHeaderImage()) == null) {
            this.header.setImage(null);
        } else {
            this.header.setImage(SwtUtil.toImageDescriptor((ImageData)newImageData).createImage());
        }
    }

    private void refreshZoomLevel() {
        int zoomLevel = this.part.getZoomLevel();
        double zoom = (double)zoomLevel / 100.0;
        this.getZoomManager().setZoom(zoom);
    }

    private ZoomManager getZoomManager() {
        return (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
    }

    private SapphireDiagramOutline getDiagramOutline() {
        RootEditPart rootEditPart;
        if (this.diagramOutline == null && this.getGraphicalViewer() != null && (rootEditPart = this.getGraphicalViewer().getRootEditPart()) instanceof ScalableFreeformRootEditPart) {
            this.diagramOutline = new SapphireDiagramOutline((ScalableFreeformRootEditPart)rootEditPart);
        }
        return this.diagramOutline;
    }

    private class FormLayout
    extends Layout
    implements ILayoutExtension {
        private FormLayout() {
        }

        public int computeMinimumWidth(Composite composite, boolean flushCache) {
            return this.computeSize((Composite)composite, (int)5, (int)-1, (boolean)flushCache).x;
        }

        public int computeMaximumWidth(Composite composite, boolean flushCache) {
            return this.computeSize((Composite)composite, (int)-1, (int)-1, (boolean)flushCache).x;
        }

        public org.eclipse.swt.graphics.Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (flushCache) {
                SapphireDiagramEditor.this.bodyCache.flush();
                SapphireDiagramEditor.this.headCache.flush();
            }
            SapphireDiagramEditor.this.bodyCache.setControl((Control)SapphireDiagramEditor.this.body);
            SapphireDiagramEditor.this.headCache.setControl((Control)SapphireDiagramEditor.this.header);
            int width = 0;
            int height = 0;
            org.eclipse.swt.graphics.Point hsize = SapphireDiagramEditor.this.headCache.computeSize(FormUtil.getWidthHint((int)wHint, (Control)SapphireDiagramEditor.this.header), -1);
            width = Math.max(hsize.x, width);
            height = hsize.y;
            boolean ignoreBody = false;
            org.eclipse.swt.graphics.Point bsize = ignoreBody ? new org.eclipse.swt.graphics.Point(0, 0) : SapphireDiagramEditor.this.bodyCache.computeSize(FormUtil.getWidthHint((int)wHint, (Control)SapphireDiagramEditor.this.body), -1);
            width = Math.max(bsize.x, width);
            return new org.eclipse.swt.graphics.Point(width, height += bsize.y);
        }

        protected void layout(Composite composite, boolean flushCache) {
            if (flushCache) {
                SapphireDiagramEditor.this.bodyCache.flush();
                SapphireDiagramEditor.this.headCache.flush();
            }
            SapphireDiagramEditor.this.bodyCache.setControl((Control)SapphireDiagramEditor.this.body);
            SapphireDiagramEditor.this.headCache.setControl((Control)SapphireDiagramEditor.this.header);
            Rectangle carea = composite.getClientArea();
            org.eclipse.swt.graphics.Point hsize = SapphireDiagramEditor.this.headCache.computeSize(carea.width, -1);
            SapphireDiagramEditor.this.headCache.setBounds(0, 0, carea.width, hsize.y);
            SapphireDiagramEditor.this.bodyCache.setBounds(0, hsize.y, carea.width, carea.height - hsize.y);
        }
    }
}

