/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.Collection;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractBinding {
    private PropertyEditorPresentation propertyEditorPresentation;
    private Control control;

    public AbstractBinding(PropertyEditorPresentation propertyEditorPresentation, Control control) {
        this.propertyEditorPresentation = propertyEditorPresentation;
        this.control = control;
        final Property property = propertyEditorPresentation.property();
        FilteredListener<PropertyEvent> propertyChangeListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                AbstractBinding.this.updateTarget();
            }
        };
        property.attach((Listener)propertyChangeListener);
        this.control.addDisposeListener(new DisposeListener((Listener)propertyChangeListener){
            private final /* synthetic */ Listener val$propertyChangeListener;
            {
                this.val$propertyChangeListener = listener;
            }

            public void widgetDisposed(DisposeEvent event) {
                property.detach(this.val$propertyChangeListener);
            }
        });
        this.initialize(this.propertyEditorPresentation, control);
        this.updateTarget();
    }

    public final PropertyEditorPresentation presentation() {
        return this.propertyEditorPresentation;
    }

    public final PropertyEditorPart part() {
        return this.propertyEditorPresentation.part();
    }

    public Property property() {
        return this.propertyEditorPresentation.property();
    }

    public final Element element() {
        return this.propertyEditorPresentation.property().element();
    }

    public final void updateModel() {
        boolean rollback = false;
        try {
            this.doUpdateModel();
        }
        catch (Exception e) {
            EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
            if (editFailedException != null) {
                rollback = true;
            }
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        if (rollback) {
            this.updateTarget();
        }
    }

    public final void updateTarget() {
        if (this.control != null) {
            if (this.control.isDisposed()) {
                return;
            }
            if (this.control.getDisplay().getThread() != Thread.currentThread()) {
                this.control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractBinding.this.updateTarget();
                    }
                });
                return;
            }
        }
        try {
            this.doUpdateTarget();
            this.updateTargetAttributes();
        }
        catch (Exception e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
    }

    public final void updateTargetAttributes() {
        if (!this.control.isDisposed()) {
            boolean enabled = this.propertyEditorPresentation.property().enabled();
            this.control.setEnabled(enabled);
            Object relatedControls = this.control.getData("related-controls");
            if (relatedControls != null) {
                if (relatedControls instanceof Control) {
                    ((Control)relatedControls).setEnabled(enabled);
                } else if (relatedControls instanceof Collection) {
                    for (Object control : (Collection)relatedControls) {
                        if (control == null) continue;
                        ((Control)control).setEnabled(enabled);
                    }
                }
            }
        }
    }

    protected void initialize(PropertyEditorPresentation propertyEditorPresentation, Control control) {
    }

    protected abstract void doUpdateTarget();

    protected abstract void doUpdateModel();
}

