/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.event.matching;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.AbstractSegmentStoreAnalysisEventBasedModule;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.internal.analysis.timing.core.event.matching.EventMatchingLatency;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentStoreFactory;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.matching.IEventMatchingKey;
import org.eclipse.tracecompass.tmf.core.event.matching.IMatchProcessingUnit;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventDependency;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class EventMatchingLatencyAnalysis
extends AbstractSegmentStoreAnalysisEventBasedModule {
    public static final String ID = "org.eclipse.tracecompass.internal.analysis.timing.core.event.matching";
    private static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();
    private static final Collection<ISegmentAspect> BASE_ASPECTS = ImmutableList.of((Object)EventMatchingTypeAspect.INSTANCE);

    @Override
    protected AbstractSegmentStoreAnalysisEventBasedModule.AbstractSegmentStoreAnalysisRequest createAnalysisRequest(ISegmentStore<ISegment> segmentStore) {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            throw new NullPointerException("The trace should not be null");
        }
        TmfEventMatching matching = new TmfEventMatching(Collections.singleton(trace), (IMatchProcessingUnit)new EventMatchingLatencyProcessing(segmentStore));
        matching.initMatching();
        return new LatencyMatchingEventRequest(segmentStore, matching);
    }

    @Override
    protected @NonNull IHTIntervalReader<@NonNull ISegment> getSegmentReader() {
        return EventMatchingLatency.MATCHING_LATENCY_READ_FACTORY;
    }

    @Override
    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SegmentStoreFactory.SegmentStoreType getSegmentStoreType() {
        return SegmentStoreFactory.SegmentStoreType.OnDisk;
    }

    @Override
    public Iterable<ISegmentAspect> getSegmentAspects() {
        return BASE_ASPECTS;
    }

    private static class EventMatchingLatencyProcessing
    implements IMatchProcessingUnit {
        private final ISegmentStore<ISegment> fSegmentStore;
        private int fCount = 0;

        public EventMatchingLatencyProcessing(ISegmentStore<ISegment> segmentStore) {
            this.fSegmentStore = segmentStore;
        }

        public void init(Collection<ITmfTrace> fTraces) {
        }

        public void addMatch(TmfEventDependency match) {
            if (match.getSource().getTrace().getHostId().equals(match.getDestination().getTrace().getHostId())) {
                return;
            }
            EventMatchingLatency segment = new EventMatchingLatency(null, match);
            this.fSegmentStore.add((Object)segment);
        }

        public void addMatch(@NonNull IEventMatchingKey eventKey, @NonNull TmfEventDependency match) {
            if (match.getSource().getTrace().getHostId().equals(match.getDestination().getTrace().getHostId())) {
                return;
            }
            ++this.fCount;
            EventMatchingLatency segment = new EventMatchingLatency(eventKey, match);
            this.fSegmentStore.add((Object)segment);
        }

        public void matchingEnded() {
        }

        public int countMatches() {
            return this.fCount;
        }
    }

    private static final class EventMatchingTypeAspect
    implements ISegmentAspect {
        public static final ISegmentAspect INSTANCE = new EventMatchingTypeAspect();

        private EventMatchingTypeAspect() {
        }

        public String getHelpText() {
            return (String)NonNullUtils.checkNotNull((Object)"The type of match that made this latency");
        }

        public String getName() {
            return (String)NonNullUtils.checkNotNull((Object)"Type");
        }

        public @Nullable Comparator<?> getComparator() {
            return null;
        }

        public @Nullable String resolve(ISegment segment) {
            if (segment instanceof EventMatchingLatency) {
                return ((EventMatchingLatency)segment).getName();
            }
            return "";
        }
    }

    private class LatencyMatchingEventRequest
    extends AbstractSegmentStoreAnalysisEventBasedModule.AbstractSegmentStoreAnalysisRequest {
        private final TmfEventMatching fMatching;

        public LatencyMatchingEventRequest(ISegmentStore<ISegment> segmentStore, TmfEventMatching matching) {
            super(EventMatchingLatencyAnalysis.this, segmentStore);
            this.fMatching = matching;
        }

        public void handleData(ITmfEvent event) {
            super.handleData(event);
            this.fMatching.matchEvent(event, event.getTrace(), NULL_MONITOR);
        }
    }
}

