/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.tools;

import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.AbstractCreationTool;

public class CreationTool
extends AbstractCreationTool {
    private final ICreationFactory m_factory;

    public CreationTool(ICreationFactory factory) {
        this.m_factory = factory;
    }

    public void activate() {
        super.activate();
        try {
            this.m_factory.activate();
        }
        catch (Throwable throwable) {
            this.getDomain().loadDefaultTool();
        }
    }

    public final ICreationFactory getFactory() {
        return this.m_factory;
    }

    protected Request createTargetRequest() {
        return new CreateRequest(this.m_factory);
    }

    protected void selectAddedObjects() {
        EditPart editPart;
        IEditPartViewer viewer;
        CreateRequest request = (CreateRequest)this.getTargetRequest();
        Object model = request.getSelectObject();
        if (model != null && (viewer = this.getViewer()) != null && (editPart = viewer.getEditPartByModel(model)) != null) {
            viewer.select(editPart);
        }
    }
}

