/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.jface;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.core.IBinding;
import org.eclipse.xwt.internal.core.Core;
import org.eclipse.xwt.internal.utils.ObjectUtil;
import org.eclipse.xwt.internal.utils.UserData;
import org.eclipse.xwt.jface.TextCellEditor;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.metadata.IProperty;

public class JFacesHelper {
    private static Class<?>[] JFACES_SUPPORTED_ELEMENTS;
    private static Class<?> JFACES_VIEWER;

    static {
        ArrayList collector = new ArrayList();
        try {
            String[] jfaceClasses;
            JFACES_VIEWER = Class.forName("org.eclipse.jface.viewers.Viewer");
            String[] stringArray = jfaceClasses = new String[]{"org.eclipse.xwt.jface.RadioGroupViewer", "org.eclipse.jface.viewers.ComboViewer", "org.eclipse.jface.viewers.ListViewer", "org.eclipse.jface.viewers.TreeViewer", "org.eclipse.jface.viewers.TableViewer", "org.eclipse.jface.viewers.TableTreeViewer", "org.eclipse.jface.viewers.CheckboxTableViewer", "org.eclipse.jface.viewers.CheckboxTreeViewer", "org.eclipse.jface.dialogs.TrayDialog", "org.eclipse.jface.dialogs.TitleAreaDialog", "org.eclipse.jface.viewers.CellEditor", "org.eclipse.jface.viewers.ComboBoxViewerCellEditor", TextCellEditor.class.getName(), CheckboxCellEditor.class.getName()};
            int n = jfaceClasses.length;
            int n2 = 0;
            while (n2 < n) {
                String clazz = stringArray[n2];
                try {
                    collector.add(Class.forName(clazz));
                }
                catch (Throwable e) {
                    System.out.println("No JFaces support for " + clazz);
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("No JFaces support");
        }
        JFACES_SUPPORTED_ELEMENTS = collector.toArray(new Class[collector.size()]);
    }

    public static Class<?>[] getSupportedElements() {
        return JFACES_SUPPORTED_ELEMENTS;
    }

    public static boolean isViewer(Object obj) {
        if (JFACES_VIEWER == null || obj == null) {
            return false;
        }
        return JFACES_VIEWER.isAssignableFrom(obj.getClass());
    }

    public static Control getControl(Object obj) {
        if (!JFacesHelper.isViewer(obj)) {
            throw new XWTException("Expecting a JFaces viewer:" + obj);
        }
        try {
            Method method = JFACES_VIEWER.getMethod("getControl", new Class[0]);
            return (Control)method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getViewerProperties(Viewer viewer) {
        String path;
        if (viewer instanceof ColumnViewer) {
            ColumnViewer columnViewer = (ColumnViewer)viewer;
            Object[] properties = columnViewer.getColumnProperties();
            String[] propertyNames = Core.EMPTY_STRING_ARRAY;
            if (properties != null) {
                int size = 0;
                int i = 0;
                while (i < properties.length) {
                    if (properties[i] != null) {
                        ++size;
                    }
                    ++i;
                }
                propertyNames = new String[size];
                i = 0;
                int j = 0;
                while (i < properties.length) {
                    if (properties[i] != null) {
                        propertyNames[j++] = properties[i].toString();
                    }
                    ++i;
                }
            }
            if (propertyNames.length != 0) {
                return propertyNames;
            }
        }
        if ((path = (String)UserData.getLocalData((Object)viewer, "_XWT.TableViewerColumnDisplayPath")) != null) {
            return new String[]{path};
        }
        return Core.EMPTY_STRING_ARRAY;
    }

    public static Object getColumnObject(Object element, int columnIndex, Object[] properties) {
        String propertyName;
        Object propertyElement;
        if (element == null) {
            return null;
        }
        Object dataContext = element;
        if (properties != null && columnIndex < properties.length && (propertyElement = properties[columnIndex]) != null && (propertyName = propertyElement.toString()) != null) {
            try {
                IMetaclass metaclass = XWT.getMetaclass(dataContext);
                IProperty property = metaclass.findProperty(propertyName.toLowerCase());
                if (property != null && (dataContext = property.getValue(dataContext)) != null) {
                    Class<?> type = dataContext.getClass();
                    Class<?> propertyType = property.getType();
                    if (propertyType != null && !propertyType.isAssignableFrom(type)) {
                        dataContext = ObjectUtil.resolveValue(dataContext, type, propertyType, dataContext);
                    }
                }
            }
            catch (Exception e) {
                throw new XWTException(e);
            }
        }
        return dataContext;
    }

    public static String getColumnText(Viewer viewer, Object element, int columnIndex) {
        Object[] propertyNames = JFacesHelper.getViewerProperties(viewer);
        return JFacesHelper.getColumnText(viewer, element, columnIndex, propertyNames);
    }

    public static String getColumnText(Viewer viewer, Object element, int columnIndex, Object[] properties) {
        Object value = JFacesHelper.getColumnObject(element, columnIndex, properties);
        try {
            if (viewer instanceof TableViewer) {
                Table table = ((TableViewer)viewer).getTable();
                TableColumn[] columns = table.getColumns();
                TableColumn column = columns[columnIndex];
                if (UserData.hasLocalData((Object)column, "_XWT.TableViewerColumnItemText")) {
                    Object userDataValue = UserData.getLocalData((Object)column, "_XWT.TableViewerColumnItemText");
                    if (userDataValue instanceof IBinding) {
                        IBinding binding = (IBinding)userDataValue;
                        binding.reset();
                        UserData.setDataContext(column, value);
                        value = binding.getValue(null);
                    } else {
                        value = userDataValue;
                    }
                } else if (UserData.hasLocalData((Object)column, "_XWT.TableViewerColumnItemImage")) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            throw new XWTException(e);
        }
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    public static Image getColumnImage(Viewer viewer, Object element, int columnIndex) {
        Object[] propertyNames = JFacesHelper.getViewerProperties(viewer);
        return JFacesHelper.getColumnImage(viewer, element, columnIndex, propertyNames);
    }

    public static Image getColumnImage(Viewer viewer, Object element, int columnIndex, Object[] properties) {
        Object value;
        block11: {
            value = JFacesHelper.getColumnObject(element, columnIndex, properties);
            if (value == null) {
                return null;
            }
            try {
                if (!(viewer instanceof TableViewer)) break block11;
                Table table = ((TableViewer)viewer).getTable();
                TableColumn[] columns = table.getColumns();
                TableColumn column = columns[columnIndex];
                if (UserData.hasLocalData((Object)column, "_XWT.TableViewerColumnItemImage")) {
                    Object userDataValue = UserData.getLocalData((Object)column, "_XWT.TableViewerColumnItemImage");
                    if (userDataValue instanceof IBinding) {
                        IBinding binding = (IBinding)userDataValue;
                        binding.reset();
                        UserData.setDataContext(column, value);
                        value = binding.getValue(null);
                    } else {
                        value = userDataValue;
                    }
                    break block11;
                }
                return null;
            }
            catch (Exception e) {
                throw new XWTException(e);
            }
        }
        if (value instanceof IObservableValue) {
            IObservableValue observableValue = (IObservableValue)value;
            value = observableValue.getValue();
        }
        if (value instanceof Image) {
            return (Image)value;
        }
        if (value != null) {
            if ((value = ObjectUtil.resolveValue(value, Image.class, value)) == null) {
                return null;
            }
            if (value instanceof Image) {
                return (Image)value;
            }
            throw new XWTException("Converter from " + value.getClass() + " to Image is missing.");
        }
        return null;
    }
}

