/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.oda.ecore.ui.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.util.QuerySpecificationHelper;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.QueryDelegate;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.util.QueryDelegateTextViewer;
import org.eclipse.emf.oda.ecore.impl.Connection;
import org.eclipse.emf.oda.ecore.impl.Driver;
import org.eclipse.emf.oda.ecore.impl.ParameterMetaData;
import org.eclipse.emf.oda.ecore.ui.ODAEcoreUIPlugin;
import org.eclipse.emf.oda.ecore.util.StringUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreDataSetWizardPage
extends DataSetWizardPage {
    protected static String DEFAULT_MESSAGE = ODAEcoreUIPlugin.INSTANCE.getString("_UI_DefaultDataSet_message");
    protected Combo queryDelegateCombo = null;
    protected Map<String, ITextViewer> queryTextViewers = new HashMap<String, ITextViewer>();
    protected Composite queryTextViewerComposite = null;
    protected StackLayout queryTextViewerStackLayout = null;
    protected TableViewer variablesViewer = null;
    protected List<Variable> variables = new UniqueEList();
    protected Text contextTypeField = null;
    protected EClassifier contextType = null;
    protected Text resultTypeField = null;
    protected EClassifier resultType = null;
    protected Object[] classChoices = null;
    protected Object[] classifierChoices = null;

    public EcoreDataSetWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(DEFAULT_MESSAGE);
        this.setImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(ODAEcoreUIPlugin.INSTANCE.getImage("full/wizban/NewEcore")));
    }

    public EcoreDataSetWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
    }

    protected Control createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        this.createQueryDelegateControl(composite);
        this.createContextTypeControl(composite);
        this.createVariablesControl(composite);
        this.createQueryTextControl(composite);
        this.createResultTypeControl(composite);
        this.setPageComplete(false);
        return composite;
    }

    protected void createQueryDelegateControl(Composite parent) {
        Label queryDelegateLabel = new Label(parent, 0);
        queryDelegateLabel.setText(ODAEcoreUIPlugin.INSTANCE.getString("_UI_QueryDelegate_label"));
        this.queryDelegateCombo = new Combo(parent, 2056);
        this.queryDelegateCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                String queryDelegate = EcoreDataSetWizardPage.this.getQueryDelegate();
                QueryDelegateTextViewer.Factory factory = (QueryDelegateTextViewer.Factory)QueryDelegateTextViewer.Factory.Registry.INSTANCE.get((Object)queryDelegate);
                ITextViewer queryTextViewer = EcoreDataSetWizardPage.this.queryTextViewers.get(queryDelegate);
                if (queryTextViewer == null) {
                    Object object = queryTextViewer = factory != null ? factory.createTextViewer(EcoreDataSetWizardPage.this.queryTextViewerComposite, 2816) : new TextViewer(EcoreDataSetWizardPage.this.queryTextViewerComposite, 2816);
                    if (queryTextViewer.getDocument() == null) {
                        queryTextViewer.setDocument((IDocument)new Document());
                    }
                    queryTextViewer.addTextListener(new ITextListener(){

                        public void textChanged(TextEvent te) {
                            EcoreDataSetWizardPage.this.validateData();
                        }
                    });
                    EcoreDataSetWizardPage.this.queryTextViewers.put(queryDelegate, queryTextViewer);
                }
                EcoreDataSetWizardPage.this.queryTextViewerStackLayout.topControl = queryTextViewer.getTextWidget();
                EcoreDataSetWizardPage.this.queryTextViewerComposite.layout();
                EcoreDataSetWizardPage.this.validateData();
            }
        });
        for (String uri : QueryDelegate.Factory.Registry.INSTANCE.keySet()) {
            this.queryDelegateCombo.add(uri);
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.queryDelegateCombo);
    }

    protected void promptForContextTypeSelection() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new TypeLabelProvider());
        dialog.setMessage(ODAEcoreUIPlugin.INSTANCE.getString("_UI_SelectContextType"));
        dialog.setFilter("*");
        dialog.setTitle(ODAEcoreUIPlugin.INSTANCE.getString("_UI_ContextTypeSelection_title"));
        dialog.setElements(this.getClassChoices());
        if (this.contextType != null) {
            dialog.setInitialElementSelections(Collections.singletonList(this.contextType));
        }
        if (dialog.open() == 0) {
            this.setContextType((EClassifier)((EClass)dialog.getFirstResult()));
            this.validateData();
        }
    }

    protected void createContextTypeControl(Composite parent) {
        Label contextTypeLabel = new Label(parent, 0);
        contextTypeLabel.setText(ODAEcoreUIPlugin.INSTANCE.getString("_UI_ContextType_label"));
        this.contextTypeField = new Text(parent, 2056);
        this.contextTypeField.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent me) {
                EcoreDataSetWizardPage.this.promptForContextTypeSelection();
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.contextTypeField);
        Button contextTypeButton = new Button(parent, 8);
        contextTypeButton.setText(ODAEcoreUIPlugin.INSTANCE.getString("_UI_Select_label"));
        contextTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                EcoreDataSetWizardPage.this.promptForContextTypeSelection();
            }
        });
    }

    protected void createVariablesControl(Composite parent) {
        Label variablesLabel = new Label(parent, 0);
        variablesLabel.setText(ODAEcoreUIPlugin.INSTANCE.getString("_UI_Variables_label"));
        Table variablesTable = new Table(parent, 67586);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3));
        variablesTable.setLayout((Layout)tableLayout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)variablesTable);
        variablesTable.setHeaderVisible(true);
        variablesTable.setLinesVisible(true);
        TableColumn nameColumn = new TableColumn(variablesTable, 0);
        nameColumn.setText(ODAEcoreUIPlugin.INSTANCE.getString("_UI_VariableName_label"));
        TableColumn typeColumn = new TableColumn(variablesTable, 0);
        typeColumn.setText(ODAEcoreUIPlugin.INSTANCE.getString("_UI_VariableType_label"));
        this.variablesViewer = new TableViewer(variablesTable);
        this.variablesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                ITextViewer queryTextViewer = EcoreDataSetWizardPage.this.getQueryTextViewer();
                if (queryTextViewer instanceof QueryDelegateTextViewer) {
                    ((QueryDelegateTextViewer)queryTextViewer).setParameters(EcoreDataSetWizardPage.this.convertVariablesToMap(EcoreDataSetWizardPage.this.getVariables()));
                }
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }
        });
        this.variablesViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                Variable variable = (Variable)element;
                return columnIndex == 0 ? variable.getName() : StringUtil.getTypeText((EClassifier)variable.getType());
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        Composite variablesButtons = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        variablesButtons.setLayout((Layout)gridLayout);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)variablesButtons);
        Button newButton = new Button(variablesButtons, 8);
        newButton.setText(ODAEcoreUIPlugin.INSTANCE.getString("_UI_VariableNew_label"));
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                VariableSpecificationDialog dialog = new VariableSpecificationDialog(EcoreDataSetWizardPage.this.getShell());
                dialog.setTitle(ODAEcoreUIPlugin.INSTANCE.getString("_UI_VariableNew_title"));
                if (dialog.open() == 0) {
                    List<Variable> variables = EcoreDataSetWizardPage.this.getVariables();
                    variables.add((Variable)dialog.getFirstResult());
                    EcoreDataSetWizardPage.this.variablesViewer.setInput(variables);
                    EcoreDataSetWizardPage.this.validateData();
                }
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)newButton);
        final Button editButton = new Button(variablesButtons, 8);
        editButton.setText(ODAEcoreUIPlugin.INSTANCE.getString("_UI_VariableEdit_label"));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                VariableSpecificationDialog dialog = new VariableSpecificationDialog(EcoreDataSetWizardPage.this.getShell());
                dialog.setTitle(ODAEcoreUIPlugin.INSTANCE.getString("_UI_VariableEdit_title"));
                Variable variable = (Variable)((IStructuredSelection)EcoreDataSetWizardPage.this.variablesViewer.getSelection()).getFirstElement();
                dialog.setInitialName(variable.getName());
                dialog.setInitialElementSelections(Collections.singletonList(variable.getType()));
                if (dialog.open() == 0) {
                    List<Variable> variables = EcoreDataSetWizardPage.this.getVariables();
                    variables.set(variables.indexOf(variable), (Variable)dialog.getFirstResult());
                    EcoreDataSetWizardPage.this.variablesViewer.setInput(variables);
                    EcoreDataSetWizardPage.this.validateData();
                }
            }
        });
        editButton.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)editButton);
        final Button removeButton = new Button(variablesButtons, 8);
        removeButton.setText(ODAEcoreUIPlugin.INSTANCE.getString("_UI_VariableRemove_label"));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                List<Variable> variables = EcoreDataSetWizardPage.this.getVariables();
                ISelection selection = EcoreDataSetWizardPage.this.variablesViewer.getSelection();
                Iterator selections = ((IStructuredSelection)selection).iterator();
                while (selections.hasNext()) {
                    variables.remove(selections.next());
                }
                EcoreDataSetWizardPage.this.variablesViewer.setInput(variables);
                EcoreDataSetWizardPage.this.validateData();
            }
        });
        removeButton.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)removeButton);
        this.variablesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent sce) {
                IStructuredSelection selection = (IStructuredSelection)sce.getSelection();
                editButton.setEnabled(selection.size() == 1);
                removeButton.setEnabled(selection.size() > 0);
            }
        });
    }

    protected void createQueryTextControl(Composite parent) {
        Label queryTextLabel = new Label(parent, 0);
        queryTextLabel.setText(ODAEcoreUIPlugin.INSTANCE.getString("_UI_QueryText_label"));
        this.queryTextViewerComposite = new Composite(parent, 0);
        this.queryTextViewerStackLayout = new StackLayout();
        this.queryTextViewerComposite.setLayout((Layout)this.queryTextViewerStackLayout);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.queryTextViewerComposite);
    }

    protected void promptForResultTypeSelection() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new TypeLabelProvider());
        dialog.setMessage(ODAEcoreUIPlugin.INSTANCE.getString("_UI_SelectResultType"));
        dialog.setFilter("*");
        dialog.setTitle(ODAEcoreUIPlugin.INSTANCE.getString("_UI_ResultTypeSelection_title"));
        dialog.setElements(this.getClassifierChoices());
        if (this.resultType != null) {
            dialog.setInitialElementSelections(Collections.singletonList(this.resultType));
        }
        if (dialog.open() == 0) {
            this.setResultType((EClassifier)dialog.getFirstResult());
            this.validateData();
        }
    }

    protected void createResultTypeControl(Composite parent) {
        Label resultTypeLabel = new Label(parent, 0);
        resultTypeLabel.setText(ODAEcoreUIPlugin.INSTANCE.getString("_UI_ResultType_label"));
        this.resultTypeField = new Text(parent, 2056);
        this.resultTypeField.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent me) {
                EcoreDataSetWizardPage.this.promptForResultTypeSelection();
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.resultTypeField);
        Button resultTypeButton = new Button(parent, 8);
        resultTypeButton.setText(ODAEcoreUIPlugin.INSTANCE.getString("_UI_Select_label"));
        resultTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                EcoreDataSetWizardPage.this.promptForResultTypeSelection();
            }
        });
    }

    protected void initializeControl() {
        String type;
        String string;
        String context;
        DataSetDesign dataSetDesign = this.getEditingDesign();
        if (dataSetDesign == null) {
            return;
        }
        java.util.Properties properties = DesignUtil.convertDesignProperties((Properties)dataSetDesign.getPublicProperties());
        String queryDelegate = properties.getProperty("delegate");
        if (!StringUtil.isEmpty((String)queryDelegate)) {
            this.queryDelegateCombo.setText(queryDelegate);
        } else if (this.queryDelegateCombo.getItemCount() > 0) {
            this.queryDelegateCombo.setText(this.queryDelegateCombo.getItem(0));
        }
        String queryText = dataSetDesign.getQueryText();
        if (!StringUtil.isEmpty((String)queryText)) {
            this.getQueryTextViewer().getDocument().set(queryText);
        }
        if (!StringUtil.isEmpty((String)(context = properties.getProperty("context")))) {
            try {
                this.setContextType(this.getTypeFromString(context));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!StringUtil.isEmpty((String)(string = properties.getProperty("variables")))) {
            try {
                List<Variable> variables = this.getVariables();
                variables.addAll(this.getVariablesFromString(string));
                this.variablesViewer.setInput(variables);
            }
            catch (Exception variables) {
                // empty catch block
            }
        }
        if (!StringUtil.isEmpty((String)(type = properties.getProperty("type")))) {
            try {
                this.setResultType(this.getTypeFromString(type));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.validateData();
        this.setMessage(DEFAULT_MESSAGE);
    }

    protected Object[] getClassChoices() {
        if (this.classChoices == null) {
            UniqueEList.FastCompare choices = new UniqueEList.FastCompare();
            choices.addAll(EcoreUtil.getObjectsByType(Arrays.asList(this.getClassifierChoices()), (EClassifier)EcorePackage.Literals.ECLASS));
            this.classChoices = choices.toArray();
        }
        return this.classChoices;
    }

    protected Object[] getClassifierChoices() {
        if (this.classifierChoices == null) {
            UniqueEList.FastCompare choices;
            block8: {
                choices = new UniqueEList.FastCompare();
                Connection connection = null;
                try {
                    try {
                        Driver driver = new Driver();
                        connection = (Connection)driver.getConnection(null);
                        java.util.Properties properties = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.getEditingDesign().getDataSourceDesign());
                        connection.open(properties);
                        TreeIterator allContents = EcoreUtil.getAllContents((ResourceSet)connection.getResourceSet(), (boolean)true);
                        while (allContents.hasNext()) {
                            EClass eClass;
                            Object next = allContents.next();
                            if (!(next instanceof EObject) || choices.contains((Object)(eClass = ((EObject)next).eClass()))) continue;
                            choices.add((Object)eClass);
                            choices.addAll((Collection)eClass.getEAllSuperTypes());
                            for (EAttribute eAttribute : eClass.getEAllAttributes()) {
                                EDataType eType = eAttribute.getEAttributeType();
                                if (eType == null) continue;
                                choices.add((Object)eType);
                            }
                        }
                    }
                    catch (OdaException oe) {
                        oe.printStackTrace();
                        this.closeConnection((IConnection)connection);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.closeConnection((IConnection)connection);
                    throw throwable;
                }
                this.closeConnection((IConnection)connection);
            }
            this.classifierChoices = choices.toArray();
        }
        return this.classifierChoices;
    }

    protected String convertTypeToString(EClassifier type) {
        return EcoreUtil.getURI((EObject)type).toString();
    }

    protected EClassifier getTypeFromString(String string) {
        return (EClassifier)new ResourceSetImpl().getEObject(URI.createURI((String)string), true);
    }

    protected String convertVariablesToString(List<Variable> variables) {
        StringBuilder sb = new StringBuilder();
        for (Variable variable : variables) {
            sb.append(variable.getName());
            sb.append(' ');
            sb.append(this.convertTypeToString(variable.getType()));
            sb.append(' ');
        }
        return sb.toString().trim();
    }

    protected Map<String, EClassifier> convertVariablesToMap(List<Variable> variables) {
        HashMap<String, EClassifier> map = new HashMap<String, EClassifier>();
        for (Variable variable : variables) {
            map.put(variable.getName(), variable.getType());
        }
        return map;
    }

    protected List<Variable> getVariablesFromString(String string) {
        UniqueEList variables = new UniqueEList();
        String[] strings = string.split(Pattern.quote(" "));
        int i = 0;
        while (i < strings.length) {
            variables.add(new Variable(strings[i], this.getTypeFromString(strings[i + 1])));
            i += 2;
        }
        return variables;
    }

    protected String getQueryDelegate() {
        return this.queryDelegateCombo == null || this.queryDelegateCombo.isDisposed() ? null : this.queryDelegateCombo.getText();
    }

    protected List<Variable> getVariables() {
        return this.variables;
    }

    protected ITextViewer getQueryTextViewer() {
        return this.queryTextViewers.get(this.getQueryDelegate());
    }

    protected String getQueryText() {
        ITextViewer queryTextViewer = this.getQueryTextViewer();
        return queryTextViewer == null ? null : queryTextViewer.getDocument().get();
    }

    protected EClassifier getContextType() {
        return this.contextType;
    }

    protected void setContextType(EClassifier contextType) {
        ITextViewer queryTextViewer;
        this.contextType = contextType;
        if (this.contextTypeField != null) {
            this.contextTypeField.setText(StringUtil.getTypeText((EClassifier)contextType));
        }
        if ((queryTextViewer = this.getQueryTextViewer()) instanceof QueryDelegateTextViewer) {
            ((QueryDelegateTextViewer)queryTextViewer).setContext(contextType);
        }
    }

    protected EClassifier getResultType() {
        return this.resultType;
    }

    protected void setResultType(EClassifier resultType) {
        this.resultType = resultType;
        if (this.resultTypeField != null) {
            this.resultTypeField.setText(StringUtil.getTypeText((EClassifier)resultType));
        }
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (this.getControl() == null) {
            return design;
        }
        if (!this.hasValidData()) {
            return null;
        }
        this.savePage(design);
        return design;
    }

    protected boolean canLeave() {
        return this.isPageComplete();
    }

    protected void validateData() {
        boolean isValid;
        QueryDelegate.Factory factory = (QueryDelegate.Factory)QueryDelegate.Factory.Registry.INSTANCE.get((Object)this.getQueryDelegate());
        boolean bl = isValid = factory != null;
        if (factory != null) {
            EClassifier context = this.getContextType();
            boolean bl2 = isValid = context != null;
            if (isValid) {
                String queryText = this.getQueryText();
                boolean bl3 = isValid = !StringUtil.isEmpty((String)queryText);
                if (isValid) {
                    boolean bl4 = isValid = this.getResultType() != null;
                    if (isValid) {
                        try {
                            List<Variable> variables = this.getVariables();
                            Map<String, EClassifier> map = variables.isEmpty() ? null : this.convertVariablesToMap(variables);
                            factory.createQueryDelegate(context, map, queryText).prepare();
                            this.setMessage(DEFAULT_MESSAGE);
                        }
                        catch (Exception e) {
                            isValid = false;
                            Throwable cause = e.getCause();
                            this.setMessage(cause == null ? e.getLocalizedMessage() : cause.getLocalizedMessage(), 3);
                        }
                    } else {
                        this.setMessage(ODAEcoreUIPlugin.INSTANCE.getString("_UI_ResultTypeCannotBeEmpty_message"), 3);
                    }
                } else {
                    this.setMessage(ODAEcoreUIPlugin.INSTANCE.getString("_UI_QueryTextCannotBeEmpty_message"), 3);
                }
            } else {
                this.setMessage(ODAEcoreUIPlugin.INSTANCE.getString("_UI_ContextTypeCannotBeEmpty_message"), 3);
            }
        } else {
            this.setMessage(ODAEcoreUIPlugin.INSTANCE.getString("_UI_QueryDelegateCannotBeEmpty_message"), 3);
        }
        this.setPageComplete(isValid);
    }

    protected boolean hasValidData() {
        this.validateData();
        return this.canLeave();
    }

    protected void savePage(DataSetDesign dataSetDesign) {
        block5: {
            String queryText = this.getQueryText();
            dataSetDesign.setQueryText(queryText);
            IConnection connection = null;
            try {
                try {
                    Driver driver = new Driver();
                    connection = driver.getConnection(null);
                    java.util.Properties properties = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.getEditingDesign().getDataSourceDesign());
                    connection.open(properties);
                    this.updateDesign(dataSetDesign, connection, queryText);
                }
                catch (OdaException oe) {
                    dataSetDesign.setResultSets(null);
                    dataSetDesign.setParameters(null);
                    oe.printStackTrace();
                    this.closeConnection(connection);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(connection);
                throw throwable;
            }
            this.closeConnection(connection);
        }
    }

    protected void updateDesign(DataSetDesign dataSetDesign, IConnection connection, String queryText) throws OdaException {
        IQuery query = connection.newQuery(null);
        QuerySpecificationHelper helper = new QuerySpecificationHelper(null);
        QuerySpecification specification = helper.createQuerySpecification();
        specification.setProperty("delegate", (Object)this.getQueryDelegate());
        specification.setProperty("context", (Object)this.convertTypeToString(this.getContextType()));
        specification.setProperty("type", (Object)this.convertTypeToString(this.getResultType()));
        QuerySpecification querySpecification = specification;
        querySpecification.getClass();
        specification.setParameterValue(new QuerySpecification.ParameterIdentifier(querySpecification, "@target", 1), null);
        List<Variable> variables = this.getVariables();
        specification.setProperty("variables", (Object)this.convertVariablesToString(variables));
        int i = 0;
        while (i < variables.size()) {
            QuerySpecification querySpecification2 = specification;
            querySpecification2.getClass();
            specification.setParameterValue(new QuerySpecification.ParameterIdentifier(querySpecification2, variables.get(i).getName(), i + 2), null);
            ++i;
        }
        query.setSpecification(specification);
        java.util.Properties properties = new java.util.Properties();
        properties.putAll((Map<?, ?>)specification.getProperties());
        dataSetDesign.setPublicProperties(DesignUtil.convertToDesignProperties((java.util.Properties)properties));
        query.prepare(queryText);
        try {
            this.updateResultSetDesign(query.getMetaData(), dataSetDesign);
        }
        catch (OdaException oe) {
            dataSetDesign.setResultSets(null);
            oe.printStackTrace();
        }
        try {
            this.updateParameterDesign(query.getParameterMetaData(), dataSetDesign);
        }
        catch (OdaException oe) {
            dataSetDesign.setParameters(null);
            oe.printStackTrace();
        }
    }

    protected void updateResultSetDesign(IResultSetMetaData resultSetMetaData, DataSetDesign dataSetDesign) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)resultSetMetaData);
        ResultSetDefinition definition = DesignFactory.eINSTANCE.createResultSetDefinition();
        definition.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(definition);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    protected void updateParameterDesign(IParameterMetaData parameterMetaData, DataSetDesign dataSetDesign) throws OdaException {
        ParameterMode mode = DesignSessionUtil.toParameterModeDesign((int)1);
        DataSetParameters parameters = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)parameterMetaData, (ParameterMode)mode);
        dataSetDesign.setParameters(parameters);
        if (parameters == null) {
            return;
        }
        ParameterMetaData metaData = (ParameterMetaData)parameterMetaData;
        for (ParameterDefinition parameterDefinition : parameters.getParameterDefinitions()) {
            DataElementAttributes attributes = parameterDefinition.getAttributes();
            if (attributes == null || !attributes.isSetNativeDataTypeCode()) continue;
            parameterDefinition.addDefaultValue(metaData.getParameterDefaultValue(attributes.getName()));
        }
        parameters.setDerivedMetaData(true);
    }

    protected void closeConnection(IConnection connection) {
        try {
            if (connection != null && connection.isOpen()) {
                connection.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }

    protected class TypeLabelProvider
    extends LabelProvider {
        protected TypeLabelProvider() {
        }

        public String getText(Object element) {
            return StringUtil.getTypeText((EClassifier)((EClassifier)element));
        }

        public Image getImage(Object element) {
            String typeName = element instanceof EClass ? "EClass" : (element instanceof EEnum ? "EEnum" : "EDataType");
            return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/" + typeName));
        }
    }

    protected static class Variable {
        protected final String name;
        protected final EClassifier type;

        protected Variable(String name, EClassifier type) {
            this.name = name;
            this.type = type;
        }

        protected String getName() {
            return this.name;
        }

        protected EClassifier getType() {
            return this.type;
        }
    }

    protected class VariableSpecificationDialog
    extends ElementListSelectionDialog {
        protected Text nameField;
        protected String initialName;

        protected VariableSpecificationDialog(Shell shell) {
            super(shell, (ILabelProvider)new TypeLabelProvider());
            this.nameField = null;
            this.initialName = null;
            this.setMessage(ODAEcoreUIPlugin.INSTANCE.getString("_UI_SpecifyNameSelectType"));
            this.setFilter("*");
            this.setElements(EcoreDataSetWizardPage.this.getClassifierChoices());
        }

        protected void computeResult() {
            Object[] selectedElements = this.getSelectedElements();
            this.setResult(Collections.singletonList(new Variable(this.nameField.getText(), (EClassifier)selectedElements[0])));
        }

        protected Text createFilterText(Composite parent) {
            this.nameField = new Text(parent, 2048);
            this.nameField.setText(this.initialName == null ? ODAEcoreUIPlugin.INSTANCE.getString("_UI_VariableName_label") : this.initialName);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.nameField);
            return super.createFilterText(parent);
        }

        protected void setInitialName(String initialName) {
            this.initialName = initialName;
        }
    }
}

