/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.configuration.helper;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.EmbeddedStyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.resource.XtextResourceSet;

public class XtextStylesheetHelper {
    public static Resource loadStylesheet(StyleSheet stylesheet2, ResourceSet resourceSet, View contextView, Shell parentShell) {
        if (stylesheet2 instanceof StyleSheetReference) {
            return XtextStylesheetHelper.loadStylesheet((StyleSheetReference)stylesheet2, resourceSet, contextView, parentShell);
        }
        if (stylesheet2 instanceof EmbeddedStyleSheet) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public static Resource loadStylesheet(StyleSheetReference stylesheet2, ResourceSet resourceSet, View contextView, Shell parentShell) {
        Resource resource;
        URI uri;
        String path;
        if (resourceSet == null) {
            resourceSet = new XtextResourceSet();
        }
        if (!(path = stylesheet2.getPath()).endsWith(".css")) {
            if (parentShell != null) {
                MessageDialog.open((int)1, (Shell)parentShell, (String)"Stylesheet error", (String)"The stylesheet must have the *.css extension", (int)0);
            }
            return null;
        }
        if (path.startsWith("/")) {
            uri = URI.createPlatformResourceURI((String)path, (boolean)true);
        } else {
            uri = URI.createURI((String)path);
            uri = uri.resolve(contextView.eResource().getURI());
        }
        try {
            resource = resourceSet.getResource(uri, true);
        }
        catch (Exception ex) {
            resource = resourceSet.createResource(uri, "org.eclipse.wst.css.core.csssource");
        }
        return resource;
    }
}

