/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.style.impl;

import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.PageStyle;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.style.CSSPageStyle;
import org.w3c.dom.css.CSSValue;

public class CSSPageStyleDelegate
implements CSSPageStyle {
    private PageStyle pageStyle;
    private ExtendedCSSEngine engine;

    public CSSPageStyleDelegate(PageStyle pageStyle, ExtendedCSSEngine engine) {
        this.pageStyle = pageStyle;
        this.engine = engine;
    }

    @Override
    public int getCSSPageX() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.pageStyle, "pageX");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getPageStyle_PageX().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }

    @Override
    public int getCSSPageY() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.pageStyle, "pageY");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getPageStyle_PageY().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }

    @Override
    public int getCSSPageWidth() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.pageStyle, "pageWidth");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getPageStyle_PageWidth().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }

    @Override
    public int getCSSPageHeight() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.pageStyle, "pageHeight");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getPageStyle_PageHeight().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }
}

