/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.emf.commands.CreateEAnnotationCommand;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AnnotationModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AnnotationModelElementFactory;
import org.eclipse.papyrus.infra.ui.emf.databinding.AnnotationObservableValue;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;

public class LinkRouteModelElementFactory
extends AnnotationModelElementFactory {
    public static final String STYLE = "style";
    public static final String ROUTING = "routing";
    public static final String MANUAL = "Manual";
    public static final String AUTOMATIC = "Automatic";
    public static final Map<Object, LinkRouteModelElement> elements = new HashMap<Object, LinkRouteModelElement>();

    protected AnnotationModelElement doCreateFromSource(Object sourceElement, DataContextElement context) {
        View view = NotationHelper.findView((Object)sourceElement);
        if (view != null && view instanceof Edge) {
            EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)view);
            LinkRouteModelElement m = new LinkRouteModelElement((Edge)view, domain);
            elements.put(view, m);
            return m;
        }
        return null;
    }

    public static LinkRouteModelElement getElement(Object sourceElement) {
        if (elements.get(sourceElement) == null) {
            View view = NotationHelper.findView((Object)sourceElement);
            EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)view);
            LinkRouteModelElement m = new LinkRouteModelElement((Edge)view, domain);
            elements.put(view, m);
        }
        return elements.get(sourceElement);
    }

    public static boolean isRoutingNotification(Notification event) {
        return event.getNewValue() instanceof EAnnotation && ROUTING.equals(((EAnnotation)event.getNewValue()).getSource());
    }

    public static String getRoutingStyle(View view) {
        EAnnotation ea = view.getEAnnotation(ROUTING);
        if (ea != null && ea.getDetails().containsKey((Object)STYLE)) {
            return (String)ea.getDetails().get((Object)STYLE);
        }
        return AUTOMATIC;
    }

    public static boolean isAutomaticRouting(View view) {
        return AUTOMATIC.equalsIgnoreCase(LinkRouteModelElementFactory.getRoutingStyle(view));
    }

    public static void switchToManualRouting(View edge) {
        if (LinkRouteModelElementFactory.isAutomaticRouting(edge)) {
            LinkRouteModelElement element = LinkRouteModelElementFactory.getElement(edge);
            AnnotationObservableValue observable = (AnnotationObservableValue)element.getObservable(STYLE);
            observable.setValue((Object)MANUAL);
        }
    }

    public static class LinkRouteModelElement
    extends AnnotationModelElement {
        public LinkRouteModelElement(Edge source, EditingDomain domain) {
            super((EModelElement)source, domain, LinkRouteModelElementFactory.ROUTING);
        }

        public IStaticContentProvider getContentProvider(String propertyPath) {
            if (propertyPath.equals(LinkRouteModelElementFactory.STYLE)) {
                return new AbstractStaticContentProvider(){

                    public Object[] getElements() {
                        return new String[]{LinkRouteModelElementFactory.AUTOMATIC, LinkRouteModelElementFactory.MANUAL};
                    }
                };
            }
            return EmptyContentProvider.instance;
        }

        public ILabelProvider getLabelProvider(String propertyPath) {
            return new LabelProvider();
        }

        public IObservable doGetObservable(String propertyPath) {
            return new AnnotationObservableValue(this.source, this.domain, LinkRouteModelElementFactory.ROUTING, LinkRouteModelElementFactory.STYLE){

                protected Command getCommand(final Object value) {
                    return new CreateEAnnotationCommand((TransactionalEditingDomain)this.domain, this.source, LinkRouteModelElementFactory.ROUTING){

                        protected void doExecute() {
                            EAnnotation annotation = this.createEAnnotation();
                            this.replaceEannotation(annotation, this.getObject());
                            this.replaceEntry(annotation, LinkRouteModelElementFactory.STYLE, value == null ? "" : value.toString());
                        }
                    };
                }

                protected Object doGetValue() {
                    Object value = super.doGetValue();
                    if (value == null) {
                        return LinkRouteModelElementFactory.AUTOMATIC;
                    }
                    return value;
                }

                protected void doSetValue(Object value) {
                    Object oldValue = this.doGetValue();
                    Command emfCommand = this.getCommand(value);
                    if (emfCommand != null) {
                        this.domain.getCommandStack().execute(emfCommand);
                    }
                    ValueDiff createValueDiff = Diffs.createValueDiff((Object)oldValue, (Object)value);
                    this.fireValueChange(createValueDiff);
                }
            };
        }

        public boolean forceRefresh(String propertyPath) {
            return true;
        }
    }
}

