/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.internal.stereotypes;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.uml.modelrepair.internal.participants.StereotypeApplicationRepairParticipant;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.AbstractRepairAction;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.IRepairAction;
import org.eclipse.papyrus.uml.tools.helper.IProfileApplicationDelegate;
import org.eclipse.papyrus.uml.tools.helper.ProfileApplicationDelegateRegistry;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyProfileAction
extends AbstractRepairAction
implements IRepairAction.IApplyProfileAction {
    private final Resource resourceUnderRepair;
    private final Set<Package> packages;
    private Supplier<Profile> profileSupplier;
    private String label;
    private Profile appliedProfile;
    private Profile previousProfile;

    public ApplyProfileAction(Resource resourceUnderRepair, Iterable<? extends Package> packages, Profile profile, LabelProviderService labelProviderService) {
        this(resourceUnderRepair, packages, (Supplier<Profile>)Suppliers.ofInstance((Object)profile));
        this.label = NLS.bind((String)"Migrate to {0}", (Object)labelProviderService.getLabelProvider().getText((Object)profile.getDefinition()));
    }

    public ApplyProfileAction(Resource resourceUnderRepair, Iterable<? extends Package> packages, Supplier<Profile> profileSupplier) {
        super(IRepairAction.Kind.APPLY_LATEST_PROFILE_DEFINITION);
        if (Iterables.isEmpty(packages)) {
            throw new IllegalArgumentException("no packages");
        }
        this.resourceUnderRepair = resourceUnderRepair;
        this.packages = Sets.newLinkedHashSet(packages);
        this.profileSupplier = profileSupplier;
    }

    @Override
    public String getLabel() {
        return this.label != null ? this.label : super.getLabel();
    }

    public void addPackage(Package package_) {
        this.packages.add(package_);
    }

    @Override
    public boolean repair(Resource resource, EPackage profileDefinition, Collection<? extends EObject> stereotypeApplications, DiagnosticChain diagnostics, IProgressMonitor monitor) {
        boolean result = false;
        SubMonitor repairMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (this.previousProfile != null) {
            result = this.applySelectedProfile(resource, stereotypeApplications, diagnostics, (IProgressMonitor)repairMonitor.newChild(1, 0), this.previousProfile);
        }
        if (!result) {
            this.appliedProfile = (Profile)this.profileSupplier.get();
            if (this.appliedProfile != null) {
                result = this.applySelectedProfile(resource, stereotypeApplications, diagnostics, (IProgressMonitor)repairMonitor.newChild(1, 0), this.appliedProfile);
            }
        }
        repairMonitor.done();
        return result;
    }

    private boolean applySelectedProfile(Resource resource, Collection<? extends EObject> stereotypeApplications, DiagnosticChain diagnostics, IProgressMonitor monitor, Profile profile) {
        String taskName = NLS.bind((String)"Migrating stereotypes to current version of profile \"{0}\"...", (Object)profile.getName());
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)(stereotypeApplications.size() * 3 / 2));
        boolean result = false;
        StereotypeApplicationRepairParticipant.createStereotypeApplicationMigrator(resource, profile, diagnostics).migrate(stereotypeApplications, (IProgressMonitor)sub.newChild(stereotypeApplications.size()));
        for (Package next : this.packages) {
            if (sub.isCanceled()) {
                throw new OperationCanceledException();
            }
            ProfileApplication profileApplication = this.applyProfile(next, profile, (IProgressMonitor)sub.newChild(stereotypeApplications.size() / 2));
            result = profileApplication != null;
            sub.done();
        }
        return result;
    }

    protected ProfileApplication applyProfile(Package package_, Profile profile, IProgressMonitor monitor) {
        ProfileApplication result;
        monitor = SubMonitor.convert((IProgressMonitor)monitor);
        IProfileApplicationDelegate delegate = ProfileApplicationDelegateRegistry.INSTANCE.getDelegate(package_);
        ProfileApplication existing = delegate.getProfileApplication(package_, profile);
        if (existing != null) {
            delegate = ProfileApplicationDelegateRegistry.INSTANCE.getDelegate(existing);
            delegate.reapplyProfile(package_, profile, monitor);
            result = existing;
        } else {
            Package root = (Package)Iterables.getFirst((Iterable)Iterables.filter((Iterable)this.resourceUnderRepair.getContents(), Package.class), null);
            if (root != null) {
                delegate = ProfileApplicationDelegateRegistry.INSTANCE.getDelegate(root);
                delegate.applyProfile(package_, profile, root, monitor);
            } else {
                package_.applyProfile(profile);
            }
            result = delegate.getProfileApplication(package_, profile);
        }
        monitor.done();
        return result;
    }

    @Override
    public Profile getAppliedProfile() {
        return this.appliedProfile;
    }

    @Override
    public void setPreviousAppliedProfile(Profile previousProfile) {
        this.previousProfile = previousProfile;
    }
}

